/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.android;

import android.content.BroadcastReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import com.couchbase.lite.Context;
import com.couchbase.lite.NetworkReachabilityManager;
import com.couchbase.lite.android.AndroidContext;
import com.couchbase.lite.util.Log;

public class AndroidNetworkReachabilityManager
extends NetworkReachabilityManager {
    private Context context;
    private boolean listening;
    private android.content.Context wrappedContext;
    private ConnectivityBroadcastReceiver receiver;
    private State state;

    public AndroidNetworkReachabilityManager(AndroidContext context) {
        this.context = context;
        this.wrappedContext = context.getWrappedContext();
        this.receiver = new ConnectivityBroadcastReceiver();
        this.state = State.UNKNOWN;
    }

    public synchronized void startListening() {
        if (!this.listening) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            Log.v((String)"Sync", (String)"%s: startListening() registering %s with context %s", (Object[])new Object[]{this, this.receiver, this.wrappedContext});
            this.wrappedContext.registerReceiver((BroadcastReceiver)this.receiver, filter);
            this.listening = true;
        }
    }

    public synchronized void stopListening() {
        if (this.listening) {
            try {
                Log.v((String)"Sync", (String)"%s: stopListening() unregistering %s with context %s", (Object[])new Object[]{this, this.receiver, this.wrappedContext});
                this.wrappedContext.unregisterReceiver((BroadcastReceiver)this.receiver);
            }
            catch (Exception e) {
                Log.e((String)"Sync", (String)"%s: stopListening() exception unregistering %s with context %s", (Throwable)e, (Object[])new Object[]{this, this.receiver, this.wrappedContext});
            }
            this.context = null;
            this.listening = false;
        }
    }

    private class ConnectivityBroadcastReceiver
    extends BroadcastReceiver {
        private ConnectivityBroadcastReceiver() {
        }

        public void onReceive(android.content.Context context, Intent intent) {
            String action = intent.getAction();
            if (!action.equals("android.net.conn.CONNECTIVITY_CHANGE") || !AndroidNetworkReachabilityManager.this.listening) {
                return;
            }
            boolean noConnectivity = intent.getBooleanExtra("noConnectivity", false);
            if (noConnectivity) {
                AndroidNetworkReachabilityManager.this.state = State.NOT_CONNECTED;
            } else {
                AndroidNetworkReachabilityManager.this.state = State.CONNECTED;
            }
            if (AndroidNetworkReachabilityManager.this.state == State.NOT_CONNECTED) {
                AndroidNetworkReachabilityManager.this.notifyListenersNetworkUneachable();
            }
            if (AndroidNetworkReachabilityManager.this.state == State.CONNECTED) {
                AndroidNetworkReachabilityManager.this.notifyListenersNetworkReachable();
            }
        }
    }

    public static enum State {
        UNKNOWN,
        CONNECTED,
        NOT_CONNECTED;

    }
}

