/*
 * Decompiled with CFR 0.152.
 */
package com.github.oxo42.stateless4j;

import com.github.oxo42.stateless4j.OutVar;
import com.github.oxo42.stateless4j.StateConfiguration;
import com.github.oxo42.stateless4j.StateMachineConfig;
import com.github.oxo42.stateless4j.StateReference;
import com.github.oxo42.stateless4j.StateRepresentation;
import com.github.oxo42.stateless4j.delegates.Action1;
import com.github.oxo42.stateless4j.delegates.Action2;
import com.github.oxo42.stateless4j.delegates.Func;
import com.github.oxo42.stateless4j.transitions.Transition;
import com.github.oxo42.stateless4j.triggers.TriggerBehaviour;
import com.github.oxo42.stateless4j.triggers.TriggerWithParameters;
import com.github.oxo42.stateless4j.triggers.TriggerWithParameters1;
import com.github.oxo42.stateless4j.triggers.TriggerWithParameters2;
import com.github.oxo42.stateless4j.triggers.TriggerWithParameters3;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachine<S, T> {
    protected final StateMachineConfig<S, T> config;
    protected final Func<S> stateAccessor;
    protected final Action1<S> stateMutator;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Action2<S, T> unhandledTriggerAction = new Action2<S, T>(){

        @Override
        public void doIt(S state, T trigger) {
            throw new IllegalStateException(String.format("No valid leaving transitions are permitted from state '%s' for trigger '%s'. Consider ignoring the trigger.", state, trigger));
        }
    };

    public StateMachine(S intialState) {
        this(intialState, new StateMachineConfig());
    }

    public StateMachine(S initialState, StateMachineConfig<S, T> config) {
        this.config = config;
        final StateReference reference = new StateReference();
        reference.setState(initialState);
        this.stateAccessor = new Func<S>(){

            @Override
            public S call() {
                return reference.getState();
            }
        };
        this.stateMutator = new Action1<S>(){

            @Override
            public void doIt(S s) {
                reference.setState(s);
            }
        };
    }

    public StateMachine(S initialState, Func<S> stateAccessor, Action1<S> stateMutator, StateMachineConfig<S, T> config) {
        this.config = config;
        this.stateAccessor = stateAccessor;
        this.stateMutator = stateMutator;
        stateMutator.doIt(initialState);
    }

    public StateConfiguration<S, T> configure(S state) {
        return this.config.configure(state);
    }

    public S getState() {
        return this.stateAccessor.call();
    }

    private void setState(S value) {
        this.stateMutator.doIt(value);
    }

    public List<T> getPermittedTriggers() {
        return this.getCurrentRepresentation().getPermittedTriggers();
    }

    StateRepresentation<S, T> getCurrentRepresentation() {
        StateRepresentation representation = this.config.getRepresentation(this.getState());
        return representation == null ? new StateRepresentation(this.getState()) : representation;
    }

    public void fire(T trigger) {
        this.publicFire(trigger, new Object[0]);
    }

    public <TArg0> void fire(TriggerWithParameters1<TArg0, S, T> trigger, TArg0 arg0) {
        assert (trigger != null) : "trigger is null";
        this.publicFire(trigger.getTrigger(), arg0);
    }

    public <TArg0, TArg1> void fire(TriggerWithParameters2<TArg0, TArg1, S, T> trigger, TArg0 arg0, TArg1 arg1) {
        assert (trigger != null) : "trigger is null";
        this.publicFire(trigger.getTrigger(), arg0, arg1);
    }

    public <TArg0, TArg1, TArg2> void fire(TriggerWithParameters3<TArg0, TArg1, TArg2, S, T> trigger, TArg0 arg0, TArg1 arg1, TArg2 arg2) {
        assert (trigger != null) : "trigger is null";
        this.publicFire(trigger.getTrigger(), arg0, arg1, arg2);
    }

    protected void publicFire(T trigger, Object ... args) {
        OutVar destination;
        TriggerBehaviour<S, T> triggerBehaviour;
        this.logger.info("Firing " + trigger);
        TriggerWithParameters<S, T> configuration = this.config.getTriggerConfiguration(trigger);
        if (configuration != null) {
            configuration.validateParameters(args);
        }
        if ((triggerBehaviour = this.getCurrentRepresentation().tryFindHandler(trigger)) == null) {
            this.unhandledTriggerAction.doIt(this.getCurrentRepresentation().getUnderlyingState(), trigger);
            return;
        }
        S source = this.getState();
        if (triggerBehaviour.resultsInTransitionFrom(source, args, destination = new OutVar())) {
            Transition<S, T> transition = new Transition<S, T>(source, destination.get(), trigger);
            this.getCurrentRepresentation().exit(transition);
            this.setState(destination.get());
            this.getCurrentRepresentation().enter(transition, args);
        }
    }

    public void onUnhandledTrigger(Action2<S, T> unhandledTriggerAction) {
        if (unhandledTriggerAction == null) {
            throw new IllegalStateException("unhandledTriggerAction");
        }
        this.unhandledTriggerAction = unhandledTriggerAction;
    }

    public boolean isInState(S state) {
        return this.getCurrentRepresentation().isIncludedIn(state);
    }

    public boolean canFire(T trigger) {
        return this.getCurrentRepresentation().canHandle(trigger);
    }

    public String toString() {
        List<T> permittedTriggers = this.getPermittedTriggers();
        ArrayList<String> parameters = new ArrayList<String>();
        for (T tTrigger : permittedTriggers) {
            parameters.add(tTrigger.toString());
        }
        StringBuilder params = new StringBuilder();
        String delim = "";
        for (String param : parameters) {
            params.append(delim);
            params.append(param);
            delim = ", ";
        }
        return String.format("StateMachine {{ State = %s, PermittedTriggers = {{ %s }}}}", this.getState(), params.toString());
    }
}

