/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.ChangeValidator;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.SavedRevision;
import com.couchbase.lite.ValidationContext;
import com.couchbase.lite.internal.RevisionInternal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

class ValidationContextImpl
implements ValidationContext {
    private Database database;
    private RevisionInternal currentRevision;
    private RevisionInternal newRev;
    private String rejectMessage;
    private List<String> changedKeys;

    ValidationContextImpl(Database database, RevisionInternal currentRevision, RevisionInternal newRev) {
        this.database = database;
        this.currentRevision = currentRevision;
        this.newRev = newRev;
    }

    RevisionInternal getCurrentRevisionInternal() {
        if (this.currentRevision != null) {
            try {
                this.currentRevision = this.database.loadRevisionBody(this.currentRevision, EnumSet.noneOf(Database.TDContentOptions.class));
            }
            catch (CouchbaseLiteException e) {
                throw new RuntimeException(e);
            }
        }
        return this.currentRevision;
    }

    @Override
    public SavedRevision getCurrentRevision() {
        RevisionInternal cur = this.getCurrentRevisionInternal();
        return cur != null ? new SavedRevision(this.database, cur) : null;
    }

    @Override
    public List<String> getChangedKeys() {
        if (this.changedKeys == null) {
            this.changedKeys = new ArrayList<String>();
            Map<String, Object> cur = this.getCurrentRevision().getProperties();
            Map<String, Object> nuu = this.newRev.getProperties();
            for (String key : cur.keySet()) {
                if (cur.get(key).equals(nuu.get(key)) || key.equals("_rev")) continue;
                this.changedKeys.add(key);
            }
            for (String key : nuu.keySet()) {
                if (cur.get(key) != null || key.equals("_rev") || key.equals("_id")) continue;
                this.changedKeys.add(key);
            }
        }
        return this.changedKeys;
    }

    @Override
    public void reject() {
        if (this.rejectMessage == null) {
            this.rejectMessage = "invalid document";
        }
    }

    @Override
    public void reject(String message) {
        if (this.rejectMessage == null) {
            this.rejectMessage = message;
        }
    }

    @Override
    public boolean validateChanges(ChangeValidator changeValidator) {
        Map<String, Object> cur = this.getCurrentRevision().getProperties();
        Map<String, Object> nuu = this.newRev.getProperties();
        for (String key : this.getChangedKeys()) {
            if (changeValidator.validateChange(key, cur.get(key), nuu.get(key))) continue;
            this.reject(String.format("Illegal change to '%s' property", key));
            return false;
        }
        return true;
    }

    String getRejectMessage() {
        return this.rejectMessage;
    }
}

