/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.auth;

import com.couchbase.lite.auth.Authenticator;
import com.couchbase.lite.auth.BasicAuthenticator;
import com.couchbase.lite.auth.TokenAuthenticator;
import java.util.HashMap;

public class AuthenticatorFactory {
    public static Authenticator createBasicAuthenticator(String username, String password) {
        return new BasicAuthenticator(username, password);
    }

    public static Authenticator createFacebookAuthenticator(String token) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", token);
        return new TokenAuthenticator("_facebook", params);
    }

    public static Authenticator createPersonaAuthenticator(String assertion, String email) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", assertion);
        return new TokenAuthenticator("_persona", params);
    }
}

