/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.auth;

import com.couchbase.lite.auth.Authorizer;
import com.couchbase.lite.util.Log;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FacebookAuthorizer
extends Authorizer {
    public static final String LOGIN_PARAMETER_ACCESS_TOKEN = "access_token";
    public static final String QUERY_PARAMETER = "facebookAccessToken";
    public static final String QUERY_PARAMETER_EMAIL = "email";
    private static Map<List<String>, String> accessTokens;
    private String emailAddress;

    public FacebookAuthorizer(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @Override
    public boolean usesCookieBasedLogin() {
        return true;
    }

    @Override
    public Map<String, String> loginParametersForSite(URL site) {
        HashMap<String, String> loginParameters = new HashMap<String, String>();
        try {
            String accessToken = FacebookAuthorizer.accessTokenForEmailAndSite(this.emailAddress, site);
            if (accessToken != null) {
                loginParameters.put(LOGIN_PARAMETER_ACCESS_TOKEN, accessToken);
                return loginParameters;
            }
            return null;
        }
        catch (Exception e) {
            Log.e("Sync", "Error looking login parameters for site", e);
            return null;
        }
    }

    @Override
    public String loginPathForSite(URL site) {
        return "/_facebook";
    }

    public static synchronized String registerAccessToken(String accessToken, String email, String origin) {
        ArrayList<String> key = new ArrayList<String>();
        key.add(email);
        key.add(origin);
        if (accessTokens == null) {
            accessTokens = new HashMap<List<String>, String>();
        }
        Log.v("Sync", "FacebookAuthorizer registering key: %s", key);
        accessTokens.put(key, accessToken);
        return email;
    }

    public static String accessTokenForEmailAndSite(String email, URL site) {
        try {
            ArrayList<String> key = new ArrayList<String>();
            key.add(email);
            key.add(site.toExternalForm().toLowerCase());
            Log.v("Sync", "FacebookAuthorizer looking up key: %s from list of access tokens", key);
            return accessTokens.get(key);
        }
        catch (Exception e) {
            Log.e("Sync", "Error looking up access token", e);
            return null;
        }
    }
}

