/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.auth;

import com.couchbase.lite.auth.Authorizer;
import com.couchbase.lite.util.Base64;
import com.couchbase.lite.util.Log;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;

public class PersonaAuthorizer
extends Authorizer {
    public static final String LOGIN_PARAMETER_ASSERTION = "assertion";
    private static Map<List<String>, String> assertions;
    public static final String ASSERTION_FIELD_EMAIL = "email";
    public static final String ASSERTION_FIELD_ORIGIN = "origin";
    public static final String ASSERTION_FIELD_EXPIRATION = "exp";
    public static final String QUERY_PARAMETER = "personaAssertion";
    private boolean skipAssertionExpirationCheck;
    private String emailAddress;

    public PersonaAuthorizer(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public void setSkipAssertionExpirationCheck(boolean skipAssertionExpirationCheck) {
        this.skipAssertionExpirationCheck = skipAssertionExpirationCheck;
    }

    public boolean isSkipAssertionExpirationCheck() {
        return this.skipAssertionExpirationCheck;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    protected boolean isAssertionExpired(Map<String, Object> parsedAssertion) {
        Date now;
        if (this.isSkipAssertionExpirationCheck()) {
            return false;
        }
        Date exp = (Date)parsedAssertion.get(ASSERTION_FIELD_EXPIRATION);
        if (exp.before(now = new Date())) {
            Log.w("Sync", "%s assertion for %s expired: %s", this.getClass(), this.emailAddress, exp);
            return true;
        }
        return false;
    }

    public String assertionForSite(URL site) {
        String assertion = PersonaAuthorizer.assertionForEmailAndSite(this.emailAddress, site);
        if (assertion == null) {
            Log.w("Sync", "%s %s no assertion found for: %s", this.getClass(), this.emailAddress, site);
            return null;
        }
        Map<String, Object> result = PersonaAuthorizer.parseAssertion(assertion);
        if (this.isAssertionExpired(result)) {
            return null;
        }
        return assertion;
    }

    @Override
    public boolean usesCookieBasedLogin() {
        return true;
    }

    @Override
    public Map<String, String> loginParametersForSite(URL site) {
        HashMap<String, String> loginParameters = new HashMap<String, String>();
        String assertion = this.assertionForSite(site);
        if (assertion != null) {
            loginParameters.put(LOGIN_PARAMETER_ASSERTION, assertion);
            return loginParameters;
        }
        return null;
    }

    @Override
    public String loginPathForSite(URL site) {
        return "/_persona";
    }

    public static synchronized String registerAssertion(String assertion) {
        Map<String, Object> result = PersonaAuthorizer.parseAssertion(assertion);
        String email = (String)result.get(ASSERTION_FIELD_EMAIL);
        String origin = (String)result.get(ASSERTION_FIELD_ORIGIN);
        try {
            URL originURL = new URL(origin);
            if (origin == null) {
                throw new IllegalArgumentException("Invalid assertion, origin was null");
            }
            origin = originURL.toExternalForm().toLowerCase();
        }
        catch (MalformedURLException e) {
            String message = "Error registering assertion: " + assertion;
            Log.e("Sync", message, e);
            throw new IllegalArgumentException(message, e);
        }
        return PersonaAuthorizer.registerAssertion(assertion, email, origin);
    }

    public static synchronized String registerAssertion(String assertion, String email, String origin) {
        ArrayList<String> key = new ArrayList<String>();
        key.add(email);
        key.add(origin);
        if (assertions == null) {
            assertions = new HashMap<List<String>, String>();
        }
        Log.v("Sync", "PersonaAuthorizer registering key: %s", key);
        assertions.put(key, assertion);
        return email;
    }

    public static Map<String, Object> parseAssertion(String assertion) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] components = assertion.split("\\.");
        if (components.length < 4) {
            throw new IllegalArgumentException("Invalid assertion given, only " + components.length + " found.  Expected 4+");
        }
        String component1Decoded = new String(Base64.decode(components[1], 0));
        String component3Decoded = new String(Base64.decode(components[3], 0));
        try {
            ObjectMapper mapper = new ObjectMapper();
            Map component1Json = (Map)mapper.readValue(component1Decoded, Map.class);
            Map principal = (Map)component1Json.get("principal");
            result.put(ASSERTION_FIELD_EMAIL, principal.get(ASSERTION_FIELD_EMAIL));
            Map component3Json = (Map)mapper.readValue(component3Decoded, Map.class);
            result.put(ASSERTION_FIELD_ORIGIN, component3Json.get("aud"));
            Long expObject = (Long)component3Json.get(ASSERTION_FIELD_EXPIRATION);
            Date expDate = new Date(expObject);
            result.put(ASSERTION_FIELD_EXPIRATION, expDate);
        }
        catch (IOException e) {
            String message = "Error parsing assertion: " + assertion;
            Log.e("Sync", message, e);
            throw new IllegalArgumentException(message, e);
        }
        return result;
    }

    public static String assertionForEmailAndSite(String email, URL site) {
        ArrayList<String> key = new ArrayList<String>();
        key.add(email);
        key.add(site.toExternalForm().toLowerCase());
        Log.v("Sync", "PersonaAuthorizer looking up key: %s from list of assertions", key);
        return assertions.get(key);
    }
}

