/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.replicator;

import com.couchbase.lite.BlobKey;
import com.couchbase.lite.BlobStore;
import com.couchbase.lite.ChangesOptions;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.DocumentChange;
import com.couchbase.lite.Manager;
import com.couchbase.lite.ReplicationFilter;
import com.couchbase.lite.RevisionList;
import com.couchbase.lite.Status;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.replicator.Replication;
import com.couchbase.lite.replicator.ReplicationInternal;
import com.couchbase.lite.replicator.ReplicationTrigger;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.support.RemoteRequestCompletionBlock;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.URIUtils;
import com.couchbase.org.apache.http.entity.mime.MultipartEntity;
import com.couchbase.org.apache.http.entity.mime.content.FileBody;
import com.couchbase.org.apache.http.entity.mime.content.StringBody;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;

@InterfaceAudience.Private
public class PusherInternal
extends ReplicationInternal
implements Database.ChangeListener {
    private boolean createTarget;
    private boolean creatingTarget;
    private boolean observing;
    private ReplicationFilter filter;
    private boolean dontSendMultipart = false;
    SortedSet<Long> pendingSequences;
    Long maxPendingSequence;

    @InterfaceAudience.Private
    public PusherInternal(Database db, URL remote, HttpClientFactory clientFactory, ScheduledExecutorService workExecutor, Replication.Lifecycle lifecycle, Replication parentReplication) {
        super(db, remote, clientFactory, workExecutor, lifecycle, parentReplication);
    }

    @Override
    @InterfaceAudience.Public
    public boolean isPull() {
        return false;
    }

    @Override
    public boolean shouldCreateTarget() {
        return this.createTarget;
    }

    @Override
    public void setCreateTarget(boolean createTarget) {
        this.createTarget = createTarget;
    }

    @Override
    protected void stopGraceful() {
        super.stopGraceful();
        Log.d("Sync", "PusherInternal stopGraceful()");
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Log.d("Sync", "PusherInternal stopGraceful()");
                    PusherInternal.this.waitForPendingFutures();
                    PusherInternal.this.stopObserving();
                }
                catch (Exception e) {
                    Log.e("Sync", "stopGraceful.run() had exception: %s", e);
                    e.printStackTrace();
                }
                finally {
                    PusherInternal.this.triggerStopImmediate();
                }
                Log.e("Sync", "PusherInternal stopGraceful.run() finished");
            }
        }).start();
    }

    public void waitForPendingFutures() {
        try {
            if (this.batcher != null) {
                Log.d("Sync", "batcher.waitForPendingFutures()");
                this.batcher.waitForPendingFutures();
                Log.d("Sync", "/batcher.waitForPendingFutures()");
            }
            while (!this.pendingFutures.isEmpty()) {
                Future future = (Future)this.pendingFutures.take();
                try {
                    Log.d("Sync", "calling future.get() on %s", future);
                    future.get();
                    Log.d("Sync", "done calling future.get() on %s", future);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            if (this.batcher != null) {
                Log.d("Sync", "batcher.waitForPendingFutures()");
                this.batcher.waitForPendingFutures();
                Log.d("Sync", "/batcher.waitForPendingFutures()");
            }
        }
        catch (Exception e) {
            Log.e("Sync", "Exception waiting for pending futures: %s", e);
        }
    }

    @InterfaceAudience.Private
    private void addPending(RevisionInternal revisionInternal) {
        long seq = revisionInternal.getSequence();
        this.pendingSequences.add(seq);
        if (seq > this.maxPendingSequence) {
            this.maxPendingSequence = seq;
        }
    }

    @InterfaceAudience.Private
    private void removePending(RevisionInternal revisionInternal) {
        boolean wasFirst;
        long seq = revisionInternal.getSequence();
        if (this.pendingSequences == null || this.pendingSequences.isEmpty()) {
            Log.w("Sync", "%s: removePending() called w/ rev: %s, but pendingSequences empty", this, revisionInternal);
            return;
        }
        boolean bl = wasFirst = seq == this.pendingSequences.first();
        if (!this.pendingSequences.contains(seq)) {
            Log.w("Sync", "%s: removePending: sequence %s not in set, for rev %s", this, seq, revisionInternal);
        }
        this.pendingSequences.remove(seq);
        if (wasFirst) {
            long maxCompleted;
            if (this.pendingSequences.size() == 0) {
                maxCompleted = this.maxPendingSequence;
            } else {
                maxCompleted = this.pendingSequences.first();
                --maxCompleted;
            }
            this.setLastSequence(Long.toString(maxCompleted));
        }
    }

    @Override
    @InterfaceAudience.Private
    void maybeCreateRemoteDB() {
        if (!this.createTarget) {
            return;
        }
        this.creatingTarget = true;
        Log.v("Sync", "Remote db might not exist; creating it...");
        Future future = this.sendAsyncRequest("PUT", "", null, new RemoteRequestCompletionBlock(){

            @Override
            public void onCompletion(HttpResponse httpResponse, Object result, Throwable e) {
                PusherInternal.this.creatingTarget = false;
                if (e != null && e instanceof HttpResponseException && ((HttpResponseException)e).getStatusCode() != 412) {
                    Log.e("Sync", this + ": Failed to create remote db", e);
                    PusherInternal.this.setError(e);
                    PusherInternal.this.triggerStop();
                } else {
                    Log.v("Sync", "%s: Created remote db", this);
                    PusherInternal.this.createTarget = false;
                    PusherInternal.this.beginReplicating();
                }
            }
        });
        this.pendingFutures.add(future);
    }

    @Override
    @InterfaceAudience.Private
    public void beginReplicating() {
        Log.d("Sync", "%s: beginReplicating() called", this);
        if (this.creatingTarget) {
            Log.d("Sync", "%s: creatingTarget == true, doing nothing", this);
            return;
        }
        this.pendingSequences = Collections.synchronizedSortedSet(new TreeSet());
        try {
            this.maxPendingSequence = Long.parseLong(this.lastSequence);
        }
        catch (NumberFormatException e) {
            Log.w("Sync", "Error converting lastSequence: %s to long.  Using 0", this.lastSequence);
            this.maxPendingSequence = new Long(0L);
        }
        if (this.filterName != null) {
            this.filter = this.db.getFilter(this.filterName);
        }
        if (this.filterName != null && this.filter == null) {
            Log.w("Sync", "%s: No ReplicationFilter registered for filter '%s'; ignoring", this, this.filterName);
        }
        long lastSequenceLong = 0L;
        if (this.lastSequence != null) {
            lastSequenceLong = Long.parseLong(this.lastSequence);
        }
        ChangesOptions options = new ChangesOptions();
        options.setIncludeConflicts(true);
        Log.d("Sync", "%s: Getting changes since %s", this, this.lastSequence);
        RevisionList changes = this.db.changesSince(lastSequenceLong, options, this.filter);
        if (changes.size() > 0) {
            Log.d("Sync", "%s: Queuing %d changes since %s", this, changes.size(), this.lastSequence);
            this.batcher.queueObjects(changes);
            this.batcher.flush();
        } else {
            Log.d("Sync", "%s: No changes since %s", this, this.lastSequence);
        }
        if (this.isContinuous()) {
            this.observing = true;
            this.db.addChangeListener(this);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    PusherInternal.this.waitForPendingFutures();
                    PusherInternal.this.fireTrigger(ReplicationTrigger.WAITING_FOR_CHANGES);
                }
            }).start();
        } else {
            this.triggerStop();
        }
    }

    @InterfaceAudience.Private
    private void stopObserving() {
        if (this.observing) {
            this.observing = false;
            this.db.removeChangeListener(this);
        }
    }

    @Override
    protected void goOnline() {
        super.goOnline();
        Log.d("Sync", "%s: goOnline() called, calling checkSession()", this);
        this.checkSession();
    }

    @Override
    @InterfaceAudience.Private
    public void changed(Database.ChangeEvent event) {
        List<DocumentChange> changes = event.getChanges();
        for (DocumentChange change : changes) {
            URL source = change.getSourceUrl();
            if (source != null && source.equals(this.remote)) {
                return;
            }
            RevisionInternal rev = change.getAddedRevision();
            Map<String, Object> paramsFixMe = null;
            if (!this.getLocalDatabase().runFilter(this.filter, paramsFixMe, rev)) continue;
            this.addToInbox(rev);
        }
    }

    @Override
    @InterfaceAudience.Private
    protected void processInbox(final RevisionList changes) {
        HashMap<String, ArrayList<String>> diffs = new HashMap<String, ArrayList<String>>();
        for (RevisionInternal rev : changes) {
            String docID = rev.getDocId();
            ArrayList<String> revs = (ArrayList<String>)diffs.get(docID);
            if (revs == null) {
                revs = new ArrayList<String>();
                diffs.put(docID, revs);
            }
            revs.add(rev.getRevId());
            this.addPending(rev);
        }
        Log.v("Sync", "%s: posting to /_revs_diff", this);
        Future future = this.sendAsyncRequest("POST", "/_revs_diff", diffs, new RemoteRequestCompletionBlock(){

            @Override
            public void onCompletion(HttpResponse httpResponse, Object response, Throwable e) {
                Log.v("Sync", "%s: got /_revs_diff response", this);
                Map results = (Map)response;
                if (e != null) {
                    PusherInternal.this.setError(e);
                    PusherInternal.this.revisionFailed();
                } else if (results.size() != 0) {
                    ArrayList<Object> docsToSend = new ArrayList<Object>();
                    RevisionList revsToSend = new RevisionList();
                    for (RevisionInternal rev : changes) {
                        RevisionInternal loadedRev;
                        Map<String, Object> properties = null;
                        Map revResults = (Map)results.get(rev.getDocId());
                        if (revResults == null) continue;
                        List revs = (List)revResults.get("missing");
                        if (revs == null || !revs.contains(rev.getRevId())) {
                            PusherInternal.this.removePending(rev);
                            continue;
                        }
                        EnumSet<Database.TDContentOptions> contentOptions = EnumSet.of(Database.TDContentOptions.TDIncludeAttachments);
                        if (!PusherInternal.this.dontSendMultipart && PusherInternal.this.revisionBodyTransformationBlock == null) {
                            contentOptions.add(Database.TDContentOptions.TDBigAttachmentsFollow);
                        }
                        try {
                            loadedRev = PusherInternal.this.db.loadRevisionBody(rev, contentOptions);
                            properties = new HashMap<String, Object>(rev.getProperties());
                        }
                        catch (CouchbaseLiteException e1) {
                            Log.w("Sync", "%s Couldn't get local contents of %s", rev, PusherInternal.this);
                            PusherInternal.this.revisionFailed();
                            continue;
                        }
                        RevisionInternal populatedRev = PusherInternal.this.transformRevision(loadedRev);
                        List possibleAncestors = (List)revResults.get("possible_ancestors");
                        properties = new HashMap<String, Object>(populatedRev.getProperties());
                        Map<String, Object> revisions = PusherInternal.this.db.getRevisionHistoryDictStartingFromAnyAncestor(populatedRev, possibleAncestors);
                        properties.put("_revisions", revisions);
                        populatedRev.setProperties(properties);
                        if (properties.containsKey("_attachments")) {
                            int minRevPos = PusherInternal.findCommonAncestor(populatedRev, possibleAncestors);
                            Database.stubOutAttachmentsInRevBeforeRevPos(populatedRev, minRevPos + 1, false);
                            properties = populatedRev.getProperties();
                            if (!PusherInternal.this.dontSendMultipart && PusherInternal.this.uploadMultipartRevision(populatedRev)) continue;
                        }
                        if (properties == null || !properties.containsKey("_id")) {
                            throw new IllegalStateException("properties must contain a document _id");
                        }
                        revsToSend.add(rev);
                        docsToSend.add(properties);
                    }
                    PusherInternal.this.uploadBulkDocs(docsToSend, revsToSend);
                } else {
                    for (RevisionInternal revisionInternal : changes) {
                        PusherInternal.this.removePending(revisionInternal);
                    }
                }
            }
        });
        this.pendingFutures.add(future);
    }

    @InterfaceAudience.Private
    protected void uploadBulkDocs(List<Object> docsToSend, final RevisionList changes) {
        final int numDocsToSend = docsToSend.size();
        if (numDocsToSend == 0) {
            return;
        }
        Log.v("Sync", "%s: POSTing " + numDocsToSend + " revisions to _bulk_docs: %s", this, docsToSend);
        this.addToChangesCount(numDocsToSend);
        HashMap<String, Object> bulkDocsBody = new HashMap<String, Object>();
        bulkDocsBody.put("docs", docsToSend);
        bulkDocsBody.put("new_edits", false);
        Future future = this.sendAsyncRequest("POST", "/_bulk_docs", bulkDocsBody, new RemoteRequestCompletionBlock(){

            @Override
            public void onCompletion(HttpResponse httpResponse, Object result, Throwable e) {
                if (e == null) {
                    HashSet<String> failedIDs = new HashSet<String>();
                    List items = (List)result;
                    for (Map item : items) {
                        Status status = ReplicationInternal.statusFromBulkDocsResponseItem(item);
                        if (!status.isError()) continue;
                        Log.w("Sync", "%s: _bulk_docs got an error: %s", item, this);
                        if (status.getCode() == 403) continue;
                        String docID = (String)item.get("id");
                        failedIDs.add(docID);
                    }
                    for (RevisionInternal revisionInternal : changes) {
                        if (failedIDs.contains(revisionInternal.getDocId())) continue;
                        PusherInternal.this.removePending(revisionInternal);
                    }
                }
                if (e != null) {
                    PusherInternal.this.setError(e);
                    PusherInternal.this.revisionFailed();
                } else {
                    Log.v("Sync", "%s: POSTed to _bulk_docs", PusherInternal.this);
                }
                PusherInternal.this.addToCompletedChangesCount(numDocsToSend);
            }
        });
        this.pendingFutures.add(future);
    }

    @InterfaceAudience.Private
    private boolean uploadMultipartRevision(final RevisionInternal revision) {
        MultipartEntity multiPart = null;
        Map<String, Object> revProps = revision.getProperties();
        Map attachments = (Map)revProps.get("_attachments");
        for (String attachmentKey : attachments.keySet()) {
            String base64Digest;
            BlobKey blobKey;
            BlobStore blobStore;
            String path;
            File file;
            Map attachment = (Map)attachments.get(attachmentKey);
            if (!attachment.containsKey("follows")) continue;
            if (multiPart == null) {
                multiPart = new MultipartEntity();
                try {
                    String json = Manager.getObjectMapper().writeValueAsString(revProps);
                    Charset utf8charset = Charset.forName("UTF-8");
                    multiPart.addPart("param1", new StringBody(json, "application/json", utf8charset));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (!(file = new File(path = (blobStore = this.db.getAttachments()).pathForKey(blobKey = new BlobKey(base64Digest = (String)attachment.get("digest"))))).exists()) {
                Log.w("Sync", "Unable to find blob file for blobKey: %s - Skipping upload of multipart revision.", blobKey);
                multiPart = null;
                continue;
            }
            String contentType = null;
            if (attachment.containsKey("content_type")) {
                contentType = (String)attachment.get("content_type");
            } else if (attachment.containsKey("content-type")) {
                Log.w("Sync", "Found attachment that uses content-type field name instead of content_type (see couchbase-lite-android issue #80): %s", attachment);
            }
            FileBody fileBody = new FileBody(file, contentType);
            multiPart.addPart(attachmentKey, fileBody);
        }
        if (multiPart == null) {
            return false;
        }
        String path = String.format("/%s?new_edits=false", revision.getDocId());
        Log.d("Sync", "Uploading multipart request.  Revision: %s", revision);
        this.addToChangesCount(1);
        Future future = this.sendAsyncMultipartRequest("PUT", path, multiPart, new RemoteRequestCompletionBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompletion(HttpResponse httpResponse, Object result, Throwable e) {
                try {
                    if (e != null) {
                        if (e instanceof HttpResponseException) {
                            if (((HttpResponseException)e).getStatusCode() == 415) {
                                PusherInternal.this.dontSendMultipart = true;
                                PusherInternal.this.uploadJsonRevision(revision);
                            }
                        } else {
                            Log.e("Sync", "Exception uploading multipart request", e);
                            PusherInternal.this.setError(e);
                            PusherInternal.this.revisionFailed();
                        }
                    } else {
                        Log.v("Sync", "Uploaded multipart request.  Revision: %s", revision);
                        PusherInternal.this.removePending(revision);
                    }
                }
                finally {
                    PusherInternal.this.addToCompletedChangesCount(1);
                }
            }
        });
        this.pendingFutures.add(future);
        return true;
    }

    private void uploadJsonRevision(final RevisionInternal rev) {
        if (!this.db.inlineFollowingAttachmentsIn(rev)) {
            this.error = new CouchbaseLiteException(491);
            this.revisionFailed();
            return;
        }
        String path = String.format("/%s?new_edits=false", URIUtils.encode(rev.getDocId()));
        Future future = this.sendAsyncRequest("PUT", path, rev.getProperties(), new RemoteRequestCompletionBlock(){

            @Override
            public void onCompletion(HttpResponse httpResponse, Object result, Throwable e) {
                if (e != null) {
                    PusherInternal.this.setError(e);
                    PusherInternal.this.revisionFailed();
                } else {
                    Log.v("Sync", "%s: Sent %s (JSON), response=%s", this, rev, result);
                    PusherInternal.this.removePending(rev);
                }
            }
        });
        this.pendingFutures.add(future);
    }

    private static int findCommonAncestor(RevisionInternal rev, List<String> possibleRevIDs) {
        String ancestorID;
        if (possibleRevIDs == null || possibleRevIDs.size() == 0) {
            return 0;
        }
        List<String> history = Database.parseCouchDBRevisionHistory(rev.getProperties());
        assert (history != null);
        boolean changed = history.retainAll(possibleRevIDs);
        String string = ancestorID = history.size() == 0 ? null : history.get(0);
        if (ancestorID == null) {
            return 0;
        }
        int generation = Database.parseRevIDNumber(ancestorID);
        return generation;
    }
}

