/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.replicator;

import com.couchbase.lite.Database;
import com.couchbase.lite.Manager;
import com.couchbase.lite.NetworkReachabilityListener;
import com.couchbase.lite.auth.Authenticator;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.replicator.PullerInternal;
import com.couchbase.lite.replicator.PusherInternal;
import com.couchbase.lite.replicator.ReplicationInternal;
import com.couchbase.lite.replicator.ReplicationState;
import com.couchbase.lite.replicator.ReplicationStateTransition;
import com.couchbase.lite.support.CouchbaseLiteHttpClientFactory;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.support.PersistentCookieStore;
import com.couchbase.lite.util.Log;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

public class Replication
implements ReplicationInternal.ChangeListener,
NetworkReachabilityListener {
    public static final String REPLICATOR_DATABASE_NAME = "_replicator";
    protected Database db;
    protected URL remote;
    protected HttpClientFactory clientFactory;
    protected ScheduledExecutorService workExecutor;
    protected ReplicationInternal replicationInternal;
    protected Lifecycle lifecycle;
    protected List<ChangeListener> changeListeners;
    protected Throwable lastError;
    protected Direction direction;

    @InterfaceAudience.Private
    public Replication(Database db, URL remote, Direction direction) {
        this(db, remote, direction, db.getManager().getDefaultHttpClientFactory(), Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "CBLReplicationWorker");
            }
        }));
    }

    @InterfaceAudience.Private
    public Replication(Database db, URL remote, Direction direction, HttpClientFactory clientFactory, ScheduledExecutorService workExecutor) {
        this.db = db;
        this.remote = remote;
        this.workExecutor = workExecutor;
        this.changeListeners = new CopyOnWriteArrayList<ChangeListener>();
        this.lifecycle = Lifecycle.ONESHOT;
        this.direction = direction;
        this.setClientFactory(clientFactory);
        this.initReplicationInternal();
    }

    private void initReplicationInternal() {
        switch (this.direction) {
            case PULL: {
                this.replicationInternal = new PullerInternal(this.db, this.remote, this.clientFactory, this.workExecutor, this.lifecycle, this);
                break;
            }
            case PUSH: {
                this.replicationInternal = new PusherInternal(this.db, this.remote, this.clientFactory, this.workExecutor, this.lifecycle, this);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unknown direction: %s", new Object[]{this.direction}));
            }
        }
        this.replicationInternal.addChangeListener(this);
    }

    @InterfaceAudience.Public
    public void start() {
        if (this.replicationInternal == null) {
            this.initReplicationInternal();
        } else if (!this.replicationInternal.stateMachine.isInState((Object)ReplicationState.INITIAL)) {
            if (this.replicationInternal.stateMachine.isInState((Object)ReplicationState.STOPPED)) {
                this.initReplicationInternal();
            } else {
                String mesg = String.format("replicationInternal in unexpected state: %s, ignoring start()", this.replicationInternal.stateMachine.getState());
                Log.w("Sync", mesg);
            }
        }
        this.replicationInternal.triggerStart();
    }

    @InterfaceAudience.Public
    public void restart() {
        final CountDownLatch stopped = new CountDownLatch(1);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void changed(ChangeEvent event) {
                if (event.getTransition() != null && event.getTransition().getDestination() == ReplicationState.STOPPED) {
                    stopped.countDown();
                }
            }
        });
        this.stop();
        try {
            stopped.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.start();
    }

    @InterfaceAudience.Public
    public void goOffline() {
        this.replicationInternal.triggerGoOffline();
    }

    @InterfaceAudience.Public
    public void goOnline() {
        this.replicationInternal.triggerGoOnline();
    }

    @InterfaceAudience.Public
    public boolean isRunning() {
        if (this.replicationInternal == null) {
            return false;
        }
        return this.replicationInternal.stateMachine.isInState((Object)ReplicationState.RUNNING);
    }

    @InterfaceAudience.Public
    public void stop() {
        if (this.replicationInternal != null) {
            this.replicationInternal.triggerStop();
        }
    }

    @InterfaceAudience.Public
    public boolean isContinuous() {
        return this.lifecycle == Lifecycle.CONTINUOUS;
    }

    @InterfaceAudience.Public
    public void setContinuous(boolean isContinous) {
        if (isContinous) {
            this.lifecycle = Lifecycle.CONTINUOUS;
            this.replicationInternal.setLifecycle(Lifecycle.CONTINUOUS);
        } else {
            this.lifecycle = Lifecycle.ONESHOT;
            this.replicationInternal.setLifecycle(Lifecycle.ONESHOT);
        }
    }

    @InterfaceAudience.Public
    public void setAuthenticator(Authenticator authenticator) {
        this.replicationInternal.setAuthenticator(authenticator);
    }

    @InterfaceAudience.Public
    public Authenticator getAuthenticator() {
        return this.replicationInternal.getAuthenticator();
    }

    @InterfaceAudience.Public
    public boolean shouldCreateTarget() {
        return this.replicationInternal.shouldCreateTarget();
    }

    @InterfaceAudience.Public
    public void setCreateTarget(boolean createTarget) {
        this.replicationInternal.setCreateTarget(createTarget);
    }

    @InterfaceAudience.Public
    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    @InterfaceAudience.Public
    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    @InterfaceAudience.Public
    public ReplicationStatus getStatus() {
        if (this.replicationInternal == null) {
            return ReplicationStatus.REPLICATION_STOPPED;
        }
        if (this.replicationInternal.stateMachine.isInState((Object)ReplicationState.OFFLINE)) {
            return ReplicationStatus.REPLICATION_OFFLINE;
        }
        if (this.replicationInternal.stateMachine.isInState((Object)ReplicationState.IDLE)) {
            return ReplicationStatus.REPLICATION_IDLE;
        }
        if (this.replicationInternal.stateMachine.isInState((Object)ReplicationState.STOPPED)) {
            return ReplicationStatus.REPLICATION_STOPPED;
        }
        return ReplicationStatus.REPLICATION_ACTIVE;
    }

    @Override
    public void changed(ChangeEvent event) {
        for (ChangeListener changeListener : this.changeListeners) {
            try {
                changeListener.changed(event);
            }
            catch (Exception e) {
                Log.e("Sync", "Exception calling changeListener.changed", e);
            }
        }
    }

    @InterfaceAudience.Public
    public Throwable getLastError() {
        return this.lastError;
    }

    @InterfaceAudience.Public
    public int getCompletedChangesCount() {
        return this.replicationInternal.getCompletedChangesCount().get();
    }

    @InterfaceAudience.Public
    public int getChangesCount() {
        return this.replicationInternal.getChangesCount().get();
    }

    void setLastError(Throwable lastError) {
        this.lastError = lastError;
    }

    String remoteCheckpointDocID() {
        return this.replicationInternal.remoteCheckpointDocID();
    }

    @InterfaceAudience.Private
    protected void setClientFactory(HttpClientFactory clientFactory) {
        Manager manager = null;
        if (this.db != null) {
            manager = this.db.getManager();
        }
        HttpClientFactory managerClientFactory = null;
        if (manager != null) {
            managerClientFactory = manager.getDefaultHttpClientFactory();
        }
        if (clientFactory != null) {
            this.clientFactory = clientFactory;
        } else if (managerClientFactory != null) {
            this.clientFactory = managerClientFactory;
        } else {
            PersistentCookieStore cookieStore = this.db.getPersistentCookieStore();
            this.clientFactory = new CouchbaseLiteHttpClientFactory(cookieStore);
        }
    }

    @InterfaceAudience.Private
    boolean serverIsSyncGatewayVersion(String minVersion) {
        return this.replicationInternal.serverIsSyncGatewayVersion(minVersion);
    }

    @InterfaceAudience.Private
    void setServerType(String serverType) {
        this.replicationInternal.setServerType(serverType);
    }

    @InterfaceAudience.Public
    public void setFilter(String filterName) {
        this.replicationInternal.setFilter(filterName);
    }

    @InterfaceAudience.Public
    public void setDocIds(List<String> docIds) {
        this.replicationInternal.setDocIds(docIds);
    }

    public List<String> getDocIds() {
        return this.replicationInternal.getDocIds();
    }

    public void setFilterParams(Map<String, Object> filterParams) {
        this.replicationInternal.setFilterParams(filterParams);
    }

    @InterfaceAudience.Public
    public void setCookie(String name, String value, String path, long maxAge, boolean secure, boolean httpOnly) {
        this.replicationInternal.setCookie(name, value, path, maxAge, secure, httpOnly);
    }

    @InterfaceAudience.Public
    public void setCookie(String name, String value, String path, Date expirationDate, boolean secure, boolean httpOnly) {
        this.replicationInternal.setCookie(name, value, path, expirationDate, secure, httpOnly);
    }

    @InterfaceAudience.Public
    public void deleteCookie(String name) {
        this.replicationInternal.deleteCookie(name);
    }

    @InterfaceAudience.Private
    HttpClientFactory getClientFactory() {
        return this.replicationInternal.getClientFactory();
    }

    @InterfaceAudience.Private
    String buildRelativeURLString(String relativePath) {
        return this.replicationInternal.buildRelativeURLString(relativePath);
    }

    @InterfaceAudience.Public
    public List<String> getChannels() {
        return this.replicationInternal.getChannels();
    }

    @InterfaceAudience.Public
    public void setChannels(List<String> channels) {
        this.replicationInternal.setChannels(channels);
    }

    @InterfaceAudience.Public
    public String getFilter() {
        return this.replicationInternal.getFilter();
    }

    @InterfaceAudience.Public
    public Map<String, Object> getFilterParams() {
        return this.replicationInternal.getFilterParams();
    }

    @InterfaceAudience.Public
    public void setHeaders(Map<String, Object> requestHeadersParam) {
        this.replicationInternal.setHeaders(requestHeadersParam);
    }

    @InterfaceAudience.Public
    public Map<String, Object> getHeaders() {
        return this.replicationInternal.getHeaders();
    }

    @InterfaceAudience.Private
    public void databaseClosing() {
        this.replicationInternal.databaseClosing();
    }

    @InterfaceAudience.Private
    public String getSessionID() {
        return this.replicationInternal.getSessionID();
    }

    @InterfaceAudience.Public
    public Database getLocalDatabase() {
        return this.db;
    }

    @InterfaceAudience.Public
    public URL getRemoteUrl() {
        return this.remote;
    }

    @InterfaceAudience.Public
    public boolean isPull() {
        return this.replicationInternal.isPull();
    }

    @Override
    @InterfaceAudience.Private
    public void networkReachable() {
        this.goOnline();
    }

    @Override
    @InterfaceAudience.Private
    public void networkUnreachable() {
        this.goOffline();
    }

    @InterfaceAudience.Public
    public static class ChangeEvent {
        private Replication source;
        private ReplicationStateTransition transition;
        private int changeCount;
        private int completedChangeCount;
        private Throwable error;

        ChangeEvent(ReplicationInternal replInternal) {
            this.source = replInternal.parentReplication;
            this.changeCount = replInternal.getChangesCount().get();
            this.completedChangeCount = replInternal.getCompletedChangesCount().get();
        }

        public Replication getSource() {
            return this.source;
        }

        public ReplicationStateTransition getTransition() {
            return this.transition;
        }

        void setTransition(ReplicationStateTransition transition) {
            this.transition = transition;
        }

        public int getChangeCount() {
            return this.changeCount;
        }

        public int getCompletedChangeCount() {
            return this.completedChangeCount;
        }

        public Throwable getError() {
            return this.error;
        }

        void setError(Throwable error) {
            this.error = error;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append((Object)this.getSource().direction);
            sb.append(" replication event. Source: ");
            sb.append(this.getSource());
            if (this.getTransition() != null) {
                sb.append(" Transition: ");
                sb.append((Object)this.getTransition().getSource());
                sb.append(" -> ");
                sb.append((Object)this.getTransition().getDestination());
            }
            sb.append(" Total changes: ");
            sb.append(this.getChangeCount());
            sb.append(" Completed changes: ");
            sb.append(this.getCompletedChangeCount());
            return sb.toString();
        }
    }

    @InterfaceAudience.Public
    public static interface ChangeListener {
        public void changed(ChangeEvent var1);
    }

    public static enum ReplicationStatus {
        REPLICATION_STOPPED,
        REPLICATION_OFFLINE,
        REPLICATION_IDLE,
        REPLICATION_ACTIVE;

    }

    public static enum Lifecycle {
        ONESHOT,
        CONTINUOUS;

    }

    public static enum Direction {
        PULL,
        PUSH;

    }
}

