/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.replicator;

import com.couchbase.lite.Database;
import com.couchbase.lite.Manager;
import com.couchbase.lite.Misc;
import com.couchbase.lite.RevisionList;
import com.couchbase.lite.Status;
import com.couchbase.lite.auth.Authenticator;
import com.couchbase.lite.auth.AuthenticatorImpl;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.replicator.Replication;
import com.couchbase.lite.replicator.ReplicationState;
import com.couchbase.lite.replicator.ReplicationStateTransition;
import com.couchbase.lite.replicator.ReplicationTrigger;
import com.couchbase.lite.support.BatchProcessor;
import com.couchbase.lite.support.Batcher;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.support.RemoteRequestCompletionBlock;
import com.couchbase.lite.support.RemoteRequestRetry;
import com.couchbase.lite.util.CollectionUtils;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.TextUtils;
import com.couchbase.lite.util.Utils;
import com.couchbase.org.apache.http.entity.mime.MultipartEntity;
import com.github.oxo42.stateless4j.StateMachine;
import com.github.oxo42.stateless4j.delegates.Action1;
import com.github.oxo42.stateless4j.transitions.Transition;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.cookie.BasicClientCookie2;

@InterfaceAudience.Private
abstract class ReplicationInternal {
    public static final String BY_CHANNEL_FILTER_NAME = "sync_gateway/bychannel";
    public static final String CHANNELS_QUERY_PARAM = "channels";
    public static final String REPLICATOR_DATABASE_NAME = "_replicator";
    public static final int EXECUTOR_THREAD_POOL_SIZE = 5;
    private static int lastSessionID = 0;
    protected Replication parentReplication;
    protected Database db;
    protected URL remote;
    protected HttpClientFactory clientFactory;
    protected String lastSequence;
    protected Authenticator authenticator;
    protected String filterName;
    protected Map<String, Object> filterParams;
    protected List<String> documentIDs;
    protected Map<String, Object> requestHeaders;
    private String serverType;
    protected Batcher<RevisionInternal> batcher;
    protected static final int PROCESSOR_DELAY = 500;
    protected static int INBOX_CAPACITY = 100;
    protected ScheduledExecutorService remoteRequestExecutor;
    protected int asyncTaskCount;
    protected Throwable error;
    private String remoteCheckpointDocID;
    protected Map<String, Object> remoteCheckpoint;
    protected AtomicInteger completedChangesCount;
    protected AtomicInteger changesCount;
    private int revisionsFailed;
    protected CollectionUtils.Functor<RevisionInternal, RevisionInternal> revisionBodyTransformationBlock;
    protected String sessionID;
    protected BlockingQueue<Future> pendingFutures;
    private boolean savingCheckpoint;
    private boolean overdueForCheckpointSave;
    protected ScheduledExecutorService workExecutor;
    protected StateMachine<ReplicationState, ReplicationTrigger> stateMachine;
    protected List<ChangeListener> changeListeners;
    protected Replication.Lifecycle lifecycle;
    protected ChangeListenerNotifyStyle changeListenerNotifyStyle;

    ReplicationInternal(Database db, URL remote, HttpClientFactory clientFactory, ScheduledExecutorService workExecutor, Replication.Lifecycle lifecycle, Replication parentReplication) {
        Utils.assertNotNull((Object)lifecycle, "Must pass in a non-null lifecycle");
        this.parentReplication = parentReplication;
        this.db = db;
        this.remote = remote;
        this.clientFactory = clientFactory;
        this.workExecutor = workExecutor;
        this.lifecycle = lifecycle;
        this.requestHeaders = new HashMap<String, Object>();
        this.changeListeners = new CopyOnWriteArrayList<ChangeListener>();
        this.changeListenerNotifyStyle = ChangeListenerNotifyStyle.ASYNC;
        this.pendingFutures = new LinkedBlockingQueue<Future>();
        this.initializeStateMachine();
    }

    public void triggerStart() {
        this.fireTrigger(ReplicationTrigger.START);
    }

    public void triggerStop() {
        this.fireTrigger(ReplicationTrigger.STOP_GRACEFUL);
    }

    public void triggerGoOffline() {
        this.fireTrigger(ReplicationTrigger.GO_OFFLINE);
    }

    public void triggerGoOnline() {
        this.fireTrigger(ReplicationTrigger.GO_ONLINE);
    }

    protected void fireTrigger(final ReplicationTrigger trigger) {
        this.workExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Log.d("Sync", "firing trigger: %s", new Object[]{trigger});
                    ReplicationInternal.this.stateMachine.fire((Object)trigger);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        });
    }

    protected void triggerStopImmediate() {
        this.fireTrigger(ReplicationTrigger.STOP_IMMEDIATE);
    }

    protected void start() {
        try {
            if (!this.db.isOpen()) {
                String msg = String.format("Db: %s is not open, abort replication", this.db);
                this.parentReplication.setLastError(new Exception(msg));
                this.fireTrigger(ReplicationTrigger.STOP_IMMEDIATE);
                return;
            }
            this.db.addReplication(this.parentReplication);
            this.db.addActiveReplication(this.parentReplication);
            this.initSessionId();
            this.initBatcher();
            this.initAuthorizer();
            this.goOnlineInitialStartup();
            this.initNetworkReachabilityManager();
        }
        catch (Exception e) {
            Log.e("Sync", "%s: Exception in start()", e, this);
        }
    }

    private void initSessionId() {
        this.sessionID = String.format("repl%03d", ++lastSessionID);
    }

    protected void goOffline() {
    }

    protected void goOnline() {
    }

    public void databaseClosing() {
        this.saveLastSequence();
        this.triggerStop();
    }

    protected void initAuthorizer() {
    }

    protected void initBatcher() {
        this.batcher = new Batcher<RevisionInternal>(this.workExecutor, INBOX_CAPACITY, 500, new BatchProcessor<RevisionInternal>(){

            @Override
            public void process(List<RevisionInternal> inbox) {
                try {
                    Log.v("Sync", "*** %s: BEGIN processInbox (%d sequences)", this, inbox.size());
                    ReplicationInternal.this.processInbox(new RevisionList(inbox));
                    Log.v("Sync", "*** %s: END processInbox (lastSequence=%s)", this, ReplicationInternal.this.lastSequence);
                    Log.v("Sync", "%s: batcher calling updateActive()", this);
                    ReplicationInternal.this.updateActive();
                }
                catch (Exception e) {
                    Log.e("Sync", "ERROR: processInbox failed: ", e);
                    throw new RuntimeException(e);
                }
            }
        });
    }

    protected void initNetworkReachabilityManager() {
        this.db.getManager().getContext().getNetworkReachabilityManager().addNetworkReachabilityListener(this.parentReplication);
    }

    public abstract boolean shouldCreateTarget();

    public abstract void setCreateTarget(boolean var1);

    protected void goOnlineInitialStartup() {
        this.remoteRequestExecutor = Executors.newScheduledThreadPool(5, new ThreadFactory(){
            private int counter = 0;

            @Override
            public Thread newThread(Runnable r) {
                String threadName = "CBLRequestWorker";
                try {
                    String replicationIdentifier = Utils.shortenString(ReplicationInternal.this.remoteCheckpointDocID(), 5);
                    threadName = String.format("CBLRequestWorker-%s-%s", replicationIdentifier, this.counter++);
                }
                catch (Exception e) {
                    Log.e("Sync", "Error creating thread name", e);
                }
                return new Thread(r, threadName);
            }
        });
        this.checkSession();
    }

    @InterfaceAudience.Private
    protected void checkSession() {
        if (this.getAuthenticator() != null && ((AuthenticatorImpl)this.getAuthenticator()).usesCookieBasedLogin()) {
            this.checkSessionAtPath("/_session");
        } else {
            this.fetchRemoteCheckpointDoc();
        }
    }

    @InterfaceAudience.Private
    protected void checkSessionAtPath(final String sessionPath) {
        Future future = this.sendAsyncRequest("GET", sessionPath, null, new RemoteRequestCompletionBlock(){

            @Override
            public void onCompletion(HttpResponse httpResponse, Object result, Throwable error) {
                try {
                    if (error != null) {
                        if (error instanceof HttpResponseException && ((HttpResponseException)error).getStatusCode() == 404 && sessionPath.equalsIgnoreCase("/_session")) {
                            ReplicationInternal.this.checkSessionAtPath("_session");
                            return;
                        }
                        Log.e("Sync", this + ": Session check failed", error);
                        ReplicationInternal.this.setError(error);
                    } else {
                        Map response = (Map)result;
                        Log.e("Sync", "%s checkSessionAtPath() response: %s", this, response);
                        Map userCtx = (Map)response.get("userCtx");
                        String username = (String)userCtx.get("name");
                        if (username != null && username.length() > 0) {
                            Log.d("Sync", "%s Active session, logged in as %s", this, username);
                            ReplicationInternal.this.fetchRemoteCheckpointDoc();
                        } else {
                            Log.d("Sync", "%s No active session, going to login", this);
                            ReplicationInternal.this.login();
                        }
                    }
                }
                catch (Exception e) {
                    Log.e("Sync", "%s Exception in checkSessionAtPath()", this, e);
                }
            }
        });
        this.pendingFutures.add(future);
    }

    @InterfaceAudience.Private
    protected void login() {
        Map<String, String> loginParameters = ((AuthenticatorImpl)this.getAuthenticator()).loginParametersForSite(this.remote);
        if (loginParameters == null) {
            Log.d("Sync", "%s: %s has no login parameters, so skipping login", this, this.getAuthenticator());
            this.fetchRemoteCheckpointDoc();
            return;
        }
        final String loginPath = ((AuthenticatorImpl)this.getAuthenticator()).loginPathForSite(this.remote);
        Log.d("Sync", "%s: Doing login with %s at %s", this, this.getAuthenticator().getClass(), loginPath);
        Future future = this.sendAsyncRequest("POST", loginPath, loginParameters, new RemoteRequestCompletionBlock(){

            @Override
            public void onCompletion(HttpResponse httpResponse, Object result, Throwable e) {
                if (e != null) {
                    Log.d("Sync", "%s: Login failed for path: %s", this, loginPath);
                    ReplicationInternal.this.setError(e);
                    ReplicationInternal.this.triggerStop();
                } else {
                    Log.v("Sync", "%s: Successfully logged in!", this);
                    ReplicationInternal.this.fetchRemoteCheckpointDoc();
                }
            }
        });
        this.pendingFutures.add(future);
    }

    @InterfaceAudience.Private
    protected void setError(Throwable throwable) {
        if (throwable != this.error) {
            Log.e("Sync", "%s: Progress: set error = %s", this, throwable);
            this.parentReplication.setLastError(throwable);
            this.error = throwable;
            Replication.ChangeEvent changeEvent = new Replication.ChangeEvent(this);
            changeEvent.setError(this.error);
            this.notifyChangeListeners(changeEvent);
        }
    }

    @InterfaceAudience.Private
    void addToCompletedChangesCount(int delta) {
        int previousVal = this.getCompletedChangesCount().getAndAdd(delta);
        Log.v("Sync", "%s: Incrementing completedChangesCount count from %s by adding %d -> %d", this, previousVal, delta, this.completedChangesCount.get());
        Replication.ChangeEvent changeEvent = new Replication.ChangeEvent(this);
        this.notifyChangeListeners(changeEvent);
    }

    @InterfaceAudience.Private
    void addToChangesCount(int delta) {
        int previousVal = this.getChangesCount().getAndAdd(delta);
        if (this.getChangesCount().get() < 0) {
            Log.w("Sync", "Changes count is negative, this could indicate an error");
        }
        Log.v("Sync", "%s: Incrementing changesCount count from %s by adding %d -> %d", this, previousVal, delta, this.changesCount.get());
        Replication.ChangeEvent changeEvent = new Replication.ChangeEvent(this);
        this.notifyChangeListeners(changeEvent);
    }

    public AtomicInteger getCompletedChangesCount() {
        if (this.completedChangesCount == null) {
            this.completedChangesCount = new AtomicInteger(0);
        }
        return this.completedChangesCount;
    }

    public AtomicInteger getChangesCount() {
        if (this.changesCount == null) {
            this.changesCount = new AtomicInteger(0);
        }
        return this.changesCount;
    }

    @InterfaceAudience.Private
    public Future sendAsyncRequest(String method, String relativePath, Object body, RemoteRequestCompletionBlock onCompletion) {
        return this.sendAsyncRequest(method, relativePath, body, false, onCompletion);
    }

    @InterfaceAudience.Private
    public Future sendAsyncRequest(String method, String relativePath, Object body, boolean dontLog404, RemoteRequestCompletionBlock onCompletion) {
        try {
            String urlStr = this.buildRelativeURLString(relativePath);
            URL url = new URL(urlStr);
            return this.sendAsyncRequest(method, url, body, dontLog404, onCompletion);
        }
        catch (MalformedURLException e) {
            Log.e("Sync", "Malformed URL for async request", e);
            return null;
        }
    }

    @InterfaceAudience.Private
    public Future sendAsyncRequest(String method, URL url, Object body, boolean dontLog404, RemoteRequestCompletionBlock onCompletion) {
        RemoteRequestRetry request = new RemoteRequestRetry(RemoteRequestRetry.RemoteRequestType.REMOTE_REQUEST, this.remoteRequestExecutor, this.workExecutor, this.clientFactory, method, url, body, this.getLocalDatabase(), this.getHeaders(), onCompletion);
        request.setDontLog404(dontLog404);
        request.setAuthenticator(this.getAuthenticator());
        request.setOnPreCompletionCaller(new RemoteRequestCompletionBlock(){

            @Override
            public void onCompletion(HttpResponse httpResponse, Object result, Throwable e) {
                Header serverHeader;
                if (ReplicationInternal.this.serverType == null && httpResponse != null && (serverHeader = httpResponse.getFirstHeader("Server")) != null) {
                    String serverVersion = serverHeader.getValue();
                    Log.v("Sync", "serverVersion: %s", serverVersion);
                    ReplicationInternal.this.serverType = serverVersion;
                }
            }
        });
        Future future = request.submit();
        return future;
    }

    @InterfaceAudience.Private
    public Future sendAsyncMultipartRequest(String method, String relativePath, MultipartEntity multiPartEntity, RemoteRequestCompletionBlock onCompletion) {
        URL url = null;
        try {
            String urlStr = this.buildRelativeURLString(relativePath);
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        RemoteRequestRetry request = new RemoteRequestRetry(RemoteRequestRetry.RemoteRequestType.REMOTE_MULTIPART_REQUEST, this.remoteRequestExecutor, this.workExecutor, this.clientFactory, method, url, multiPartEntity, this.getLocalDatabase(), this.getHeaders(), onCompletion);
        request.setAuthenticator(this.getAuthenticator());
        Future future = request.submit();
        return future;
    }

    @InterfaceAudience.Private
    public Future sendAsyncMultipartDownloaderRequest(String method, String relativePath, Object body, Database db, RemoteRequestCompletionBlock onCompletion) {
        try {
            String urlStr = this.buildRelativeURLString(relativePath);
            URL url = new URL(urlStr);
            RemoteRequestRetry request = new RemoteRequestRetry(RemoteRequestRetry.RemoteRequestType.REMOTE_MULTIPART_DOWNLOADER_REQUEST, this.remoteRequestExecutor, this.workExecutor, this.clientFactory, method, url, body, this.getLocalDatabase(), this.getHeaders(), onCompletion);
            request.setAuthenticator(this.getAuthenticator());
            Future future = request.submit();
            return future;
        }
        catch (MalformedURLException e) {
            Log.e("Sync", "Malformed URL for async request", e);
            return null;
        }
    }

    Database getLocalDatabase() {
        return this.db;
    }

    void setLocalDatabase(Database db) {
        this.db = db;
    }

    @InterfaceAudience.Public
    public Map<String, Object> getHeaders() {
        return this.requestHeaders;
    }

    @InterfaceAudience.Public
    public void setHeaders(Map<String, Object> requestHeadersParam) {
        if (requestHeadersParam != null && !this.requestHeaders.equals(requestHeadersParam)) {
            this.requestHeaders = requestHeadersParam;
        }
    }

    @InterfaceAudience.Private
    public void saveLastSequence() {
        if (this.savingCheckpoint) {
            this.overdueForCheckpointSave = true;
            return;
        }
        this.savingCheckpoint = true;
        Log.d("Sync", "%s: saveLastSequence() called. lastSequence: %s remoteCheckpoint: %s", this, this.lastSequence, this.remoteCheckpoint);
        final HashMap<String, Object> body = new HashMap<String, Object>();
        if (this.remoteCheckpoint != null) {
            body.putAll(this.remoteCheckpoint);
        }
        body.put("lastSequence", this.lastSequence);
        String remoteCheckpointDocID = this.remoteCheckpointDocID();
        if (remoteCheckpointDocID == null) {
            Log.w("Sync", "%s: remoteCheckpointDocID is null, aborting saveLastSequence()", this);
            return;
        }
        final String checkpointID = remoteCheckpointDocID;
        Log.d("Sync", "%s: start put remote _local document.  checkpointID: %s body: %s", this, checkpointID, body);
        Future future = this.sendAsyncRequest("PUT", "/_local/" + checkpointID, body, new RemoteRequestCompletionBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompletion(HttpResponse httpResponse, Object result, Throwable e) {
                block10: {
                    Log.d("Sync", "%s: put remote _local document request finished.  checkpointID: %s body: %s", this, checkpointID, body);
                    try {
                        if (e != null) {
                            Log.w("Sync", "%s: Unable to save remote checkpoint", e, this);
                            switch (Utils.getStatusFromError(e)) {
                                case 404: {
                                    Log.i("Sync", "%s: could not save remote checkpoint: 404 NOT FOUND", this);
                                    ReplicationInternal.this.remoteCheckpoint = null;
                                    break;
                                }
                                case 409: {
                                    Log.i("Sync", "%s: could not save remote checkpoint: 409 CONFLICT", this);
                                    ReplicationInternal.this.refreshRemoteCheckpointDoc();
                                    break;
                                }
                                default: {
                                    Log.i("Sync", "%s: could not save remote checkpoint: %s", this, e);
                                    break;
                                }
                            }
                            break block10;
                        }
                        Map response = (Map)result;
                        body.put("_rev", response.get("rev"));
                        ReplicationInternal.this.remoteCheckpoint = body;
                        if (ReplicationInternal.this.db != null && ReplicationInternal.this.db.open()) {
                            Log.d("Sync", "%s: saved remote checkpoint, updating local checkpoint.  remoteCheckpoint: %s", this, ReplicationInternal.this.remoteCheckpoint);
                            ReplicationInternal.this.db.setLastSequence(ReplicationInternal.this.lastSequence, checkpointID, !ReplicationInternal.this.isPull());
                            break block10;
                        }
                        Log.w("Sync", "%s: Database is null or closed, not calling db.setLastSequence() ", this);
                    }
                    catch (Throwable throwable) {
                        ReplicationInternal.this.savingCheckpoint = false;
                        if (ReplicationInternal.this.overdueForCheckpointSave) {
                            Log.i("Sync", "%s: overdueForCheckpointSave == true, calling saveLastSequence()", this);
                            ReplicationInternal.this.overdueForCheckpointSave = false;
                            ReplicationInternal.this.saveLastSequence();
                        }
                        throw throwable;
                    }
                }
                ReplicationInternal.this.savingCheckpoint = false;
                if (ReplicationInternal.this.overdueForCheckpointSave) {
                    Log.i("Sync", "%s: overdueForCheckpointSave == true, calling saveLastSequence()", this);
                    ReplicationInternal.this.overdueForCheckpointSave = false;
                    ReplicationInternal.this.saveLastSequence();
                }
            }
        });
        this.pendingFutures.add(future);
    }

    @InterfaceAudience.Private
    private void refreshRemoteCheckpointDoc() {
        Log.d("Sync", "%s: Refreshing remote checkpoint to get its _rev...", this);
        Future future = this.sendAsyncRequest("GET", "/_local/" + this.remoteCheckpointDocID(), null, new RemoteRequestCompletionBlock(){

            @Override
            public void onCompletion(HttpResponse httpResponse, Object result, Throwable e) {
                if (ReplicationInternal.this.db == null) {
                    Log.w("Sync", "%s: db == null while refreshing remote checkpoint.  aborting", this);
                    return;
                }
                if (e != null && Utils.getStatusFromError(e) != 404) {
                    Log.e("Sync", "%s: Error refreshing remote checkpoint", e, this);
                } else {
                    Log.d("Sync", "%s: Refreshed remote checkpoint: %s", this, result);
                    ReplicationInternal.this.remoteCheckpoint = (Map)result;
                    ReplicationInternal.this.saveLastSequence();
                }
            }
        });
        this.pendingFutures.add(future);
    }

    @InterfaceAudience.Private
    String buildRelativeURLString(String relativePath) {
        String remoteUrlString = this.remote.toExternalForm();
        if (remoteUrlString.endsWith("/") && relativePath.startsWith("/")) {
            remoteUrlString = remoteUrlString.substring(0, remoteUrlString.length() - 1);
        }
        if (relativePath.equals("_session")) {
            try {
                URL remoteUrl = new URL(remoteUrlString);
                String relativePathWithLeadingSlash = String.format("/%s", relativePath);
                URL remoteUrlNoPath = new URL(remoteUrl.getProtocol(), remoteUrl.getHost(), remoteUrl.getPort(), relativePathWithLeadingSlash);
                remoteUrlString = remoteUrlNoPath.toExternalForm();
                return remoteUrlString;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return remoteUrlString + relativePath;
    }

    @InterfaceAudience.Private
    public void fetchRemoteCheckpointDoc() {
        String checkpointId = this.remoteCheckpointDocID();
        final String localLastSequence = this.db.lastSequenceWithCheckpointId(checkpointId);
        boolean dontLog404 = true;
        Future future = this.sendAsyncRequest("GET", "/_local/" + checkpointId, null, dontLog404, new RemoteRequestCompletionBlock(){

            @Override
            public void onCompletion(HttpResponse httpResponse, Object result, Throwable e) {
                if (e != null && !Utils.is404(e)) {
                    Log.w("Sync", "%s: error getting remote checkpoint", e, this);
                    ReplicationInternal.this.setError(e);
                    ReplicationInternal.this.fireTrigger(ReplicationTrigger.STOP_GRACEFUL);
                } else {
                    Map response;
                    if (e != null && Utils.is404(e)) {
                        Log.v("Sync", "%s: Remote checkpoint does not exist on server yet: %s", this, ReplicationInternal.this.remoteCheckpointDocID());
                        ReplicationInternal.this.maybeCreateRemoteDB();
                    }
                    ReplicationInternal.this.remoteCheckpoint = response = (Map)result;
                    String remoteLastSequence = null;
                    if (response != null) {
                        remoteLastSequence = (String)response.get("lastSequence");
                    }
                    if (remoteLastSequence != null && remoteLastSequence.equals(localLastSequence)) {
                        ReplicationInternal.this.lastSequence = localLastSequence;
                        Log.d("Sync", "%s: Replicating from lastSequence=%s", this, ReplicationInternal.this.lastSequence);
                    } else {
                        Log.d("Sync", "%s: lastSequence mismatch: I had: %s, remote had: %s", this, localLastSequence, remoteLastSequence);
                    }
                    ReplicationInternal.this.beginReplicating();
                }
            }
        });
        this.pendingFutures.add(future);
    }

    abstract void maybeCreateRemoteDB();

    public String remoteCheckpointDocID() {
        if (this.remoteCheckpointDocID != null) {
            return this.remoteCheckpointDocID;
        }
        if (this.db == null) {
            return null;
        }
        TreeMap<String, Object> filterParamsCanonical = null;
        if (this.getFilterParams() != null) {
            filterParamsCanonical = new TreeMap<String, Object>(this.getFilterParams());
        }
        ArrayList<String> docIdsSorted = null;
        if (this.getDocIds() != null) {
            docIdsSorted = new ArrayList<String>(this.getDocIds());
            Collections.sort(docIdsSorted);
        }
        TreeMap<String, Object> spec = new TreeMap<String, Object>();
        spec.put("localUUID", this.db.privateUUID());
        spec.put("remoteURL", this.remote.toExternalForm());
        spec.put("push", !this.isPull());
        spec.put("continuous", this.isContinuous());
        if (this.getFilter() != null) {
            spec.put("filter", this.getFilter());
        }
        if (filterParamsCanonical != null) {
            spec.put("filterParams", filterParamsCanonical);
        }
        if (docIdsSorted != null) {
            spec.put("docids", docIdsSorted);
        }
        byte[] inputBytes = null;
        try {
            this.db.getManager();
            inputBytes = Manager.getObjectMapper().writeValueAsBytes(spec);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.remoteCheckpointDocID = Misc.TDHexSHA1Digest(inputBytes);
        return this.remoteCheckpointDocID;
    }

    public String getFilter() {
        return this.filterName;
    }

    public void setFilter(String filterName) {
        this.filterName = filterName;
    }

    public abstract boolean isPull();

    public List<String> getDocIds() {
        return this.documentIDs;
    }

    public void setDocIds(List<String> docIds) {
        this.documentIDs = docIds;
    }

    public boolean isContinuous() {
        return this.lifecycle == Replication.Lifecycle.CONTINUOUS;
    }

    public Map<String, Object> getFilterParams() {
        return this.filterParams;
    }

    public void setFilterParams(Map<String, Object> filterParams) {
        this.filterParams = filterParams;
    }

    protected abstract void processInbox(RevisionList var1);

    protected abstract void beginReplicating();

    protected void stopGraceful() {
        Log.d("Sync", "stopGraceful()");
    }

    private void notifyChangeListeners(final Replication.ChangeEvent changeEvent) {
        if (this.changeListenerNotifyStyle == ChangeListenerNotifyStyle.SYNC) {
            for (ChangeListener changeListener : this.changeListeners) {
                try {
                    changeListener.changed(changeEvent);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.e("Sync", "Exception notifying replication listener: %s", e);
                }
            }
        } else {
            this.workExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (ChangeListener changeListener : ReplicationInternal.this.changeListeners) {
                            changeListener.changed(changeEvent);
                        }
                    }
                    catch (Exception e) {
                        Log.e("Sync", "Exception notifying replication listener: %s", e);
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    @InterfaceAudience.Public
    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    protected void initializeStateMachine() {
        this.stateMachine = new StateMachine((Object)ReplicationState.INITIAL);
        this.stateMachine.configure((Object)ReplicationState.IDLE).substateOf((Object)ReplicationState.RUNNING);
        this.stateMachine.configure((Object)ReplicationState.OFFLINE).substateOf((Object)ReplicationState.RUNNING);
        this.stateMachine.configure((Object)ReplicationState.INITIAL).permit((Object)ReplicationTrigger.START, (Object)ReplicationState.RUNNING);
        this.stateMachine.configure((Object)ReplicationState.RUNNING).permit((Object)ReplicationTrigger.WAITING_FOR_CHANGES, (Object)ReplicationState.IDLE);
        this.stateMachine.configure((Object)ReplicationState.RUNNING).permit((Object)ReplicationTrigger.STOP_IMMEDIATE, (Object)ReplicationState.STOPPED);
        this.stateMachine.configure((Object)ReplicationState.RUNNING).permit((Object)ReplicationTrigger.STOP_GRACEFUL, (Object)ReplicationState.STOPPING);
        this.stateMachine.configure((Object)ReplicationState.RUNNING).permit((Object)ReplicationTrigger.GO_OFFLINE, (Object)ReplicationState.OFFLINE);
        this.stateMachine.configure((Object)ReplicationState.OFFLINE).permit((Object)ReplicationTrigger.GO_ONLINE, (Object)ReplicationState.RUNNING);
        this.stateMachine.configure((Object)ReplicationState.STOPPING).permit((Object)ReplicationTrigger.STOP_IMMEDIATE, (Object)ReplicationState.STOPPED);
        this.stateMachine.configure((Object)ReplicationState.RUNNING).ignore((Object)ReplicationTrigger.START);
        this.stateMachine.configure((Object)ReplicationState.STOPPING).ignore((Object)ReplicationTrigger.STOP_GRACEFUL);
        this.stateMachine.configure((Object)ReplicationState.STOPPED).ignore((Object)ReplicationTrigger.STOP_GRACEFUL);
        this.stateMachine.configure((Object)ReplicationState.STOPPED).ignore((Object)ReplicationTrigger.STOP_IMMEDIATE);
        this.stateMachine.configure((Object)ReplicationState.STOPPING).ignore((Object)ReplicationTrigger.WAITING_FOR_CHANGES);
        this.stateMachine.configure((Object)ReplicationState.STOPPED).ignore((Object)ReplicationTrigger.WAITING_FOR_CHANGES);
        this.stateMachine.configure((Object)ReplicationState.INITIAL).ignore((Object)ReplicationTrigger.GO_OFFLINE);
        this.stateMachine.configure((Object)ReplicationState.STOPPING).ignore((Object)ReplicationTrigger.GO_OFFLINE);
        this.stateMachine.configure((Object)ReplicationState.STOPPED).ignore((Object)ReplicationTrigger.GO_OFFLINE);
        this.stateMachine.configure((Object)ReplicationState.OFFLINE).ignore((Object)ReplicationTrigger.GO_OFFLINE);
        this.stateMachine.configure((Object)ReplicationState.INITIAL).ignore((Object)ReplicationTrigger.GO_ONLINE);
        this.stateMachine.configure((Object)ReplicationState.RUNNING).ignore((Object)ReplicationTrigger.GO_ONLINE);
        this.stateMachine.configure((Object)ReplicationState.STOPPING).ignore((Object)ReplicationTrigger.GO_ONLINE);
        this.stateMachine.configure((Object)ReplicationState.STOPPED).ignore((Object)ReplicationTrigger.GO_ONLINE);
        this.stateMachine.configure((Object)ReplicationState.IDLE).ignore((Object)ReplicationTrigger.GO_ONLINE);
        this.stateMachine.configure((Object)ReplicationState.RUNNING).onEntry((Action1)new Action1<Transition<ReplicationState, ReplicationTrigger>>(){

            public void doIt(Transition<ReplicationState, ReplicationTrigger> transition) {
                Log.d("Sync", "entered the RUNNING state, calling start()");
                ReplicationInternal.this.start();
                Log.d("Sync", "called start(), calling notifyChangeListenersStateTransition");
                ReplicationInternal.this.notifyChangeListenersStateTransition((Transition<ReplicationState, ReplicationTrigger>)transition);
                Log.d("Sync", "called notifyChangeListenersStateTransition");
            }
        });
        this.stateMachine.configure((Object)ReplicationState.RUNNING).onExit((Action1)new Action1<Transition<ReplicationState, ReplicationTrigger>>(){

            public void doIt(Transition<ReplicationState, ReplicationTrigger> transition) {
                Log.d("Sync", "replicator exiting the RUNNING method");
            }
        });
        this.stateMachine.configure((Object)ReplicationState.IDLE).onEntry((Action1)new Action1<Transition<ReplicationState, ReplicationTrigger>>(){

            public void doIt(Transition<ReplicationState, ReplicationTrigger> transition) {
                ReplicationInternal.this.notifyChangeListenersStateTransition((Transition<ReplicationState, ReplicationTrigger>)transition);
            }
        });
        this.stateMachine.configure((Object)ReplicationState.IDLE).onExit((Action1)new Action1<Transition<ReplicationState, ReplicationTrigger>>(){

            public void doIt(Transition<ReplicationState, ReplicationTrigger> transition) {
                ReplicationInternal.this.notifyChangeListenersStateTransition((Transition<ReplicationState, ReplicationTrigger>)transition);
            }
        });
        this.stateMachine.configure((Object)ReplicationState.OFFLINE).onEntry((Action1)new Action1<Transition<ReplicationState, ReplicationTrigger>>(){

            public void doIt(Transition<ReplicationState, ReplicationTrigger> transition) {
                ReplicationInternal.this.goOffline();
                ReplicationInternal.this.notifyChangeListenersStateTransition((Transition<ReplicationState, ReplicationTrigger>)transition);
            }
        });
        this.stateMachine.configure((Object)ReplicationState.OFFLINE).onExit((Action1)new Action1<Transition<ReplicationState, ReplicationTrigger>>(){

            public void doIt(Transition<ReplicationState, ReplicationTrigger> transition) {
                ReplicationInternal.this.goOnline();
                ReplicationInternal.this.notifyChangeListenersStateTransition((Transition<ReplicationState, ReplicationTrigger>)transition);
            }
        });
        this.stateMachine.configure((Object)ReplicationState.STOPPING).onEntry((Action1)new Action1<Transition<ReplicationState, ReplicationTrigger>>(){

            public void doIt(Transition<ReplicationState, ReplicationTrigger> transition) {
                ReplicationInternal.this.stopGraceful();
                ReplicationInternal.this.notifyChangeListenersStateTransition((Transition<ReplicationState, ReplicationTrigger>)transition);
            }
        });
        this.stateMachine.configure((Object)ReplicationState.STOPPED).onEntry((Action1)new Action1<Transition<ReplicationState, ReplicationTrigger>>(){

            public void doIt(Transition<ReplicationState, ReplicationTrigger> transition) {
                ReplicationInternal.this.clearDbRef();
                ReplicationInternal.this.notifyChangeListenersStateTransition((Transition<ReplicationState, ReplicationTrigger>)transition);
            }
        });
    }

    private void logTransition(Transition<ReplicationState, ReplicationTrigger> transition) {
        Log.d("Sync", "State transition: %s -> %s (via %s).  this: %s", transition.getSource(), transition.getDestination(), transition.getTrigger(), this);
    }

    private void notifyChangeListenersStateTransition(Transition<ReplicationState, ReplicationTrigger> transition) {
        this.logTransition(transition);
        Replication.ChangeEvent changeEvent = new Replication.ChangeEvent(this);
        ReplicationStateTransition replicationStateTransition = new ReplicationStateTransition(transition);
        changeEvent.setTransition(replicationStateTransition);
        this.notifyChangeListeners(changeEvent);
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    @InterfaceAudience.Private
    boolean serverIsSyncGatewayVersion(String minVersion) {
        String prefix = "Couchbase Sync Gateway/";
        if (this.serverType == null) {
            return false;
        }
        if (this.serverType.startsWith(prefix)) {
            String versionString = this.serverType.substring(prefix.length());
            return versionString.compareTo(minVersion) >= 0;
        }
        return false;
    }

    @InterfaceAudience.Private
    public void addToInbox(RevisionInternal rev) {
        Log.v("Sync", "%s: addToInbox() called, rev: %s.  Thread: %s", this, rev, Thread.currentThread());
        this.batcher.queueObject(rev);
        Log.v("Sync", "%s: addToInbox() calling updateActive()", this);
        this.updateActive();
    }

    protected void updateActive() {
        Log.v("Sync", "%s: updateActive() called", this);
    }

    @InterfaceAudience.Private
    void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public Replication.Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(Replication.Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    @InterfaceAudience.Private
    protected void revisionFailed() {
        ++this.revisionsFailed;
    }

    @InterfaceAudience.Private
    public void setLastSequence(String lastSequenceIn) {
        if (lastSequenceIn != null && !lastSequenceIn.equals(this.lastSequence)) {
            Log.v("Sync", "%s: Setting lastSequence to %s from(%s)", this, lastSequenceIn, this.lastSequence);
            this.lastSequence = lastSequenceIn;
            this.saveLastSequence();
        }
    }

    protected RevisionInternal transformRevision(RevisionInternal rev) {
        if (this.revisionBodyTransformationBlock != null) {
            try {
                final int generation = rev.getGeneration();
                RevisionInternal xformed = this.revisionBodyTransformationBlock.invoke(rev);
                if (xformed == null) {
                    return null;
                }
                if (xformed != rev) {
                    assert (xformed.getDocId().equals(rev.getDocId()));
                    assert (xformed.getRevId().equals(rev.getRevId()));
                    assert (xformed.getProperties().get("_revisions").equals(rev.getProperties().get("_revisions")));
                    if (xformed.getProperties().get("_attachments") != null) {
                        RevisionInternal mx;
                        xformed = mx = new RevisionInternal(xformed.getProperties(), this.db);
                        mx.mutateAttachments(new CollectionUtils.Functor<Map<String, Object>, Map<String, Object>>(){

                            @Override
                            public Map<String, Object> invoke(Map<String, Object> info) {
                                if (info.get("revpos") != null) {
                                    return info;
                                }
                                if (info.get("data") == null) {
                                    throw new IllegalStateException("Transformer added attachment without adding data");
                                }
                                HashMap<String, Object> nuInfo = new HashMap<String, Object>(info);
                                nuInfo.put("revpos", generation);
                                return nuInfo;
                            }
                        });
                    }
                    rev = xformed;
                }
            }
            catch (Exception e) {
                Log.w("Sync", "%s: Exception transforming a revision of doc '%s", e, this, rev.getDocId());
            }
        }
        return rev;
    }

    @InterfaceAudience.Private
    protected static Status statusFromBulkDocsResponseItem(Map<String, Object> item) {
        try {
            if (!item.containsKey("error")) {
                return new Status(200);
            }
            String errorStr = (String)item.get("error");
            if (errorStr == null || errorStr.isEmpty()) {
                return new Status(200);
            }
            String statusString = (String)item.get("status");
            int status = Integer.parseInt(statusString);
            if (status >= 400) {
                return new Status(status);
            }
            if (errorStr.equalsIgnoreCase("unauthorized")) {
                return new Status(401);
            }
            if (errorStr.equalsIgnoreCase("forbidden")) {
                return new Status(403);
            }
            if (errorStr.equalsIgnoreCase("conflict")) {
                return new Status(409);
            }
            if (errorStr.equalsIgnoreCase("missing")) {
                return new Status(404);
            }
            if (errorStr.equalsIgnoreCase("not_found")) {
                return new Status(404);
            }
            return new Status(589);
        }
        catch (Exception e) {
            Log.e("CBLite", "Exception getting status from " + item, e);
            return new Status(200);
        }
    }

    private void clearDbRef() {
        try {
            Log.v("Sync", "%s: clearDbRef() called", this);
            if (!this.db.isOpen()) {
                Log.w("Sync", "Not attempting to setLastSequence, db is closed");
            } else {
                this.db.setLastSequence(this.lastSequence, this.remoteCheckpointDocID(), !this.isPull());
            }
            Log.v("Sync", "%s: clearDbRef() setting db to null", this);
            this.db = null;
        }
        catch (Exception e) {
            Log.e("Sync", "Exception in clearDbRef(): %s", e);
        }
    }

    public void setCookie(String name, String value, String path, long maxAge, boolean secure, boolean httpOnly) {
        Date now = new Date();
        Date expirationDate = new Date(now.getTime() + maxAge);
        this.setCookie(name, value, path, expirationDate, secure, httpOnly);
    }

    public void setCookie(String name, String value, String path, Date expirationDate, boolean secure, boolean httpOnly) {
        if (this.remote == null) {
            throw new IllegalStateException("Cannot setCookie since remote == null");
        }
        BasicClientCookie2 cookie = new BasicClientCookie2(name, value);
        cookie.setDomain(this.remote.getHost());
        if (path != null && path.length() > 0) {
            cookie.setPath(path);
        } else {
            cookie.setPath(this.remote.getPath());
        }
        cookie.setExpiryDate(expirationDate);
        cookie.setSecure(secure);
        List<Cookie> cookies = Arrays.asList(cookie);
        this.clientFactory.addCookies(cookies);
    }

    public void deleteCookie(String name) {
        this.clientFactory.deleteCookie(name);
    }

    HttpClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public List<String> getChannels() {
        if (this.filterParams == null || this.filterParams.isEmpty()) {
            return new ArrayList<String>();
        }
        String params = (String)this.filterParams.get(CHANNELS_QUERY_PARAM);
        if (!this.isPull() || this.getFilter() == null || !this.getFilter().equals(BY_CHANNEL_FILTER_NAME) || params == null || params.isEmpty()) {
            return new ArrayList<String>();
        }
        String[] paramsArray = params.split(",");
        return new ArrayList<String>(Arrays.asList(paramsArray));
    }

    public void setChannels(List<String> channels) {
        if (channels != null && !channels.isEmpty()) {
            if (!this.isPull()) {
                Log.w("Sync", "filterChannels can only be set in pull replications");
                return;
            }
            this.setFilter(BY_CHANNEL_FILTER_NAME);
            HashMap<String, Object> filterParams = new HashMap<String, Object>();
            filterParams.put(CHANNELS_QUERY_PARAM, TextUtils.join(",", channels));
            this.setFilterParams(filterParams);
        } else if (this.getFilter().equals(BY_CHANNEL_FILTER_NAME)) {
            this.setFilter(null);
            this.setFilterParams(null);
        }
    }

    public String getSessionID() {
        return this.sessionID;
    }

    @InterfaceAudience.Public
    public static interface ChangeListener {
        public void changed(Replication.ChangeEvent var1);
    }

    protected static enum ChangeListenerNotifyStyle {
        SYNC,
        ASYNC;

    }
}

