/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.router;

import com.couchbase.lite.internal.Body;
import com.couchbase.lite.router.Header;
import com.couchbase.lite.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class URLConnection
extends HttpURLConnection {
    private Header resHeader;
    private boolean sentRequest = false;
    private ByteArrayOutputStream os;
    private Body responseBody;
    private boolean chunked = false;
    private HashMap<String, List<String>> requestProperties = new HashMap();
    private static final String POST = "POST";
    private static final String GET = "GET";
    private static final String PUT = "PUT";
    private static final String HEAD = "HEAD";
    private OutputStream responseOutputStream;
    private InputStream responseInputStream = new PipedInputStream();
    private InputStream requestInputStream;

    public URLConnection(URL url) {
        super(url);
        try {
            this.responseOutputStream = new PipedOutputStream((PipedInputStream)this.responseInputStream);
        }
        catch (IOException e) {
            Log.e("Router", "Exception creating piped output stream", e);
        }
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean usingProxy() {
        return false;
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (String key : this.requestProperties.keySet()) {
            map.put(key, Collections.unmodifiableList(this.requestProperties.get(key)));
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public String getRequestProperty(String field) {
        List<String> valuesList = this.requestProperties.get(field);
        if (valuesList == null) {
            return null;
        }
        return valuesList.get(0);
    }

    @Override
    public void setRequestProperty(String field, String newValue) {
        ArrayList<String> valuesList = new ArrayList<String>();
        valuesList.add(newValue);
        this.requestProperties.put(field, valuesList);
    }

    @Override
    public String getHeaderField(int pos) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (null == this.resHeader) {
            return null;
        }
        return this.resHeader.get(pos);
    }

    @Override
    public String getHeaderField(String key) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (null == this.resHeader) {
            return null;
        }
        return this.resHeader.get(key);
    }

    @Override
    public String getHeaderFieldKey(int pos) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (null == this.resHeader) {
            return null;
        }
        return this.resHeader.getKey(pos);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (null == this.resHeader) {
            return null;
        }
        return this.resHeader.getFieldMap();
    }

    Header getResHeader() {
        if (this.resHeader == null) {
            this.resHeader = new Header();
        }
        return this.resHeader;
    }

    @Override
    public int getResponseCode() {
        return this.responseCode;
    }

    void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    void setResponseBody(Body responseBody) {
        this.responseBody = responseBody;
    }

    public Body getResponseBody() {
        return this.responseBody;
    }

    String getBaseContentType() {
        String type = this.resHeader.get("Content-Type");
        if (type == null) {
            return null;
        }
        int delimeterPos = type.indexOf(59);
        if (delimeterPos > 0) {
            type = type.substring(delimeterPos);
        }
        return type;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (!this.doOutput) {
            throw new ProtocolException("Must set doOutput");
        }
        if (this.sentRequest) {
            throw new ProtocolException("Can't write after you read");
        }
        if (this.os != null) {
            return this.os;
        }
        if (this.method != PUT && this.method != POST) {
            throw new ProtocolException("Can only write to PUT or POST");
        }
        if (!this.connected) {
            this.connect();
        }
        this.os = new ByteArrayOutputStream();
        return this.os;
    }

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public void setResponseInputStream(InputStream responseInputStream) {
        this.responseInputStream = responseInputStream;
    }

    public InputStream getResponseInputStream() {
        return this.responseInputStream;
    }

    public void setResponseOutputStream(OutputStream responseOutputStream) {
        this.responseOutputStream = responseOutputStream;
    }

    public OutputStream getResponseOutputStream() {
        return this.responseOutputStream;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.responseInputStream;
    }

    public InputStream getRequestInputStream() {
        return this.requestInputStream;
    }

    public void setRequestInputStream(InputStream requestInputStream) {
        this.requestInputStream = requestInputStream;
    }
}

