/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

import com.couchbase.lite.Manager;
import com.couchbase.lite.util.Log;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LazyJsonArray<T>
extends AbstractList<T> {
    private boolean parsed = false;
    private byte[] json;
    private List<T> cache = new ArrayList<T>();
    private Iterator<T> cacheIterator;

    public LazyJsonArray(byte[] json) {
        if (json[0] != 91) {
            throw new IllegalArgumentException("data must represent a JSON array");
        }
        this.json = json;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.parsed) {
            return this.cache.iterator();
        }
        this.parseJson();
        return this.cache.iterator();
    }

    @Override
    public T get(int index) {
        if (this.parsed) {
            return this.cache.get(index);
        }
        this.parseJson();
        return this.cache.get(index);
    }

    @Override
    public int size() {
        if (this.parsed) {
            return this.cache.size();
        }
        this.parseJson();
        return this.cache.size();
    }

    @Override
    public boolean contains(Object o) {
        if (this.parsed) {
            return this.cache.contains(o);
        }
        this.parseJson();
        return this.cache.contains(o);
    }

    @Override
    public Object[] toArray() {
        if (this.parsed) {
            return this.cache.toArray();
        }
        this.parseJson();
        return this.cache.toArray();
    }

    @Override
    public <S> S[] toArray(S[] a) {
        if (this.parsed) {
            return this.cache.toArray(a);
        }
        this.parseJson();
        return this.cache.toArray(a);
    }

    @Override
    public int hashCode() {
        if (this.parsed) {
            return this.cache.hashCode();
        }
        this.parseJson();
        return this.cache.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseJson() {
        if (this.parsed) {
            return;
        }
        try {
            List parsedvalues = (List)Manager.getObjectMapper().readValue(this.json, Object.class);
            parsedvalues.addAll(this.cache);
            this.cache = parsedvalues;
        }
        catch (Exception e) {
            Log.e("CBLite", this.getClass().getName() + ": Failed to parse Json data: ", e);
        }
        finally {
            this.parsed = true;
            this.json = null;
        }
    }
}

