/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.support.SerializableCookie;
import com.couchbase.lite.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;

public class PersistentCookieStore
implements CookieStore {
    private static final String COOKIE_LOCAL_DOC_NAME = "PersistentCookieStore";
    private boolean omitNonPersistentCookies = false;
    private final ConcurrentHashMap<String, Cookie> cookies;
    private WeakReference<Database> dbWeakRef;

    public PersistentCookieStore(Database db) {
        this.dbWeakRef = new WeakReference<Database>(db);
        this.cookies = new ConcurrentHashMap();
        this.loadPreviouslyStoredCookies(db);
        this.clearExpired(new Date());
    }

    private Database getDb() {
        return (Database)this.dbWeakRef.get();
    }

    private void loadPreviouslyStoredCookies(Database db) {
        try {
            Map<String, Object> cookiesDoc = db.getExistingLocalDocument(COOKIE_LOCAL_DOC_NAME);
            if (cookiesDoc == null) {
                return;
            }
            for (String name : cookiesDoc.keySet()) {
                Cookie decodedCookie;
                String encodedCookie;
                if (name.startsWith("_") || (encodedCookie = (String)cookiesDoc.get(name)) == null || (decodedCookie = this.decodeCookie(encodedCookie)) == null || decodedCookie.isExpired(new Date())) continue;
                this.cookies.put(name, decodedCookie);
            }
        }
        catch (Exception e) {
            Log.e("Sync", "Exception loading previously stored cookies", e);
        }
    }

    public void addCookie(Cookie cookie) {
        if (this.omitNonPersistentCookies && !cookie.isPersistent()) {
            return;
        }
        String name = cookie.getName() + cookie.getDomain();
        if (this.cookies.containsKey(name) && this.cookies.get(name).equals(cookie)) {
            return;
        }
        if (!cookie.isExpired(new Date())) {
            this.cookies.put(name, cookie);
        } else {
            this.cookies.remove(name);
        }
        String encodedCookie = this.encodeCookie(new SerializableCookie(cookie));
        Map<String, Object> cookiesDoc = this.getDb().getExistingLocalDocument(COOKIE_LOCAL_DOC_NAME);
        if (cookiesDoc == null) {
            cookiesDoc = new HashMap<String, Object>();
        }
        Log.v("Sync", "Saving cookie: %s w/ encoded value: %s", name, encodedCookie);
        cookiesDoc.put(name, encodedCookie);
        try {
            this.getDb().putLocalDocument(COOKIE_LOCAL_DOC_NAME, cookiesDoc);
        }
        catch (CouchbaseLiteException e) {
            Log.e("Sync", "Exception saving local doc", e);
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        try {
            this.getDb().putLocalDocument(COOKIE_LOCAL_DOC_NAME, null);
        }
        catch (CouchbaseLiteException e) {
            Log.e("Sync", "Exception saving local doc", e);
            throw new RuntimeException(e);
        }
        this.cookies.clear();
    }

    public boolean clearExpired(Date date) {
        boolean clearedAny = false;
        for (Map.Entry<String, Cookie> entry : this.cookies.entrySet()) {
            String name = entry.getKey();
            Cookie cookie = entry.getValue();
            if (!cookie.isExpired(date)) continue;
            this.cookies.remove(name);
            this.deletePersistedCookie(name);
            clearedAny = true;
        }
        return clearedAny;
    }

    private void deletePersistedCookie(String name) {
        Map<String, Object> cookiesDoc = this.getDb().getExistingLocalDocument(COOKIE_LOCAL_DOC_NAME);
        if (cookiesDoc == null) {
            return;
        }
        cookiesDoc.remove(name);
        try {
            this.getDb().putLocalDocument(COOKIE_LOCAL_DOC_NAME, cookiesDoc);
        }
        catch (CouchbaseLiteException e) {
            Log.e("Sync", "Exception saving local doc", e);
            throw new RuntimeException(e);
        }
    }

    public List<Cookie> getCookies() {
        return new ArrayList<Cookie>(this.cookies.values());
    }

    public void setOmitNonPersistentCookies(boolean omitNonPersistentCookies) {
        this.omitNonPersistentCookies = omitNonPersistentCookies;
    }

    public void deleteCookie(Cookie cookie) {
        String name = cookie.getName();
        this.cookies.remove(name);
        this.deletePersistedCookie(name);
    }

    String encodeCookie(SerializableCookie cookie) {
        if (cookie == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ObjectOutputStream outputStream = new ObjectOutputStream(os);
            outputStream.writeObject(cookie);
        }
        catch (Exception e) {
            Log.e("Sync", String.format("encodeCookie failed.  cookie: %s", cookie), e);
            return null;
        }
        return this.byteArrayToHexString(os.toByteArray());
    }

    Cookie decodeCookie(String cookieString) {
        Cookie cookie = null;
        try {
            byte[] bytes = this.hexStringToByteArray(cookieString);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            cookie = ((SerializableCookie)objectInputStream.readObject()).getCookie();
        }
        catch (Exception exception) {
            Log.d("Sync", String.format("decodeCookie failed.  encoded cookie: %s", cookieString), exception);
        }
        return cookie;
    }

    protected String byteArrayToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte element : bytes) {
            int v = element & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString().toUpperCase(Locale.US);
    }

    protected byte[] hexStringToByteArray(String hexString) {
        int len = hexString.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }
}

