/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.util;

import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.storage.Cursor;
import com.couchbase.lite.storage.SQLException;
import com.couchbase.lite.storage.SQLiteStorageEngine;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;

public class Utils {
    protected static final char[] hexArray = "0123456789abcdef".toCharArray();

    public static boolean isEqual(Object obj1, Object obj2) {
        if (obj1 != null) {
            return obj2 != null && obj1.equals(obj2);
        }
        return obj2 == null;
    }

    public static boolean isTransientError(Throwable throwable) {
        if (throwable instanceof CouchbaseLiteException) {
            CouchbaseLiteException e = (CouchbaseLiteException)throwable;
            return Utils.isTransientError(e.getCBLStatus().getCode());
        }
        if (throwable instanceof HttpResponseException) {
            HttpResponseException e = (HttpResponseException)throwable;
            return Utils.isTransientError(e.getStatusCode());
        }
        return false;
    }

    public static boolean isTransientError(StatusLine status) {
        return Utils.isTransientError(status.getStatusCode());
    }

    public static boolean isTransientError(int statusCode) {
        return statusCode == 500 || statusCode == 502 || statusCode == 503 || statusCode == 504;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] byteArrayResultForQuery(SQLiteStorageEngine database, String query, String[] args) throws SQLException {
        byte[] result = null;
        Cursor cursor = null;
        try {
            cursor = database.rawQuery(query, args);
            if (cursor.moveToNext()) {
                result = cursor.getBlob(0);
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static void assertNotNull(Object o, String errMsg) {
        if (o == null) {
            throw new IllegalArgumentException(errMsg);
        }
    }

    @InterfaceAudience.Private
    public static boolean is404(Throwable e) {
        if (e instanceof HttpResponseException) {
            return ((HttpResponseException)e).getStatusCode() == 404;
        }
        return false;
    }

    @InterfaceAudience.Private
    public static int getStatusFromError(Throwable t) {
        if (t instanceof CouchbaseLiteException) {
            CouchbaseLiteException couchbaseLiteException = (CouchbaseLiteException)t;
            return couchbaseLiteException.getCBLStatus().getCode();
        }
        if (t instanceof HttpResponseException) {
            HttpResponseException responseException = (HttpResponseException)t;
            return responseException.getStatusCode();
        }
        return -1;
    }

    public static String shortenString(String orig, int maxLength) {
        if (orig == null || orig.length() <= maxLength) {
            return orig;
        }
        return orig.substring(0, maxLength);
    }
}

