/*
 * Decompiled with CFR 0.152.
 */
package Acme.Serve;

import Acme.Serve.CgiServlet;
import Acme.Serve.FileServlet;
import Acme.Serve.WarDeployer;
import Acme.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.nio.channels.AsynchronousCloseException;
import java.security.Principal;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class Serve
implements ServletContext,
Serializable {
    public static final String ARG_PORT = "port";
    public static final String ARG_THROTTLES = "throttles";
    public static final String ARG_SERVLETS = "servlets";
    public static final String ARG_REALMS = "realms";
    public static final String ARG_ALIASES = "aliases";
    public static final String ARG_BINDADDRESS = "bind-address";
    public static final String ARG_BACKLOG = "backlog";
    public static final String ARG_CGI_PATH = "cgi-path";
    public static final String ARG_ERR = "error-stream";
    public static final String ARG_OUT = "out-stream";
    public static final String ARG_SESSION_TIMEOUT = "session-timeout";
    public static final String ARG_LOG_DIR = "log-dir";
    public static final String ARG_LOG_OPTIONS = "log-options";
    public static final String ARG_LOGROLLING_LINES = "log-rolling-lines-threshold";
    public static final String ARG_NOHUP = "nohup";
    public static final String ARG_JSP = "JSP";
    public static final String ARG_WAR = "war-deployer";
    public static final String ARG_KEEPALIVE = "keep-alive";
    public static final String ARG_PROXY_CONFIG = "proxy-config";
    public static final String DEF_LOGENCODING = "tjws.serve.log.encoding";
    public static final String DEF_PROXY_CONFIG = "tjws.proxy.ssl";
    public static final String ARG_KEEPALIVE_TIMEOUT = "timeout-keep-alive";
    public static final String ARG_MAX_CONN_USE = "max-alive-conn-use";
    public static final String ARG_SESSION_PERSIST = "sssn-persistance";
    public static final String ARG_MAX_ACTIVE_SESSIONS = "max-active-sessions";
    public static final String ARG_ACCESS_LOG_FMT = "access-log-format";
    public static final String ARG_ACCEPTOR_CLASS = "acceptorImpl";
    public static final String ARG_WORK_DIRECTORY = "workdirectory";
    public static final String ARG_SESSION_SEED = "SessionSeed";
    public static final String ARG_HTTPONLY_SC = "sessionhttponly";
    public static final String ARG_SECUREONLY_SC = "sessionsecureonly";
    public static final String ARG_THREAD_POOL_SIZE = "Acme.Utils.ThreadPool.maxpooledthreads";
    protected static final int DEF_SESSION_TIMEOUT = 30;
    protected static final int DEF_MIN_ACT_SESS = 10;
    protected static final int DESTROY_TIME_SEC = 15;
    protected static final int HTTP_MAX_HDR_LEN = 0xA00000;
    public static final int DEF_PORT = 8080;
    public static final String BGCOLOR = "BGCOLOR=\"#D1E9FE\"";
    public static final String LINE_SEP = System.getProperty("line.separator", "\n");
    protected static final int DEF_MAX_CONN_USE = 100;
    protected static final Integer INT_ZERO = new Integer(0);
    public static final String UTF8 = "UTF-8";
    protected String hostName;
    private transient PrintStream logStream;
    private boolean useAccLog;
    private boolean keepAlive;
    private boolean proxyConfig;
    private boolean proxySSL;
    private int timeoutKeepAlive;
    private int maxAliveConnUse;
    private boolean showUserAgent;
    private boolean showReferer;
    protected String keepAliveHdrParams;
    protected transient PathTreeDictionary defaultRegistry;
    protected transient HashMap virtuals;
    protected transient PathTreeDictionary realms;
    protected transient PathTreeDictionary mappingtable;
    private Hashtable attributes;
    protected transient KeepAliveCleaner keepAliveCleaner;
    protected transient ThreadGroup serverThreads;
    protected transient Utils.ThreadPool threadPool;
    protected transient Constructor gzipInStreamConstr;
    private static final ThreadLocal currentRegistry = new ThreadLocal();
    private byte[] uniqer = new byte[20];
    private SecureRandom srandom;
    protected HttpSessionContextImpl sessions;
    public int expiredIn;
    public boolean httpSessCookie;
    public boolean secureSessCookie;
    public Map arguments;
    public Properties mime;
    transient boolean running;
    protected transient Acceptor acceptor;
    protected transient Thread ssclThread;

    public Serve(Map map, PrintStream printStream) {
        int n;
        this.arguments = map;
        this.logStream = printStream;
        this.defaultRegistry = new PathTreeDictionary();
        this.realms = new PathTreeDictionary();
        this.attributes = new Hashtable();
        this.serverThreads = new ThreadGroup("TJWS threads");
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)map);
        this.threadPool = new Utils.ThreadPool(properties, new Utils.ThreadFactory(){

            public Thread create(Runnable runnable) {
                Thread thread = new Thread(Serve.this.serverThreads, runnable);
                thread.setDaemon(true);
                return thread;
            }
        });
        this.setAccessLogged();
        this.keepAlive = map.get(ARG_KEEPALIVE) == null || (Boolean)map.get(ARG_KEEPALIVE) != false;
        try {
            n = Integer.parseInt((String)map.get(ARG_KEEPALIVE_TIMEOUT));
        }
        catch (Exception exception) {
            n = 30;
        }
        this.timeoutKeepAlive = n * 1000;
        try {
            this.maxAliveConnUse = Integer.parseInt((String)map.get(ARG_MAX_CONN_USE));
        }
        catch (Exception exception) {
            this.maxAliveConnUse = 100;
        }
        this.keepAliveHdrParams = "timeout=" + n + ", max=" + this.maxAliveConnUse;
        this.expiredIn = map.get(ARG_SESSION_TIMEOUT) != null ? (Integer)map.get(ARG_SESSION_TIMEOUT) : 30;
        this.srandom = new SecureRandom((map.get(ARG_SESSION_SEED) == null ? "TJWS" + new Date() : (String)map.get(ARG_SESSION_SEED)).getBytes());
        this.httpSessCookie = map.get(ARG_HTTPONLY_SC) != null;
        this.secureSessCookie = map.get(ARG_SECUREONLY_SC) != null;
        try {
            this.gzipInStreamConstr = Class.forName("java.util.zip.GZIPInputStream").getConstructor(InputStream.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        String string = (String)map.get(ARG_PROXY_CONFIG);
        if (string != null) {
            this.proxyConfig = true;
            this.proxySSL = "y".equalsIgnoreCase(string);
        }
        this.initMime();
    }

    public Serve() {
        this(new HashMap(), System.err);
    }

    protected void setAccessLogged() {
        String string = (String)this.arguments.get(ARG_LOG_OPTIONS);
        if (string != null) {
            this.useAccLog = true;
            this.showUserAgent = string.indexOf(65) >= 0;
            this.showReferer = string.indexOf(82) >= 0;
        } else {
            this.useAccLog = false;
        }
    }

    protected boolean isAccessLogged() {
        return this.useAccLog;
    }

    protected boolean isShowReferer() {
        return this.showReferer;
    }

    protected boolean isShowUserAgent() {
        return this.showUserAgent;
    }

    protected boolean isKeepAlive() {
        return this.keepAlive;
    }

    protected int getKeepAliveDuration() {
        return this.timeoutKeepAlive;
    }

    protected String getKeepAliveParamStr() {
        return this.keepAliveHdrParams;
    }

    protected int getMaxTimesConnectionUse() {
        return this.maxAliveConnUse;
    }

    protected void initMime() {
        this.mime = new Properties();
        try {
            this.mime.load(this.getClass().getClassLoader().getResourceAsStream("Acme/Resource/mime.properties"));
        }
        catch (Exception exception) {
            this.log("TJWS: MIME map can't be loaded:" + exception);
        }
    }

    public void addServlet(String string, String string2) {
        this.addServlet(string, string2, (Hashtable)null);
    }

    public void addServlet(String string, String string2, Hashtable hashtable) {
        int n;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n = string2.lastIndexOf(46)) > 0) {
            securityManager.checkPackageAccess(string2.substring(0, n));
            securityManager.checkPackageDefinition(string2.substring(0, n));
        }
        try {
            this.addServlet(string, (Servlet)Class.forName(string2).newInstance(), hashtable, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log("TJWS: Class not found: " + string2);
            ClassLoader classLoader = this.getClass().getClassLoader();
            this.log("TJWS: Class loader: " + classLoader);
            if (classLoader instanceof URLClassLoader) {
                this.log("TJWS: CP: " + Arrays.asList(((URLClassLoader)classLoader).getURLs()));
            }
        }
        catch (ClassCastException classCastException) {
            this.log("TJWS: Servlet class doesn't implement javax.servlet.Servlet: " + classCastException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            this.log("TJWS: Can't instantiate servlet: " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.log("TJWS: Illegal class access: " + illegalAccessException.getMessage());
        }
        catch (Exception exception) {
            this.log("TJWS: Unexpected problem of servlet creation: " + exception, exception);
        }
    }

    public void addServlet(String string, Servlet servlet, String string2) {
        this.addServlet(string, servlet, null, string2);
    }

    public void addServlet(String string, Servlet servlet) {
        this.addServlet(string, servlet, (String)null);
    }

    public synchronized void addServlet(String string, Servlet servlet, Hashtable hashtable, String string2) {
        this.setHost(string2);
        try {
            if (this.getServlet(string) != null) {
                this.log("TJWS: Servlet overriden by " + servlet + ", for path:" + string);
            }
            servlet.init((ServletConfig)new ServeConfig(this, hashtable, string));
            if (string2 != null) {
                PathTreeDictionary pathTreeDictionary;
                if (this.virtuals == null) {
                    this.virtuals = new HashMap();
                }
                if ((pathTreeDictionary = (PathTreeDictionary)this.virtuals.get(string2 = string2.toLowerCase())) == null) {
                    pathTreeDictionary = new PathTreeDictionary();
                    this.virtuals.put(string2, pathTreeDictionary);
                }
                pathTreeDictionary.put(string, servlet);
            } else {
                this.defaultRegistry.put(string, servlet);
            }
        }
        catch (ServletException servletException) {
            this.log("TJWS: Problem initializing servlet, it won't be used: " + (Object)((Object)servletException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servlet unloadServlet(Servlet servlet) {
        PathTreeDictionary pathTreeDictionary = (PathTreeDictionary)currentRegistry.get();
        if (pathTreeDictionary == null) {
            pathTreeDictionary = this.defaultRegistry;
        }
        PathTreeDictionary pathTreeDictionary2 = pathTreeDictionary;
        synchronized (pathTreeDictionary2) {
            return (Servlet)pathTreeDictionary.remove(servlet)[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadSessions(ServletContext servletContext) {
        if (this.sessions == null) {
            return;
        }
        File file = this.getPersistentFile(servletContext);
        FileWriter fileWriter = null;
        try {
            if (file != null) {
                fileWriter = new FileWriter(file);
            }
            Enumeration enumeration = this.sessions.elements();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                AcmeSession acmeSession = (AcmeSession)enumeration.nextElement();
                if (acmeSession.getServletContext() != servletContext) continue;
                if (fileWriter != null) {
                    try {
                        acmeSession.save(fileWriter);
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof ThreadDeath) {
                            throw (ThreadDeath)throwable;
                        }
                        this.log("TJWS: problem in session serialization for " + servletContext + " / " + acmeSession, throwable);
                    }
                }
                acmeSession.invalidate();
                ++n;
            }
            if (n > 0) {
                this.ssclThread.interrupt();
            }
            this.log("TJWS: invalidated " + n + " sessions for context " + servletContext, null);
        }
        catch (IOException iOException) {
            this.log("TJWS: problem in persisting sessions for  " + servletContext, iOException);
        }
        finally {
            if (fileWriter != null) {
                try {
                    ((Writer)fileWriter).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreSessions(ServletContext servletContext) {
        File file;
        File file2 = file = this.sessions == null ? null : this.getPersistentFile(servletContext);
        if (file != null && file.exists()) {
            BufferedReader bufferedReader = null;
            try {
                AcmeSession acmeSession;
                bufferedReader = new BufferedReader(new FileReader(file));
                while ((acmeSession = AcmeSession.restore(bufferedReader, Math.abs(this.expiredIn) * 60, servletContext, this.sessions)) != null) {
                    if (acmeSession.checkExpired()) continue;
                    this.sessions.put(acmeSession.getId(), acmeSession);
                }
            }
            catch (IOException iOException) {
                this.log("TJWS: problem in sessions deserialization for " + servletContext, iOException);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void addDefaultServlets(String string) {
        try {
            this.addDefaultServlets(string, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addDefaultServlets(String string, String string2) throws IOException {
        if (string != null) {
            if (this.getServlet("/" + string) == null) {
                this.addServlet("/" + string + "/*", (Servlet)new CgiServlet());
            } else {
                this.log("TJWS: Servlet for path '/" + string + "' already defined and no default will be used.");
            }
        }
        if (this.getServlet("/*") == null) {
            if (string2 != null) {
                this.addServlet("/*", (Servlet)new FileServlet(string2, null));
            } else {
                this.addServlet("/*", (Servlet)new FileServlet());
            }
        } else {
            this.log("TJWS: Servlet for path '/' already defined and no default will be used.");
        }
    }

    protected void addWarDeployer(String string, String string2) {
        if (string == null) {
            string = "rogatkin.web.WarRoller";
        }
        try {
            WarDeployer warDeployer = (WarDeployer)Class.forName(string).newInstance();
            warDeployer.deploy(this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log("TJWS: Problem initializing war deployer: " + classNotFoundException);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            this.log("TJWS: Problem in war(s) deployment", throwable);
        }
    }

    protected File getPersistentFile() {
        return this.getPersistentFile(null);
    }

    protected File getPersistentFile(ServletContext servletContext) {
        if (this.arguments.get(ARG_SESSION_PERSIST) == null || (Boolean)this.arguments.get(ARG_SESSION_PERSIST) == Boolean.FALSE) {
            return null;
        }
        String string = (String)this.arguments.get(ARG_WORK_DIRECTORY);
        if (string == null) {
            string = ".";
        }
        return new File(string, this.hostName + '-' + (this.arguments.get(ARG_PORT) == null ? String.valueOf(8080) : this.arguments.get(ARG_PORT)) + (servletContext == null ? "" : "-" + servletContext.getServletContextName()) + "-session.obj");
    }

    protected void console(String string) {
        System.out.println(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int serve() {
        block51: {
            Exception exception3222;
            block50: {
                Closeable closeable;
                if (this.running) {
                    return -2;
                }
                if (this.acceptor != null) {
                    return -3;
                }
                try {
                    this.acceptor = this.createAcceptor();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    this.log("TJWS: Acceptor: " + throwable);
                    this.acceptor = null;
                    if (throwable instanceof BindException) {
                        return 3;
                    }
                    if (throwable instanceof IOException) {
                        return 1;
                    }
                    return 2;
                }
                this.running = true;
                if (this.expiredIn > 0) {
                    this.ssclThread = new Thread(this.serverThreads, new Runnable(){

                        public void run() {
                            while (Serve.this.running) {
                                try {
                                    Thread.sleep(Serve.this.expiredIn * 60 * 1000);
                                }
                                catch (InterruptedException interruptedException) {
                                    if (!Serve.this.running) break;
                                }
                                Enumeration enumeration = Serve.this.sessions.keys();
                                while (enumeration.hasMoreElements()) {
                                    AcmeSession acmeSession;
                                    Object k = enumeration.nextElement();
                                    if (k == null || (acmeSession = (AcmeSession)Serve.this.sessions.get(k)) == null || !acmeSession.checkExpired() && acmeSession.isValid() || (acmeSession = (AcmeSession)Serve.this.sessions.remove(k)) == null || !acmeSession.isValid()) continue;
                                    try {
                                        acmeSession.invalidate();
                                    }
                                    catch (IllegalStateException illegalStateException) {}
                                }
                            }
                        }
                    }, "Session cleaner");
                    this.ssclThread.setPriority(1);
                    this.ssclThread.start();
                }
                this.keepAliveCleaner = new KeepAliveCleaner();
                this.keepAliveCleaner.start();
                File file = this.getPersistentFile();
                if (file != null && file.exists()) {
                    closeable = null;
                    try {
                        closeable = new BufferedReader(new FileReader(file));
                        this.sessions = HttpSessionContextImpl.restore(closeable, Math.abs(this.expiredIn) * 60, this);
                    }
                    catch (IOException iOException) {
                        this.log("TJWS: IO error in restoring sessions.", iOException);
                    }
                    catch (Exception exception2) {
                        this.log("TJWS: Unexpected problem in restoring sessions.", exception2);
                    }
                    finally {
                        if (closeable != null) {
                            try {
                                closeable.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                if (this.sessions == null) {
                    this.sessions = new HttpSessionContextImpl();
                }
                this.console("[" + new Date() + "] TJWS httpd " + this.hostName + " - " + this.acceptor + " is listening.");
                while (this.running) {
                    try {
                        closeable = this.acceptor.accept();
                        this.keepAliveCleaner.addConnection(new ServeConnection((Socket)closeable, this));
                    }
                    catch (IOException iOException) {
                        this.log("TJWS: Accept: " + iOException);
                    }
                    catch (SecurityException securityException) {
                        this.log("TJWS: Illegal access: " + securityException);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.log("TJWS: Illegal state: " + illegalStateException);
                    }
                }
                Object var7_17 = null;
                if (this.acceptor == null) break block50;
                try {
                    this.acceptor.destroy();
                    this.acceptor = null;
                }
                catch (IOException exception3222) {
                    // empty catch block
                }
            }
            this.running = false;
            if (this.ssclThread != null) {
                this.ssclThread.interrupt();
            }
            this.ssclThread = null;
            this.keepAliveCleaner.interrupt();
            try {
                this.keepAliveCleaner.join();
                break block51;
            }
            catch (InterruptedException exception3222) {
                // empty catch block
            }
            {
                break block51;
                catch (Throwable throwable) {
                    Exception exception42222;
                    if (throwable instanceof ThreadDeath) {
                        throw (Error)throwable;
                    }
                    this.log("TJWS: Unhandled exception: " + throwable + ", server is terminating.", throwable);
                    int n = -1;
                    Object var7_18 = null;
                    if (this.acceptor != null) {
                        try {
                            this.acceptor.destroy();
                            this.acceptor = null;
                        }
                        catch (IOException exception42222) {
                            // empty catch block
                        }
                    }
                    this.running = false;
                    if (this.ssclThread != null) {
                        this.ssclThread.interrupt();
                    }
                    this.ssclThread = null;
                    this.keepAliveCleaner.interrupt();
                    try {
                        this.keepAliveCleaner.join();
                    }
                    catch (InterruptedException exception42222) {
                        // empty catch block
                    }
                    this.keepAliveCleaner.clear();
                    this.keepAliveCleaner = null;
                    return n;
                }
            }
            catch (Throwable throwable) {
                Exception exception52222;
                Object var7_19 = null;
                if (this.acceptor != null) {
                    try {
                        this.acceptor.destroy();
                        this.acceptor = null;
                    }
                    catch (IOException exception52222) {
                        // empty catch block
                    }
                }
                this.running = false;
                if (this.ssclThread != null) {
                    this.ssclThread.interrupt();
                }
                this.ssclThread = null;
                this.keepAliveCleaner.interrupt();
                try {
                    this.keepAliveCleaner.join();
                }
                catch (InterruptedException exception52222) {
                    // empty catch block
                }
                this.keepAliveCleaner.clear();
                this.keepAliveCleaner = null;
                throw throwable;
            }
        }
        this.keepAliveCleaner.clear();
        this.keepAliveCleaner = null;
        return 0;
    }

    public void notifyStop() {
        if (this.acceptor != null) {
            this.running = false;
            try {
                this.acceptor.destroy();
                this.acceptor = null;
            }
            catch (IOException iOException) {
                this.log("TJWS:  IO exception at destroying acceptor: " + this.acceptor, iOException);
            }
            catch (Exception exception) {
                this.acceptor = null;
                this.log("TJWS: An exception at destroying acceptor: " + this.acceptor, exception);
            }
        }
    }

    protected Acceptor createAcceptor() throws IOException {
        String string = (String)this.arguments.get(ARG_ACCEPTOR_CLASS);
        if (string == null) {
            string = "Acme.Serve.SimpleAcceptor";
        }
        try {
            this.acceptor = (Acceptor)Class.forName(string).newInstance();
        }
        catch (InstantiationException instantiationException) {
            this.log("TJWS: Couldn't instantiate Acceptor, the Server is inoperable", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            try {
                Constructor<?> constructor = Class.forName(string).getDeclaredConstructor(Utils.EMPTY_CLASSES);
                constructor.setAccessible(true);
                this.acceptor = (Acceptor)constructor.newInstance(Utils.EMPTY_OBJECTS);
            }
            catch (Exception exception) {
                this.log("TJWS: Acceptor is not accessable or can't be instantiated, the Server is inoperable", illegalAccessException);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = "TJWS: Acceptor class not found, the Server is inoperable";
            this.log("TJWS: Acceptor class not found, the Server is inoperable", classNotFoundException);
            this.console(string2);
            System.exit(-2);
        }
        Properties properties = new Properties();
        this.acceptor.init(this.arguments, properties);
        this.hostName = (String)properties.get(ARG_BINDADDRESS);
        return this.acceptor;
    }

    public void setHost(String string) {
        if (this.virtuals == null) {
            currentRegistry.set(this.defaultRegistry);
        } else if (string == null) {
            currentRegistry.set(this.defaultRegistry);
        } else {
            PathTreeDictionary pathTreeDictionary;
            int n = string.indexOf(58);
            if (n > 0) {
                string = string.substring(0, n);
            }
            if ((pathTreeDictionary = (PathTreeDictionary)this.virtuals.get(string.toLowerCase())) != null) {
                currentRegistry.set(pathTreeDictionary);
            } else {
                currentRegistry.set(this.defaultRegistry);
            }
        }
    }

    public Servlet getServlet(String string) {
        PathTreeDictionary pathTreeDictionary = (PathTreeDictionary)currentRegistry.get();
        if (pathTreeDictionary == null) {
            pathTreeDictionary = this.defaultRegistry;
        }
        try {
            return (Servlet)pathTreeDictionary.get(string)[0];
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public Enumeration getServlets() {
        PathTreeDictionary pathTreeDictionary = (PathTreeDictionary)currentRegistry.get();
        if (pathTreeDictionary == null) {
            pathTreeDictionary = this.defaultRegistry;
        }
        return pathTreeDictionary.elements();
    }

    public Enumeration getServletNames() {
        PathTreeDictionary pathTreeDictionary = (PathTreeDictionary)currentRegistry.get();
        if (pathTreeDictionary == null) {
            pathTreeDictionary = this.defaultRegistry;
        }
        return pathTreeDictionary.keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void destroyAllServlets() {
        Object object;
        block17: {
            AcmeSession acmeSession;
            block16: {
                File file = this.getPersistentFile();
                if (file == null || this.sessions == null) break block17;
                object = null;
                object = new FileWriter(file);
                this.sessions.save((Writer)object);
                this.log("TJWS: Sessions stored.");
                acmeSession = null;
                try {
                    ((Writer)object).close();
                }
                catch (Exception exception) {}
                break block16;
                {
                    catch (IOException iOException) {
                        this.log("TJWS: IO error in storing sessions " + iOException);
                        acmeSession = null;
                        try {
                            ((Writer)object).close();
                        }
                        catch (Exception exception) {}
                        break block16;
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof ThreadDeath) {
                            throw (ThreadDeath)throwable;
                        }
                        this.log("TJWS: Unexpected problem in storing sessions " + throwable);
                        acmeSession = null;
                        try {
                            ((Writer)object).close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    try {
                        ((Writer)object).close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            Enumeration enumeration = this.sessions.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                if (k == null || (acmeSession = (AcmeSession)this.sessions.get(k)) == null || (acmeSession = (AcmeSession)this.sessions.remove(k)) == null || !acmeSession.isValid()) continue;
                try {
                    acmeSession.invalidate();
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        this.destroyAll(this.defaultRegistry);
        if (this.virtuals != null) {
            object = this.virtuals.values().iterator();
            while (object.hasNext()) {
                this.destroyAll((PathTreeDictionary)object.next());
            }
        }
        this.defaultRegistry = new PathTreeDictionary();
        this.virtuals = null;
    }

    private void destroyAll(PathTreeDictionary pathTreeDictionary) {
        final Enumeration enumeration = pathTreeDictionary.elements();
        Runnable runnable = new Runnable(){

            public void run() {
                ((Servlet)enumeration.nextElement()).destroy();
            }
        };
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Thread thread = new Thread(runnable, "Destroy");
            thread.setDaemon(true);
            thread.start();
            try {
                thread.join(15000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!thread.isAlive()) continue;
            this.log("TJWS: Destroying thread didn't terminate in 15");
            thread.setName("Destroying took too long " + n++);
        }
    }

    protected void setMappingTable(PathTreeDictionary pathTreeDictionary) {
        this.mappingtable = pathTreeDictionary;
    }

    protected void setRealms(PathTreeDictionary pathTreeDictionary) {
        this.realms = pathTreeDictionary;
    }

    AcmeSession getSession(String string) {
        return (AcmeSession)this.sessions.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpSession createSession() {
        Integer n = (Integer)this.arguments.get(ARG_MAX_ACTIVE_SESSIONS);
        if (n != null && n < this.sessions.size()) {
            return null;
        }
        AcmeSession acmeSession = new AcmeSession(this.generateSessionId(), Math.abs(this.expiredIn) * 60, this, this.sessions);
        HttpSessionContextImpl httpSessionContextImpl = this.sessions;
        synchronized (httpSessionContextImpl) {
            this.sessions.put(acmeSession.getId(), acmeSession);
        }
        return acmeSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSession(String string) {
        HttpSessionContextImpl httpSessionContextImpl = this.sessions;
        synchronized (httpSessionContextImpl) {
            this.sessions.remove(string);
        }
    }

    public void log(String string) {
        Date date = new Date();
        this.logStream.println("[" + date.toString() + "] " + string);
    }

    public void log(String string, Throwable throwable) {
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            string = string + LINE_SEP + stringWriter;
        }
        this.log(string);
    }

    public void log(Exception exception, String string) {
        this.log(string, exception);
    }

    public String getRealPath(String string) {
        if ((string = Utils.canonicalizePath(string)) != null && this.mappingtable != null) {
            Object[] objectArray = this.mappingtable.get(string);
            if (objectArray[0] == null) {
                return null;
            }
            int n = (Integer)objectArray[1];
            int n2 = string.length();
            if (n > 0) {
                string = string.length() > n ? string.substring(n + 1) : "";
            } else if (n2 > 0) {
                for (int i = 0; i < n2; ++i) {
                    char c = string.charAt(i);
                    if (c == '/' || c == '\\') continue;
                    if (i <= 0) break;
                    string = string.substring(i);
                    break;
                }
            }
            return new File((File)objectArray[0], string).getPath();
        }
        return string;
    }

    public String getContextPath() {
        return "";
    }

    public String getMimeType(String string) {
        int n = string.lastIndexOf(46);
        if (n > 0) {
            return this.mime.getProperty(string.substring(n + 1).toUpperCase());
        }
        return null;
    }

    public String getServerInfo() {
        return "D. Rogatkin's TJWS with Android support (aka Acme.Serve) Version 1.105, $Revision: 1.267 $ (http://tjws.sourceforge.net)";
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    public void setAttribute(String string, Object object) {
        if (object != null) {
            this.attributes.put(string, object);
        } else {
            this.attributes.remove(string);
        }
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public ServletContext getContext(String string) {
        return this;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 5;
    }

    public Set getResourcePaths(String string) {
        String[] stringArray;
        String string2 = this.getRealPath(string);
        if (string2 != null && (stringArray = new File(string2).list()).length > 0) {
            HashSet<String> hashSet = new HashSet<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
            return hashSet;
        }
        return null;
    }

    public String getServletContextName() {
        return null;
    }

    public URL getResource(String string) throws MalformedURLException {
        if (string == null || string.length() == 0 || string.charAt(0) != '/') {
            throw new MalformedURLException("Path " + string + " is not in acceptable form.");
        }
        File file = new File(this.getRealPath(string));
        if (file.exists()) {
            return new URL("file", "localhost", file.getPath());
        }
        return null;
    }

    public InputStream getResourceAsStream(String string) {
        try {
            return this.getResource(string).openStream();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        if (string == null || string.length() == 0 || string.charAt(0) != '/') {
            return null;
        }
        try {
            return new SimpleRequestDispatcher(string);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getInitParameter(String string) {
        return null;
    }

    public Enumeration getInitParameterNames() {
        return Utils.EMPTY_ENUMERATION;
    }

    public RequestDispatcher getNamedDispatcher(String string) {
        return null;
    }

    synchronized String generateSessionId() {
        this.srandom.nextBytes(this.uniqer);
        return Utils.base64Encode(this.uniqer);
    }

    protected static class HttpSessionContextImpl
    extends Hashtable
    implements HttpSessionContext {
        protected HttpSessionContextImpl() {
        }

        public Enumeration getIds() {
            return this.keys();
        }

        public HttpSession getSession(String string) {
            return (HttpSession)this.get(string);
        }

        void save(Writer writer) throws IOException {
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                ((AcmeSession)enumeration.nextElement()).save(writer);
            }
        }

        static HttpSessionContextImpl restore(BufferedReader bufferedReader, int n, ServletContext servletContext) throws IOException {
            AcmeSession acmeSession;
            HttpSessionContextImpl httpSessionContextImpl = new HttpSessionContextImpl();
            while ((acmeSession = AcmeSession.restore(bufferedReader, n, servletContext, httpSessionContextImpl)) != null) {
                if (acmeSession.checkExpired()) continue;
                httpSessionContextImpl.put(acmeSession.getId(), acmeSession);
            }
            return httpSessionContextImpl;
        }
    }

    protected static class AcceptLocaleEnumeration
    implements Enumeration {
        Iterator i;

        public AcceptLocaleEnumeration(TreeSet treeSet) {
            this.i = treeSet.iterator();
        }

        public boolean hasMoreElements() {
            return this.i.hasNext();
        }

        public Object nextElement() {
            return ((LocaleWithWeight)this.i.next()).getLocale();
        }
    }

    protected static class LocaleWithWeight
    implements Comparable {
        protected float weight;
        protected Locale locale;

        LocaleWithWeight(Locale locale, float f) {
            this.locale = locale;
            this.weight = f;
        }

        public int compareTo(Object object) {
            if (object instanceof LocaleWithWeight) {
                return (int)(((LocaleWithWeight)object).weight - this.weight) * 100;
            }
            throw new IllegalArgumentException();
        }

        public Locale getLocale() {
            return this.locale;
        }
    }

    protected static class AcmeCookie
    extends Cookie {
        private boolean httpOnly;

        public AcmeCookie(String string, String string2) {
            super(string, string2);
        }

        public boolean isHttpOnly() {
            return this.httpOnly;
        }

        public void setHttpOnly(boolean bl) {
            this.httpOnly = bl;
        }
    }

    public static class AcmeSession
    extends Hashtable
    implements HttpSession {
        private long createTime = System.currentTimeMillis();
        private long lastAccessTime;
        private String id;
        private int inactiveInterval;
        private boolean expired;
        private transient ServletContext servletContext;
        private transient HttpSessionContext sessionContext;
        private transient List listeners;

        AcmeSession(String string, ServletContext servletContext, HttpSessionContext httpSessionContext) {
            this(string, 0, servletContext, httpSessionContext);
        }

        AcmeSession(String string, int n, ServletContext servletContext, HttpSessionContext httpSessionContext) {
            this.id = string;
            this.inactiveInterval = n;
            this.servletContext = servletContext;
            this.sessionContext = httpSessionContext;
        }

        public long getCreationTime() {
            return this.createTime;
        }

        public String getId() {
            return this.id;
        }

        public long getLastAccessedTime() {
            return this.lastAccessTime;
        }

        public void setMaxInactiveInterval(int n) {
            this.inactiveInterval = n;
        }

        public int getMaxInactiveInterval() {
            return this.inactiveInterval;
        }

        public HttpSessionContext getSessionContext() {
            return this.sessionContext;
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public Object getAttribute(String string) throws IllegalStateException {
            if (this.expired) {
                throw new IllegalStateException();
            }
            return this.get(string);
        }

        public Object getValue(String string) throws IllegalStateException {
            return this.getAttribute(string);
        }

        public Enumeration getAttributeNames() throws IllegalStateException {
            if (this.expired) {
                throw new IllegalStateException();
            }
            return this.keys();
        }

        public String[] getValueNames() throws IllegalStateException {
            Enumeration enumeration = this.getAttributeNames();
            Vector vector = new Vector();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        public void setAttribute(String string, Object object) throws IllegalStateException {
            Object object2;
            if (this.expired) {
                throw new IllegalStateException();
            }
            Object object3 = object2 = object != null ? this.put(string, object) : this.remove(string);
            if (object2 != null && object2 instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)object2).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
            }
            if (object != null) {
                if (object instanceof HttpSessionBindingListener) {
                    ((HttpSessionBindingListener)object).valueBound(new HttpSessionBindingEvent((HttpSession)this, string));
                }
                this.notifyListeners(string, object2, object);
            } else {
                this.notifyListeners(string, object2);
            }
        }

        public void putValue(String string, Object object) throws IllegalStateException {
            this.setAttribute(string, object);
        }

        public void removeAttribute(String string) throws IllegalStateException {
            if (this.expired) {
                throw new IllegalStateException();
            }
            Object v = this.remove(string);
            if (v != null) {
                if (v instanceof HttpSessionBindingListener) {
                    ((HttpSessionBindingListener)v).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
                }
                this.notifyListeners(string, v);
            }
        }

        public void removeValue(String string) throws IllegalStateException {
            this.removeAttribute(string);
        }

        public synchronized void invalidate() throws IllegalStateException {
            if (this.expired) {
                throw new IllegalStateException();
            }
            this.notifyListeners();
            Enumeration enumeration = this.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                this.removeAttribute((String)enumeration.nextElement());
            }
            this.listeners = null;
            this.setExpired(true);
        }

        public boolean isNew() throws IllegalStateException {
            if (this.expired) {
                throw new IllegalStateException();
            }
            return this.lastAccessTime == 0L;
        }

        public synchronized void setListeners(List list) {
            if (this.listeners == null) {
                this.listeners = list;
                if (this.listeners != null) {
                    HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)this);
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        try {
                            ((HttpSessionListener)this.listeners.get(i)).sessionCreated(httpSessionEvent);
                            continue;
                        }
                        catch (ClassCastException classCastException) {
                            continue;
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        public synchronized void setServletContext(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        private void notifyListeners() {
            if (this.listeners != null) {
                HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)this);
                for (int i = 0; i < this.listeners.size(); ++i) {
                    try {
                        ((HttpSessionListener)this.listeners.get(i)).sessionDestroyed(httpSessionEvent);
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        continue;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        }

        private void notifyListeners(String string, Object object) {
            if (this.listeners != null) {
                HttpSessionBindingEvent httpSessionBindingEvent = new HttpSessionBindingEvent((HttpSession)this, string, object);
                int n = this.listeners.size();
                for (int i = 0; i < n; ++i) {
                    try {
                        ((HttpSessionAttributeListener)this.listeners.get(i)).attributeRemoved(httpSessionBindingEvent);
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        continue;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        }

        private void notifyListeners(String string, Object object, Object object2) {
            if (this.listeners != null) {
                HttpSessionBindingEvent httpSessionBindingEvent = new HttpSessionBindingEvent((HttpSession)this, string, object2);
                HttpSessionBindingEvent httpSessionBindingEvent2 = object == null ? null : new HttpSessionBindingEvent((HttpSession)this, string, object);
                int n = this.listeners.size();
                for (int i = 0; i < n; ++i) {
                    try {
                        HttpSessionAttributeListener httpSessionAttributeListener = (HttpSessionAttributeListener)this.listeners.get(i);
                        if (httpSessionBindingEvent2 != null) {
                            httpSessionAttributeListener.attributeReplaced(httpSessionBindingEvent2);
                        }
                        httpSessionAttributeListener.attributeAdded(httpSessionBindingEvent);
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        continue;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        }

        private void setExpired(boolean bl) {
            this.expired = bl;
        }

        boolean isValid() {
            return !this.expired;
        }

        boolean checkExpired() {
            return this.inactiveInterval > 0 && (long)(this.inactiveInterval * 1000) < System.currentTimeMillis() - this.lastAccessTime;
        }

        void userTouch() {
            if (!this.isValid()) {
                throw new IllegalStateException();
            }
            this.lastAccessTime = System.currentTimeMillis();
        }

        void save(Writer writer) throws IOException {
            if (this.expired) {
                return;
            }
            writer.write(this.id);
            writer.write(58);
            writer.write(Integer.toString(this.inactiveInterval));
            writer.write(58);
            writer.write(this.servletContext == null || this.servletContext.getServletContextName() == null ? "" : this.servletContext.getServletContextName());
            writer.write(58);
            writer.write(Long.toString(this.lastAccessTime));
            writer.write("\r\n");
            Enumeration enumeration = this.getAttributeNames();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16384);
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object v = this.get(string);
                if (v instanceof Serializable) {
                    byteArrayOutputStream.reset();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                    try {
                        objectOutputStream.writeObject(v);
                        writer.write(string);
                        writer.write(":");
                        writer.write(Utils.base64Encode(byteArrayOutputStream.toByteArray()));
                        writer.write("\r\n");
                    }
                    catch (IOException iOException) {
                        this.servletContext.log("TJWS: Can't replicate/store a session value of '" + string + "' class:" + v.getClass().getName(), (Throwable)iOException);
                    }
                } else {
                    this.servletContext.log("TJWS: Non serializable session object has been " + v.getClass().getName() + " skiped in storing of " + string, null);
                }
                if (!(v instanceof HttpSessionActivationListener)) continue;
                ((HttpSessionActivationListener)v).sessionWillPassivate(new HttpSessionEvent((HttpSession)this));
            }
            writer.write("$$\r\n");
        }

        static AcmeSession restore(BufferedReader bufferedReader, int n, ServletContext servletContext, HttpSessionContext httpSessionContext) throws IOException {
            String string = bufferedReader.readLine();
            if (string == null) {
                return null;
            }
            int n2 = string.indexOf(58);
            if (n2 < 0) {
                throw new IOException("Invalid format for a session header, no session id: " + string);
            }
            String string2 = string.substring(0, n2);
            int n3 = string.indexOf(58, n2 + 1);
            if (n3 < 0) {
                throw new IOException("Invalid format for a session header, no latency: " + string);
            }
            try {
                n = Integer.parseInt(string.substring(n2 + 1, n3));
            }
            catch (NumberFormatException numberFormatException) {
                servletContext.log("TJWS: Session latency is invalid:" + string.substring(n2 + 1, n3) + " " + numberFormatException);
            }
            n2 = string.indexOf(58, n3 + 1);
            if (n2 < 0) {
                throw new IOException("TJWS: Invalid format for a session header, context name: " + string);
            }
            String string3 = string.substring(n3 + 1, n2);
            AcmeSession acmeSession = new AcmeSession(string2, n, (ServletContext)(string3.length() == 0 ? servletContext : null), httpSessionContext);
            try {
                acmeSession.lastAccessTime = Long.parseLong(string.substring(n2 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                servletContext.log("TJWS: Last access time is invalid:" + string.substring(n2 + 1) + " " + numberFormatException);
            }
            while (true) {
                Throwable throwable;
                if ((string = bufferedReader.readLine()) == null) {
                    throw new IOException("Unexpected end of a stream.");
                }
                if ("$$".equals(string)) {
                    return acmeSession;
                }
                n2 = string.indexOf(58);
                if (n2 < 0) {
                    throw new IOException("Invalid format for a session entry: " + string);
                }
                String string4 = string.substring(0, n2);
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(Utils.decode64(string.substring(n2 + 1))));
                try {
                    Object object = objectInputStream.readObject();
                    acmeSession.put(string4, object);
                    throwable = null;
                    if (object instanceof HttpSessionActivationListener) {
                        ((HttpSessionActivationListener)object).sessionDidActivate(new HttpSessionEvent((HttpSession)acmeSession));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throwable = classNotFoundException;
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    throwable = noClassDefFoundError;
                }
                catch (IOException iOException) {
                    throwable = iOException;
                }
                if (throwable == null) continue;
                servletContext.log("TJWS: Can't restore :" + string4 + ", " + throwable);
            }
        }
    }

    public static class PathTreeDictionary {
        Node root_node = new Node();
        Node ext;
        Object ctx;

        public synchronized Object[] put(String string, Object object) {
            Object object2;
            if (string.length() == 0) {
                if (this.ctx == null) {
                    this.ctx = new Node();
                }
                Object object3 = this.ctx;
                this.ctx = object;
                return new Object[]{object3, INT_ZERO};
            }
            if (string.charAt(0) == '*') {
                String string2 = null;
                if (string.length() <= 2 || string.charAt(1) != '.') {
                    throw new IllegalArgumentException("No extension specified for * starting pattern:" + string);
                }
                string2 = string.substring(1);
                if (this.ext == null) {
                    this.ext = new Node();
                }
                return new Object[]{this.ext.put(string2, object), INT_ZERO};
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\\/");
            Node node = this.root_node;
            while (stringTokenizer.hasMoreTokens()) {
                object2 = stringTokenizer.nextToken();
                int n = ((String)object2).indexOf(42);
                if (n == 0) {
                    if (((String)object2).length() > 1 || stringTokenizer.hasMoreTokens()) {
                        throw new IllegalArgumentException("Using * in other than ending /* for path:" + string);
                    }
                    object2 = "";
                } else if (n > 0) {
                    throw new IllegalArgumentException("Using * in other than ending /* for path:" + string);
                }
                Node node2 = (Node)node.get(object2);
                if (node2 == null) {
                    node2 = new Node();
                    node.put(object2, node2);
                }
                node = node2;
            }
            object2 = node.object;
            node.object = object;
            return new Object[]{object2, INT_ZERO};
        }

        public synchronized Object[] remove(Object object) {
            Object[] objectArray = this.remove(this.root_node, object);
            if (objectArray[0] == null) {
                objectArray = this.remove(null, object);
            }
            if (objectArray[0] == null) {
                return this.remove(this.ext, object);
            }
            return objectArray;
        }

        public synchronized Object[] remove(String string) {
            Object[] objectArray = this.get(string);
            if (objectArray[0] != null) {
                return this.remove(objectArray[0]);
            }
            return objectArray;
        }

        public Object[] remove(Node node, Object object) {
            if (node == null) {
                if (this.ctx == object) {
                    this.ctx = null;
                    return new Object[]{object, new Integer(0)};
                }
                return new Object[]{null, null};
            }
            if (node == this.ext) {
                Enumeration enumeration = this.ext.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    if (this.ext.get(k) != object) continue;
                    return new Object[]{this.ext.remove(k), new Integer(0)};
                }
                return new Object[]{null, null};
            }
            if (node.object == object) {
                node.object = null;
                return new Object[]{object, new Integer(0)};
            }
            Enumeration enumeration = node.keys();
            while (enumeration.hasMoreElements()) {
                Object[] objectArray = this.remove((Node)node.get((String)enumeration.nextElement()), object);
                if (objectArray[0] == null) continue;
                return objectArray;
            }
            return new Object[]{null, null};
        }

        public Object[] get(String string) {
            String string2;
            Node node;
            Object[] objectArray = new Object[2];
            if (string == null) {
                return objectArray;
            }
            if ((string.length() == 0 || string.equals("/")) && this.ctx != null) {
                objectArray[0] = this.ctx;
                objectArray[1] = INT_ZERO;
                return objectArray;
            }
            char[] cArray = string.toCharArray();
            Node node2 = this.root_node;
            int n = 0;
            int n2 = 0;
            boolean bl = true;
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == '/' || cArray[i] == '\\') {
                    if (bl) continue;
                    node = (Node)node2.get(new String(cArray, n, i - n));
                    if (node == null) {
                        node = (Node)node2.get("");
                        if (node == null || node.object == null) break;
                        objectArray[0] = node.object;
                        break;
                    }
                    node2 = node;
                    bl = true;
                    n = i + 1;
                    continue;
                }
                if (!bl) continue;
                n = i;
                bl = false;
            }
            if ((node = (Node)node2.get(string2 = new String(cArray, n, cArray.length - n))) != null) {
                if (node.object == null) {
                    node = (Node)node.get("");
                }
                if (node != null && node.object != null) {
                    objectArray[0] = node.object;
                    n2 = string2.length() > 0 ? cArray.length : n - 1;
                }
            } else {
                node = (Node)node2.get("");
                if (node != null && node.object != null) {
                    objectArray[0] = node.object;
                    int n3 = n2 = n > 0 ? n - 1 : 0;
                }
            }
            if (objectArray[0] == null) {
                int n4;
                n2 = cArray.length;
                if (this.ext != null && (n4 = string2.lastIndexOf(46)) > 0) {
                    objectArray[0] = this.ext.get(string2.substring(n4));
                }
                if (objectArray[0] == null) {
                    node = (Node)this.root_node.get("");
                    if (node != null) {
                        objectArray[0] = node.object;
                    }
                    if (objectArray[0] == null) {
                        objectArray[0] = this.root_node.object;
                    }
                }
            }
            objectArray[1] = new Integer(n2);
            return objectArray;
        }

        public Enumeration keys() {
            Vector<String> vector = new Vector<String>();
            if (this.ctx != null) {
                vector.addElement("");
            }
            if (this.root_node.object != null) {
                vector.addElement("/");
            }
            this.addSiblingNames(this.root_node, vector, "");
            if (this.ext != null) {
                Enumeration enumeration = this.ext.keys();
                while (enumeration.hasMoreElements()) {
                    vector.addElement("*" + enumeration.nextElement());
                }
            }
            return vector.elements();
        }

        public void addSiblingNames(Node node, Vector vector, String string) {
            Enumeration enumeration = node.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Node node2 = (Node)node.get(string2);
                string2 = string + '/' + (string2.length() == 0 ? "*" : string2);
                if (node2.object != null) {
                    vector.addElement(string2);
                }
                this.addSiblingNames(node2, vector, string2);
            }
        }

        public Enumeration elements() {
            Vector<Object> vector = new Vector<Object>();
            if (this.root_node.object != null) {
                vector.add(this.root_node.object);
            }
            this.addSiblingObjects(this.root_node, vector);
            return vector.elements();
        }

        public void addSiblingObjects(Node node, Vector vector) {
            Enumeration enumeration = node.keys();
            while (enumeration.hasMoreElements()) {
                Node node2 = (Node)node.get(enumeration.nextElement());
                if (node2.object != null) {
                    vector.addElement(node2.object);
                }
                this.addSiblingObjects(node2, vector);
            }
        }

        class Node
        extends Hashtable {
            Object object;
            String name;

            Node() {
            }
        }
    }

    public static class ServeOutputStream
    extends ServletOutputStream {
        private static final boolean STREAM_DEBUG = false;
        private boolean chunked;
        private boolean closed;
        private OutputStream out;
        private ServeConnection conn;
        private int inInclude;
        private String encoding;
        private long lbytes;
        private Utils.SimpleBuffer buffer;

        public ServeOutputStream(OutputStream outputStream, ServeConnection serveConnection) {
            this.out = outputStream;
            this.conn = serveConnection;
            this.buffer = new Utils.SimpleBuffer();
            this.encoding = serveConnection.getCharacterEncoding();
            if (this.encoding == null) {
                this.encoding = "ISO-8859-1";
            }
        }

        protected void reset() {
            if (this.lbytes != 0L) {
                throw new IllegalStateException("Result was already committed");
            }
            this.buffer.reset();
        }

        protected int getBufferSize() {
            return this.buffer.getSize();
        }

        protected void setBufferSize(int n) {
            if (this.lbytes > 0L) {
                throw new IllegalStateException("Bytes already written in response");
            }
            this.buffer.setSize(n);
        }

        protected void setChunked(boolean bl) {
            this.chunked = bl;
        }

        public void print(String string) throws IOException {
            this.write(string.getBytes(this.encoding));
        }

        public void write(int n) throws IOException {
            this.write(new byte[]{(byte)n}, 0, 1);
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.closed) {
                throw new IOException("An attempt of writing " + n2 + " bytes to a closed out.");
            }
            if (n2 == 0) {
                return;
            }
            this.conn.writeHeaders();
            byArray = this.buffer.put(byArray, n, n2);
            n2 = byArray.length;
            if (n2 == 0) {
                return;
            }
            n = 0;
            if (this.chunked) {
                String string = Integer.toHexString(n2);
                this.out.write((string + "\r\n").getBytes());
                this.lbytes += (long)(2 + string.length());
                this.out.write(byArray, n, n2);
                this.lbytes += (long)n2;
                this.out.write("\r\n".getBytes());
                this.lbytes += 2L;
            } else {
                this.out.write(byArray, n, n2);
                this.lbytes += (long)n2;
            }
        }

        public void flush() throws IOException {
            if (this.closed) {
                return;
            }
            this.conn.writeHeaders();
            if (this.closed) {
                return;
            }
            byte[] byArray = this.buffer.get();
            if (byArray.length > 0) {
                if (this.chunked) {
                    String string = Integer.toHexString(byArray.length);
                    this.out.write((string + "\r\n").getBytes());
                    this.lbytes += (long)(2 + string.length());
                    this.out.write(byArray);
                    this.lbytes += (long)byArray.length;
                    this.out.write("\r\n".getBytes());
                    this.lbytes += 2L;
                } else {
                    this.out.write(byArray);
                    this.lbytes += (long)byArray.length;
                }
            }
            this.out.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                this.flush();
                if (this.inInclude == 0) {
                    if (this.chunked) {
                        this.out.write("0\r\n\r\n".getBytes());
                        this.lbytes += 5L;
                        this.out.flush();
                    }
                    if (!this.conn.keepAlive) {
                        this.out.close();
                    } else {
                        this.out = null;
                        this.conn = null;
                    }
                }
            }
            finally {
                this.closed = true;
            }
        }

        private long lengthWritten() {
            return this.lbytes;
        }

        boolean isInInclude() {
            return this.inInclude == 0;
        }

        void setInInclude(boolean bl) {
            this.inInclude = bl ? 1 : 0;
        }
    }

    public static class ServeInputStream
    extends ServletInputStream {
        private static final boolean STREAM_DEBUG = false;
        private InputStream in;
        private InputStream origIn;
        private ServeConnection conn;
        private int chunksize = 0;
        private boolean chunking = false;
        private boolean compressed;
        private boolean returnedAsReader;
        private boolean returnedAsStream;
        private long contentLength = -1L;
        private long readCount;
        private byte[] oneReadBuf = new byte[1];
        private boolean closed;

        public ServeInputStream(InputStream inputStream, ServeConnection serveConnection) {
            this.conn = serveConnection;
            this.in = new BufferedInputStream(inputStream);
        }

        void refresh() {
            this.returnedAsReader = false;
            this.returnedAsStream = false;
            this.contentLength = -1L;
            this.readCount = 0L;
            this.chunksize = 0;
            this.closed = false;
            this.compressed(false);
        }

        public void chunking(boolean bl) {
            if (this.contentLength == -1L) {
                this.chunking = bl;
            }
        }

        boolean compressed(boolean bl) {
            block8: {
                if (bl) {
                    if (!this.compressed) {
                        this.origIn = this.in;
                        try {
                            ServeInputStream serveInputStream = new ServeInputStream(this.in, this.conn);
                            if (this.chunking) {
                                serveInputStream.chunking(true);
                                this.chunking(false);
                            }
                            this.in = (InputStream)((ServeConnection)this.conn).serve.gzipInStreamConstr.newInstance(new Object[]{serveInputStream});
                            this.compressed = true;
                        }
                        catch (Exception exception) {
                            if (exception instanceof InvocationTargetException) {
                                this.conn.serve.log("TJWS: Problem in compressed stream creation", ((InvocationTargetException)exception).getTargetException());
                                break block8;
                            }
                            this.conn.serve.log("TJWS: Problem in compressed stream obtaining", exception);
                        }
                    }
                } else if (this.compressed) {
                    this.compressed = false;
                    this.in = this.origIn;
                }
            }
            return this.compressed;
        }

        void setContentLength(long l) {
            if (this.contentLength == -1L && l >= 0L && !this.chunking) {
                this.contentLength = l;
                this.readCount = 0L;
            }
        }

        protected String readLine(int n) throws IOException {
            int n2;
            if (n <= 0) {
                throw new IllegalArgumentException("Max len:" + n);
            }
            StringBuffer stringBuffer = new StringBuffer(Math.min(8192, n));
            boolean bl = false;
            int n3 = 0;
            while ((n2 = this.in.read()) != -1) {
                if (n2 == 10) {
                    if (!bl) break;
                    break;
                }
                if (n2 == 13) {
                    bl = true;
                    continue;
                }
                bl = false;
                if (n3 >= n) {
                    throw new IOException("Line lenght exceeds " + n);
                }
                stringBuffer.append((char)n2);
                ++n3;
            }
            if (n2 == -1 && stringBuffer.length() == 0) {
                return null;
            }
            return stringBuffer.toString();
        }

        public int read() throws IOException {
            int n = this.read(this.oneReadBuf, 0, 1);
            if (n == 1) {
                return 0xFF & this.oneReadBuf[0];
            }
            return -1;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.closed) {
                throw new IOException("The stream is already closed");
            }
            if (this.chunking) {
                if (this.chunksize <= 0 && this.getChunkSize() <= 0) {
                    return -1;
                }
                if (n2 > this.chunksize) {
                    n2 = this.chunksize;
                }
                this.chunksize = (n2 = this.in.read(byArray, n, n2)) < 0 ? -1 : this.chunksize - n2;
            } else if (this.contentLength >= 0L) {
                if (this.readCount >= this.contentLength) {
                    return -1;
                }
                if (this.contentLength - (long)n2 < this.readCount) {
                    n2 = (int)(this.contentLength - this.readCount);
                }
                if ((n2 = this.in.read(byArray, n, n2)) > 0) {
                    this.readCount += (long)n2;
                }
            } else {
                n2 = this.in.read(byArray, n, n2);
            }
            return n2;
        }

        public long skip(long l) throws IOException {
            if (this.closed) {
                throw new IOException("The stream is already closed");
            }
            if (this.chunking) {
                if (this.chunksize <= 0 && this.getChunkSize() <= 0) {
                    return -1L;
                }
                if (l > (long)this.chunksize) {
                    l = this.chunksize;
                }
                this.chunksize = (l = this.in.skip(l)) < 0L ? -1 : this.chunksize - (int)l;
            } else if (this.contentLength >= 0L) {
                if ((l = Math.min(l, this.contentLength - this.readCount)) <= 0L) {
                    return -1L;
                }
                l = this.in.skip(l);
                this.readCount += l;
            } else {
                l = this.in.skip(l);
            }
            return l;
        }

        public int available() throws IOException {
            if (this.closed) {
                return 0;
            }
            if (this.chunking) {
                int n = this.in.available();
                if (n <= this.chunksize) {
                    return n;
                }
                return this.chunksize;
            }
            if (this.contentLength >= 0L) {
                int n = this.in.available();
                if (this.contentLength - this.readCount < Integer.MAX_VALUE) {
                    return Math.min(n, (int)(this.contentLength - this.readCount));
                }
                return n;
            }
            return this.in.available();
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.chunking) {
                while (this.read() >= 0) {
                }
            } else if (this.contentLength >= 0L) {
                long l;
                for (long i = this.contentLength - this.readCount; i > 0L && (l = this.skip(i)) > 0L; i -= l) {
                }
            }
            if (!this.conn.keepAlive) {
                this.in.close();
            }
            this.closed = true;
        }

        public boolean markSupported() {
            return false;
        }

        public void reset() throws IOException {
            if (this.closed) {
                throw new IOException("The stream is already closed");
            }
            this.in.reset();
        }

        public void mark(int n) {
        }

        private int getChunkSize() throws IOException {
            if (this.chunksize < 0) {
                return -1;
            }
            this.chunksize = -1;
            this.chunking = false;
            String string = this.readLine(60);
            while (string != null && string.length() == 0) {
                string = this.readLine(60);
            }
            this.chunking = true;
            if (string == null) {
                return -1;
            }
            int n = string.indexOf(59);
            if (n > 0) {
                string = string.substring(0, n).trim();
            }
            try {
                this.chunksize = Integer.parseInt(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Chunked stream is broken, " + string);
            }
            if (this.chunksize == 0) {
                this.chunksize = -1;
                this.readLine(60);
                this.chunking = false;
            }
            return this.chunksize;
        }

        boolean isReturnedAsStream() {
            return this.returnedAsStream;
        }

        void setReturnedAsStream(boolean bl) {
            this.returnedAsStream = bl;
        }

        boolean isReturnedAsReader() {
            return this.returnedAsReader;
        }

        void setReturnedAsReader(boolean bl) {
            this.returnedAsReader = bl;
        }
    }

    public static class BasicAuthRealm
    extends Hashtable {
        private String name;

        public BasicAuthRealm(String string) {
            this.name = string;
        }

        String name() {
            return this.name;
        }
    }

    public static class ServeConnection
    implements Runnable,
    HttpServletRequest,
    HttpServletResponse {
        public static final String WWWFORMURLENCODE = "application/x-www-form-urlencoded";
        public static final String TRANSFERENCODING = "transfer-encoding".toLowerCase();
        public static final String KEEPALIVE = "Keep-Alive".toLowerCase();
        public static final String CONTENT_ENCODING = "Content-Encoding".toLowerCase();
        public static final String CONNECTION = "Connection".toLowerCase();
        public static final String CHUNKED = "chunked";
        public static final String CONTENTLENGTH = "Content-Length".toLowerCase();
        public static final String CONTENTTYPE = "Content-Type".toLowerCase();
        public static final String SETCOOKIE = "Set-Cookie".toLowerCase();
        public static final String HOST = "Host".toLowerCase();
        public static final String COOKIE = "Cookie".toLowerCase();
        public static final String ACCEPT_LANGUAGE = "Accept-Language".toLowerCase();
        public static final String SESSION_COOKIE_NAME = "JSESSIONID";
        public static final String SESSION_URL_NAME = ";$sessionid$";
        public static final String FORWARDED_FOR = "x-Forwarded-for".toLowerCase();
        public static final String FORWARDED_HOST = "X-Forwarded-Host".toLowerCase();
        public static final String FORWARDED_SERVER = "X-Forwarded-Server".toLowerCase();
        private static final Map EMPTYHASHTABLE = new Hashtable();
        private Socket socket;
        private Hashtable sslAttributes;
        private Serve serve;
        private ServletInputStream in;
        private ServletOutputStream out;
        private String scheme;
        private AsyncCallback asyncMode;
        private Thread requestThread;
        private long asyncTimeout;
        private String reqMethod;
        private String reqUriPath;
        private String reqUriPathUn;
        private String reqProtocol;
        private String charEncoding;
        private String remoteUser;
        private String authType;
        private boolean oneOne;
        private boolean reqMime;
        private Vector reqHeaderNames = new Vector();
        private Vector reqHeaderValues = new Vector();
        private Locale locale;
        private int uriLen;
        protected boolean keepAlive = true;
        protected int timesRequested;
        protected long lastRun;
        protected long lastWait;
        private Vector outCookies;
        private Vector inCookies;
        private String sessionCookieValue;
        private String sessionUrlValue;
        private String sessionValue;
        private String reqSessionValue;
        protected String reqQuery;
        private PrintWriter pw;
        private ServletOutputStream rout;
        private Map formParameters;
        private Hashtable attributes = new Hashtable();
        private int resCode = -1;
        private String resMessage;
        private Hashtable resHeaderNames = new Hashtable();
        private String[] postCache;
        private boolean headersWritten;
        private MessageFormat accessFmt;
        private Object[] logPlaceholders;
        private final SimpleDateFormat expdatefmt = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss 'GMT'", Locale.US);
        private final SimpleDateFormat rfc850DateFmt = new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss 'GMT'", Locale.US);
        private final SimpleDateFormat headerdateformat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        private final SimpleDateFormat asciiDateFmt = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US);
        private static final TimeZone tz = TimeZone.getTimeZone("GMT");
        private static final int MAYBEVERSION = 1;
        private static final int INVERSION = 2;
        private static final int OLD_INNAME = 3;
        private static final int OLD_INVAL = 4;
        private static final int INVERSIONNUM = 5;
        private static final int RECOVER = 6;
        private static final int NEW_INNAME = 7;
        private static final int NEW_INVAL = 8;
        private static final int INPATH = 9;
        private static final int MAYBEINPATH = 10;
        private static final int INPATHVALUE = 11;
        private static final int MAYBEPORT = 12;
        private static final int INDOMAIN = 13;
        private static final int MAYBEDOMAIN = 14;
        private static final int INPORT = 15;
        private static final int INDOMAINVALUE = 16;
        private static final int INPORTVALUE = 17;

        public ServeConnection(Socket socket, Serve serve) {
            this.socket = socket;
            this.serve = serve;
            this.expdatefmt.setTimeZone(tz);
            this.headerdateformat.setTimeZone(tz);
            this.rfc850DateFmt.setTimeZone(tz);
            this.asciiDateFmt.setTimeZone(tz);
            if (serve.isAccessLogged()) {
                this.accessFmt = new MessageFormat((String)serve.arguments.get(Serve.ARG_ACCESS_LOG_FMT));
                this.logPlaceholders = new Object[12];
            }
            this.initSSLAttrs();
            try {
                this.in = new ServeInputStream(socket.getInputStream(), this);
                this.out = new ServeOutputStream(socket.getOutputStream(), this);
            }
            catch (IOException iOException) {
                this.close();
                return;
            }
            serve.threadPool.executeThread(this);
        }

        private void initSSLAttrs() {
            if (this.socket.getClass().getName().indexOf("SSLSocket") > 0) {
                try {
                    this.sslAttributes = new Hashtable();
                    Object object = this.socket.getClass().getMethod("getSession", Utils.EMPTY_CLASSES).invoke((Object)this.socket, Utils.EMPTY_OBJECTS);
                    if (object != null) {
                        this.sslAttributes.put("javax.net.ssl.session", object);
                        Method method = object.getClass().getMethod("getCipherSuite", Utils.EMPTY_CLASSES);
                        method.setAccessible(true);
                        this.sslAttributes.put("javax.net.ssl.cipher_suite", method.invoke(object, Utils.EMPTY_OBJECTS));
                        method = object.getClass().getMethod("getPeerCertificates", Utils.EMPTY_CLASSES);
                        method.setAccessible(true);
                        this.sslAttributes.put("javax.net.ssl.peer_certificates", method.invoke(object, Utils.EMPTY_OBJECTS));
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.sslAttributes = null;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.sslAttributes = null;
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        private void closeStreams() throws IOException {
            IOException iOException = null;
            try {
                if (this.pw != null) {
                    this.pw.flush();
                } else {
                    this.out.flush();
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            try {
                this.out.close();
            }
            catch (IOException iOException3) {
                iOException = iOException != null ? (IOException)iOException.initCause(iOException3) : iOException3;
            }
            try {
                this.in.close();
            }
            catch (IOException iOException4) {
                iOException = iOException != null ? (IOException)iOException.initCause(iOException4) : iOException4;
            }
            if (iOException != null) {
                throw iOException;
            }
        }

        private void restart() throws IOException {
            this.reqMethod = null;
            this.reqUriPathUn = null;
            this.reqUriPath = null;
            this.reqProtocol = null;
            this.charEncoding = null;
            this.remoteUser = null;
            this.authType = null;
            this.oneOne = false;
            this.reqMime = false;
            if (this.reqHeaderNames == null) {
                this.reqHeaderNames = new Vector();
            } else {
                this.reqHeaderNames.clear();
            }
            if (this.reqHeaderValues == null) {
                this.reqHeaderValues = new Vector();
            } else {
                this.reqHeaderValues.clear();
            }
            this.locale = null;
            this.uriLen = 0;
            this.outCookies = null;
            this.inCookies = null;
            this.sessionCookieValue = null;
            this.sessionUrlValue = null;
            this.sessionValue = null;
            this.reqSessionValue = null;
            this.reqQuery = null;
            this.pw = null;
            this.rout = null;
            this.formParameters = null;
            if (this.attributes == null) {
                this.attributes = new Hashtable();
            } else {
                this.attributes.clear();
            }
            if (this.sslAttributes != null) {
                this.attributes.putAll(this.sslAttributes);
            }
            this.resCode = -1;
            this.resMessage = null;
            this.resHeaderNames.clear();
            this.headersWritten = false;
            this.postCache = null;
            if (this.asyncMode != null) {
                this.serve.log("TJWS: debug", new Exception("Restarting without clean async mode"));
                this.asyncMode = null;
            }
            this.requestThread = Thread.currentThread();
            ((ServeInputStream)this.in).refresh();
            this.out = new ServeOutputStream(this.socket.getOutputStream(), this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block18: {
                if (this.socket == null) {
                    return;
                }
                try {
                    do {
                        this.restart();
                        this.parseRequest();
                        if (this.asyncMode != null) {
                            this.asyncTimeout = this.asyncMode.getTimeout();
                            if (this.asyncTimeout > 0L) {
                                this.asyncTimeout += System.currentTimeMillis();
                            }
                            return;
                        }
                        this.finalizerequest();
                    } while (this.keepAlive && this.serve.isKeepAlive() && this.timesRequested < this.serve.getMaxTimesConnectionUse());
                }
                catch (IOException iOException) {
                    if (iOException instanceof SocketTimeoutException) {
                        break block18;
                    }
                    String string = iOException.getMessage();
                    if (!(string != null && string.indexOf("ocket closed") >= 0 || iOException instanceof AsynchronousCloseException)) {
                        if (this.socket != null) {
                            this.serve.log("TJWS: IO error: " + iOException + " in processing a request from " + this.socket.getInetAddress() + ":" + this.socket.getLocalPort() + " / " + this.socket.getClass().getName());
                        } else {
                            this.serve.log("TJWS: IO error: " + iOException + "(socket NULL)");
                        }
                        break block18;
                    }
                    ServeConnection serveConnection = this;
                    synchronized (serveConnection) {
                        this.socket = null;
                    }
                }
                finally {
                    if (this.asyncMode == null) {
                        this.close();
                    }
                }
            }
        }

        final synchronized void close() {
            if (this.socket != null) {
                try {
                    this.socket.close();
                    this.socket = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parseRequest() throws IOException {
            Object object;
            String string;
            String string2;
            byte[] byArray = new byte[4096];
            this.lastWait = System.currentTimeMillis();
            this.socket.setSoTimeout(this.serve.timeoutKeepAlive);
            int n = this.in.readLine(byArray, 0, byArray.length);
            if (n == -1 || n == 0) {
                if (this.keepAlive) {
                    this.keepAlive = false;
                } else {
                    this.problem("Status-Code 400: Bad Request(empty)", 400);
                }
                return;
            }
            if (n >= byArray.length) {
                this.problem("Status-Code 414: Request-URI Too Long", 414);
                return;
            }
            String string3 = new String(byArray, 0, n, Serve.UTF8);
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            if (stringTokenizer.hasMoreTokens()) {
                this.reqMethod = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    this.reqUriPathUn = stringTokenizer.nextToken();
                    int n2 = this.reqUriPathUn.indexOf(SESSION_URL_NAME);
                    if (n2 > 0) {
                        this.sessionUrlValue = this.reqUriPathUn.substring(n2 + SESSION_URL_NAME.length());
                        this.reqUriPathUn = this.reqUriPathUn.substring(0, n2);
                        try {
                            this.serve.getSession(this.sessionUrlValue).userTouch();
                        }
                        catch (NullPointerException nullPointerException) {
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        this.reqProtocol = stringTokenizer.nextToken();
                        this.oneOne = !this.reqProtocol.toUpperCase().equals("HTTP/1.0");
                        this.reqMime = true;
                        while ((string2 = ((ServeInputStream)this.in).readLine(0xA00000)) != null && string2.length() != 0) {
                            int n3 = string2.indexOf(58, 0);
                            if (n3 > 0) {
                                string = string2.substring(0, n3).trim().toLowerCase();
                                object = string2.substring(n3 + 1).trim();
                                this.reqHeaderNames.addElement(string);
                                this.reqHeaderValues.addElement(object);
                                continue;
                            }
                            this.serve.log("TJWS: header field '" + string2 + "' without ':'");
                        }
                    } else {
                        this.reqProtocol = "HTTP/0.9";
                        this.oneOne = false;
                        this.reqMime = false;
                    }
                }
            }
            if (this.reqProtocol == null) {
                this.problem("Status-Code 400: Malformed request line:" + string3, 400);
                return;
            }
            if (this.oneOne) {
                String string4 = this.getHeader(HOST);
                if (string4 == null) {
                    this.problem("Status-Code 400: 'Host' header is missing in HTTP/1.1 request", 400);
                    return;
                }
                string4 = this.getHeader(CONNECTION);
                boolean bl = this.keepAlive = !"close".equalsIgnoreCase(string4);
                if (this.keepAlive) {
                    string4 = this.getHeader(KEEPALIVE);
                }
            } else {
                this.keepAlive = false;
            }
            int n4 = this.reqUriPathUn.indexOf(63);
            if (n4 > -1) {
                if (n4 < this.reqUriPathUn.length() - 1) {
                    this.reqQuery = this.reqUriPathUn.substring(n4 + 1);
                }
                this.reqUriPathUn = this.reqUriPathUn.substring(0, n4);
            }
            this.reqUriPath = Utils.decode(this.reqUriPathUn, Serve.UTF8);
            if (CHUNKED.equalsIgnoreCase(this.getHeader(TRANSFERENCODING))) {
                this.setHeader(CONTENTLENGTH, null);
                ((ServeInputStream)this.in).chunking(true);
            }
            this.setCharacterEncoding((string2 = this.extractEncodingFromContentType(this.getHeader(CONTENTTYPE))) != null ? string2 : Serve.UTF8);
            String string5 = this.getHeader(CONTENTLENGTH);
            if (string5 != null) {
                try {
                    ((ServeInputStream)this.in).setContentLength(Long.parseLong(string5));
                }
                catch (NumberFormatException numberFormatException) {
                    this.serve.log("TJWS: Invalid value of input content-length: " + string5);
                }
            }
            if (!((string = this.getHeader(CONTENT_ENCODING)) == null || (string.equalsIgnoreCase("gzip") || string.equalsIgnoreCase("compressed")) && null != this.serve.gzipInStreamConstr && ((ServeInputStream)this.in).compressed(true))) {
                this.problem("Status-Code 415: Unsupported media type:" + string, 415);
                return;
            }
            if (this.assureHeaders() && !this.socket.getKeepAlive()) {
                this.socket.setKeepAlive(true);
            }
            this.socket.setSoTimeout(0);
            this.serve.setHost(this.getHeader(HOST));
            object = (PathTreeDictionary)currentRegistry.get();
            this.lastRun = System.currentTimeMillis();
            try {
                Object[] objectArray = ((PathTreeDictionary)object).get(this.reqUriPath);
                if (objectArray[0] != null) {
                    this.uriLen = (Integer)objectArray[1];
                    this.runServlet((HttpServlet)objectArray[0]);
                } else {
                    this.problem("No any servlet found for serving " + this.reqUriPath, 400);
                }
            }
            finally {
                currentRegistry.set(null);
            }
        }

        private void finalizerequest() throws IOException {
            if (this.reqMethod != null && this.serve.isAccessLogged()) {
                this.logPlaceholders[0] = this.socket.getInetAddress();
                this.logPlaceholders[1] = "-";
                this.logPlaceholders[2] = this.remoteUser == null ? "-" : this.remoteUser;
                this.logPlaceholders[3] = new Date(this.lastRun);
                this.logPlaceholders[4] = this.reqMethod;
                this.logPlaceholders[5] = this.reqUriPathUn;
                this.logPlaceholders[6] = this.reqProtocol;
                this.logPlaceholders[7] = new Integer(this.resCode);
                this.logPlaceholders[8] = new Long(((ServeOutputStream)this.out).lengthWritten());
                this.logPlaceholders[9] = new Integer(this.socket.getLocalPort());
                this.logPlaceholders[10] = this.serve.isShowReferer() ? this.getHeader("Referer") : "-";
                this.logPlaceholders[11] = this.serve.isShowUserAgent() ? this.getHeader("User-Agent") : "-";
                this.serve.logStream.println(this.accessFmt.format(this.logPlaceholders));
            }
            this.lastRun = 0L;
            ++this.timesRequested;
            this.closeStreams();
        }

        private boolean assureHeaders() {
            if (this.reqMime) {
                this.setHeader("MIME-Version", "1.0");
            }
            this.setDateHeader("Date", System.currentTimeMillis());
            this.setHeader("Server", "D. Rogatkin's TJWS with Android support (aka Acme.Serve)/Version 1.105, $Revision: 1.267 $");
            if (this.keepAlive && this.serve.isKeepAlive()) {
                if (this.reqMime) {
                    this.setHeader(CONNECTION, KEEPALIVE);
                    if (this.oneOne) {
                        this.setHeader(KEEPALIVE, this.serve.getKeepAliveParamStr());
                    }
                }
                return true;
            }
            this.setHeader(CONNECTION, "close");
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runServlet(HttpServlet httpServlet) throws IOException {
            block17: {
                this.setStatus(200);
                try {
                    this.parseCookies();
                    if (this.reqSessionValue == null) {
                        this.reqSessionValue = this.sessionUrlValue;
                    }
                    this.sessionValue = this.reqSessionValue;
                    if (!this.authenificate()) break block17;
                    if (httpServlet instanceof SingleThreadModel) {
                        HttpServlet httpServlet2 = httpServlet;
                        synchronized (httpServlet2) {
                            httpServlet.service((ServletRequest)this, (ServletResponse)this);
                            break block17;
                        }
                    }
                    httpServlet.service((ServletRequest)this, (ServletResponse)this);
                }
                catch (UnavailableException unavailableException) {
                    if (unavailableException.isPermanent()) {
                        this.serve.unloadServlet((Servlet)httpServlet);
                        httpServlet.destroy();
                    } else if (unavailableException.getUnavailableSeconds() > 0) {
                        this.serve.log("TJWS: Temporary unavailability feature is not supported " + httpServlet);
                    }
                    this.problem(unavailableException.getMessage(), 503);
                }
                catch (ServletException servletException) {
                    this.serve.log("TJWS: Servlet exception", servletException);
                    Throwable throwable = servletException.getRootCause();
                    while (throwable != null) {
                        this.serve.log("Caused by", throwable);
                        if (throwable instanceof ServletException) {
                            throwable = ((ServletException)throwable).getRootCause();
                            continue;
                        }
                        throwable = throwable.getCause();
                    }
                    this.problem(servletException.toString(), 500);
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    this.serve.log("TJWS: Unexpected problem running servlet", exception);
                    this.problem("Unexpected problem running servlet: " + exception.toString(), 500);
                }
            }
        }

        private boolean authenificate() throws IOException {
            Object[] objectArray = this.serve.realms.get(this.reqUriPath);
            BasicAuthRealm basicAuthRealm = null;
            if (objectArray != null) {
                basicAuthRealm = (BasicAuthRealm)objectArray[0];
            }
            if (basicAuthRealm == null) {
                return true;
            }
            String string = this.getHeader("Authorization");
            if (string != null) {
                string = Utils.base64Decode(string.substring(string.indexOf(32) + 1), this.getCharacterEncoding());
                int n = string.indexOf(58);
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                this.remoteUser = string2;
                this.authType = "BASIC";
                String string4 = (String)basicAuthRealm.get(string2);
                if (string4 != null && string4.equals(string3)) {
                    return true;
                }
            }
            this.setStatus(401);
            this.setHeader("WWW-Authenticate", "basic realm=\"" + basicAuthRealm.name() + '\"');
            this.realSendError();
            return false;
        }

        private void problem(String string, int n) {
            this.serve.log("TJWS: " + string);
            try {
                this.sendError(n, string);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void setInInclude(boolean bl) {
            ((ServeOutputStream)this.out).setInInclude(bl);
        }

        public void spawnAsync(AsyncCallback asyncCallback) {
            this.asyncMode = asyncCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void joinAsync() {
            block10: {
                ServeConnection serveConnection = this;
                synchronized (serveConnection) {
                    if (this.asyncMode == null) {
                        return;
                    }
                    this.asyncMode = null;
                }
                if (this.requestThread == Thread.currentThread()) {
                    return;
                }
                try {
                    this.finalizerequest();
                    if (this.keepAlive && this.serve.isKeepAlive() && this.timesRequested < this.serve.getMaxTimesConnectionUse()) {
                        this.serve.threadPool.executeThread(this);
                        break block10;
                    }
                    this.close();
                }
                catch (IOException iOException) {
                    this.serve.log("TJWS: " + iOException);
                }
            }
        }

        private void parseCookies() throws IOException {
            String string;
            if (this.inCookies == null) {
                this.inCookies = new Vector();
            }
            if ((string = this.getHeader(COOKIE)) == null) {
                return;
            }
            try {
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                if (string.length() > 1228800) {
                    throw new IOException("Cookie string too long:" + string.length());
                }
                char[] cArray = string.toCharArray();
                int n = 1;
                StringBuffer stringBuffer = new StringBuffer(256);
                boolean bl = false;
                block22: for (int i = 0; i < cArray.length; ++i) {
                    char c = cArray[i];
                    switch (n) {
                        case 1: {
                            if (c == ' ') continue block22;
                            stringBuffer.append(c);
                            if (c == '$') {
                                n = 2;
                                continue block22;
                            }
                            n = 3;
                            continue block22;
                        }
                        case 3: {
                            if (c == '=') {
                                n = 4;
                                string2 = stringBuffer.toString();
                                stringBuffer.setLength(0);
                                continue block22;
                            }
                            if (c == ' ' && stringBuffer.length() <= 0) continue block22;
                            stringBuffer.append(c);
                            continue block22;
                        }
                        case 4: {
                            if (!bl) {
                                if (c == ';') {
                                    n = 3;
                                    string3 = stringBuffer.toString();
                                    stringBuffer.setLength(0);
                                    this.addCookie(string2, string3, null, null);
                                    continue block22;
                                }
                                if (c == '\"' && stringBuffer.length() == 0) {
                                    bl = true;
                                    continue block22;
                                }
                                stringBuffer.append(c);
                                continue block22;
                            }
                            if (c == '\"') {
                                bl = false;
                                continue block22;
                            }
                            stringBuffer.append(c);
                            continue block22;
                        }
                        case 2: {
                            if (c == '=') {
                                if ("$Version".equals(stringBuffer.toString())) {
                                    n = 5;
                                } else {
                                    n = 4;
                                    string2 = stringBuffer.toString();
                                }
                                stringBuffer.setLength(0);
                                continue block22;
                            }
                            stringBuffer.append(c);
                            continue block22;
                        }
                        case 5: {
                            if (c == ',' || c == ';') {
                                stringBuffer.setLength(0);
                                n = 7;
                                continue block22;
                            }
                            if (!Character.isDigit(c)) {
                                n = 6;
                                continue block22;
                            }
                            stringBuffer.append(c);
                            continue block22;
                        }
                        case 7: {
                            if (c == '=') {
                                n = 8;
                                string2 = stringBuffer.toString();
                                stringBuffer.setLength(0);
                                continue block22;
                            }
                            if (c == ' ' && stringBuffer.length() <= 0) continue block22;
                            stringBuffer.append(c);
                            continue block22;
                        }
                        case 8: {
                            if (c == ';') {
                                n = 10;
                                string3 = stringBuffer.toString();
                                stringBuffer.setLength(0);
                                string4 = null;
                                continue block22;
                            }
                            if (c == ',') {
                                n = 7;
                                string3 = stringBuffer.toString();
                                stringBuffer.setLength(0);
                                this.addCookie(string2, string3, null, null);
                                continue block22;
                            }
                            stringBuffer.append(c);
                            continue block22;
                        }
                        case 10: {
                            if (c == ' ') continue block22;
                            stringBuffer.append(c);
                            if (c == '$') {
                                n = 9;
                                continue block22;
                            }
                            this.addCookie(string2, string3, null, null);
                            n = 7;
                            continue block22;
                        }
                        case 9: {
                            if (c == '=') {
                                if ("$Path".equals(stringBuffer.toString())) {
                                    n = 11;
                                } else {
                                    this.addCookie(string2, string3, null, null);
                                    n = 8;
                                    string2 = stringBuffer.toString();
                                }
                                stringBuffer.setLength(0);
                                continue block22;
                            }
                            stringBuffer.append(c);
                            continue block22;
                        }
                        case 11: {
                            if (c == ',') {
                                string4 = stringBuffer.toString();
                                n = 7;
                                this.addCookie(string2, string3, string4, null);
                                stringBuffer.setLength(0);
                                continue block22;
                            }
                            if (c == ';') {
                                n = 14;
                                string4 = stringBuffer.toString();
                                stringBuffer.setLength(0);
                                continue block22;
                            }
                            stringBuffer.append(c);
                            continue block22;
                        }
                        case 14: {
                            if (c == ' ') continue block22;
                            stringBuffer.append(c);
                            if (c == '$') {
                                n = 13;
                                continue block22;
                            }
                            this.addCookie(string2, string3, string4, null);
                            n = 7;
                            continue block22;
                        }
                        case 13: {
                            if (c != '=') continue block22;
                            if ("$Domain".equals(stringBuffer.toString())) {
                                n = 16;
                            } else {
                                this.addCookie(string2, string3, string4, null);
                                n = 8;
                                string2 = stringBuffer.toString();
                            }
                            stringBuffer.setLength(0);
                            continue block22;
                        }
                        case 16: {
                            if (c == ',') {
                                n = 7;
                                this.addCookie(string2, string3, string4, stringBuffer.toString());
                                stringBuffer.setLength(0);
                                continue block22;
                            }
                            if (c == ';') {
                                string5 = stringBuffer.toString();
                                n = 12;
                                continue block22;
                            }
                            stringBuffer.append(c);
                            continue block22;
                        }
                        case 12: {
                            if (c == ' ') continue block22;
                            stringBuffer.append(c);
                            if (c == '$') {
                                n = 15;
                                continue block22;
                            }
                            this.addCookie(string2, string3, string4, string5);
                            n = 7;
                            continue block22;
                        }
                        case 15: {
                            if (c != '=') continue block22;
                            if ("$Port".equals(stringBuffer.toString())) {
                                n = 17;
                            } else {
                                this.addCookie(string2, string3, string4, string5);
                                n = 8;
                                string2 = stringBuffer.toString();
                            }
                            stringBuffer.setLength(0);
                            continue block22;
                        }
                        case 17: {
                            if (c == ',' || c == ';') {
                                int n2 = Integer.parseInt(stringBuffer.toString());
                                n = 7;
                                this.addCookie(string2, string3, string4, string5);
                                stringBuffer.setLength(0);
                                continue block22;
                            }
                            if (!Character.isDigit(c)) {
                                n = 6;
                                continue block22;
                            }
                            stringBuffer.append(c);
                            continue block22;
                        }
                        case 6: {
                            this.serve.log("TJWS: Parsing recover of cookie string " + string, null);
                            if (c != ';' && c != ',') continue block22;
                            stringBuffer.setLength(0);
                            n = 7;
                        }
                    }
                }
                if (n == 4 || n == 8) {
                    string3 = stringBuffer.toString();
                    this.addCookie(string2, string3, null, null);
                } else if (n == 11) {
                    this.addCookie(string2, string3, stringBuffer.toString(), null);
                } else if (n == 16) {
                    this.addCookie(string2, string3, string4, stringBuffer.toString());
                } else if (n == 17) {
                    this.addCookie(string2, string3, string4, string5);
                }
            }
            catch (Error error) {
                this.serve.log("TJWS: Error in parsing cookies: " + string, error);
            }
            catch (Exception exception) {
                this.serve.log("TJWS: An exception in parsing cookies: " + string, exception);
            }
        }

        private void addCookie(String string, String string2, String string3, String string4) {
            if (SESSION_COOKIE_NAME.equals(string) && this.sessionCookieValue == null) {
                this.sessionCookieValue = string2;
                try {
                    this.serve.getSession(this.sessionCookieValue).userTouch();
                    this.reqSessionValue = this.sessionCookieValue;
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (NullPointerException nullPointerException) {}
            } else {
                Cookie cookie = new Cookie(string, string2);
                this.inCookies.addElement(cookie);
                if (string3 != null) {
                    cookie.setPath(string3);
                    if (string4 != null) {
                        cookie.setDomain(string4);
                    }
                }
            }
        }

        public int getContentLength() {
            return this.getIntHeader(CONTENTLENGTH);
        }

        public String getContentType() {
            return this.getHeader(CONTENTTYPE);
        }

        public String getProtocol() {
            return this.reqProtocol;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getScheme() {
            if (this.scheme == null) {
                ServeConnection serveConnection = this;
                synchronized (serveConnection) {
                    if (this.scheme == null) {
                        this.scheme = this.socket.getClass().getName().indexOf("SSLSocket") > 0 || this.serve.proxySSL ? "https" : "http";
                    }
                }
            }
            return this.scheme;
        }

        public String getServerName() {
            int n;
            String string = this.getHeader(HOST);
            if (string != null && string.length() > 0 && (n = string.lastIndexOf(58)) >= 0 && n < string.length()) {
                string = string.substring(0, n);
            }
            if (string == null) {
                if (this.serve.proxyConfig) {
                    string = this.getHeader(FORWARDED_SERVER);
                }
                if (string == null) {
                    try {
                        string = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException unknownHostException) {
                        string = "localhost";
                    }
                }
            }
            if ((n = string.indexOf("/")) >= 0) {
                string = string.substring(n + 1);
            }
            return string;
        }

        public int getServerPort() {
            String string = this.getHeader(HOST);
            if (string != null && string.length() > 0) {
                int n = string.indexOf(58);
                if (n >= 0) {
                    try {
                        return Integer.parseInt(string.substring(n + 1).trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                } else {
                    if ("https".equals(this.getScheme())) {
                        return 443;
                    }
                    return 80;
                }
            }
            return this.socket.getLocalPort();
        }

        public String getRemoteAddr() {
            if (this.serve.proxyConfig && this.getHeader(FORWARDED_FOR) != null) {
                return this.getHeader(FORWARDED_FOR);
            }
            return this.socket.getInetAddress().getHostAddress();
        }

        public String getRemoteHost() {
            if (this.serve.proxyConfig && this.getHeader(FORWARDED_FOR) != null) {
                return this.getHeader(FORWARDED_FOR);
            }
            String string = this.socket.getInetAddress().getHostName();
            return string != null ? string : this.getRemoteAddr();
        }

        public String getRealPath(String string) {
            return this.serve.getRealPath(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServletInputStream getInputStream() throws IOException {
            ServletInputStream servletInputStream = this.in;
            synchronized (servletInputStream) {
                if (((ServeInputStream)this.in).isReturnedAsReader()) {
                    throw new IllegalStateException("Already returned as a reader.");
                }
                ((ServeInputStream)this.in).setReturnedAsStream(true);
            }
            return this.in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedReader getReader() {
            ServletInputStream servletInputStream = this.in;
            synchronized (servletInputStream) {
                if (((ServeInputStream)this.in).isReturnedAsStream()) {
                    throw new IllegalStateException("Already returned as a stream.");
                }
                ((ServeInputStream)this.in).setReturnedAsReader(true);
            }
            if (this.charEncoding != null) {
                try {
                    return new BufferedReader(new InputStreamReader((InputStream)this.in, this.charEncoding));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            return new BufferedReader(new InputStreamReader((InputStream)this.in));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map assureParametersFromRequest() {
            Hashtable hashtable = this.resHeaderNames;
            synchronized (hashtable) {
                if (this.formParameters == null) {
                    if ("GET".equals(this.reqMethod) || "HEAD".equals(this.reqMethod)) {
                        if (this.reqQuery != null) {
                            try {
                                this.formParameters = Utils.parseQueryString(this.reqQuery, this.charEncoding);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                this.serve.log("TJWS: Exception " + illegalArgumentException + " at parsing 'get|head' data " + this.reqQuery);
                            }
                        }
                    } else if ("POST".equals(this.reqMethod)) {
                        String string = this.getContentType();
                        if (string != null && WWWFORMURLENCODE.regionMatches(true, 0, string, 0, WWWFORMURLENCODE.length())) {
                            if (this.postCache == null) {
                                this.postCache = new String[1];
                                ServletInputStream servletInputStream = null;
                                try {
                                    servletInputStream = this.getInputStream();
                                    this.formParameters = Utils.parsePostData(this.getContentLength(), (InputStream)servletInputStream, this.charEncoding, this.postCache);
                                }
                                catch (Exception exception) {
                                    this.serve.log("TJWS: Exception " + exception + " at parsing 'POST' data of length " + this.getContentLength());
                                    this.formParameters = EMPTYHASHTABLE;
                                }
                            } else {
                                this.formParameters = Utils.parseQueryString(this.postCache[0], this.charEncoding);
                            }
                            if (this.reqQuery != null && this.reqQuery.length() > 0) {
                                this.formParameters.putAll(Utils.parseQueryString(this.reqQuery, this.charEncoding));
                            }
                        } else if (this.reqQuery != null) {
                            this.formParameters = Utils.parseQueryString(this.reqQuery, this.charEncoding);
                        }
                    } else {
                        throw new IllegalArgumentException("Request parameters are not supported for method:" + this.reqMethod);
                    }
                }
            }
            if (this.formParameters == null) {
                this.formParameters = EMPTYHASHTABLE;
            }
            return this.formParameters;
        }

        public Enumeration getParameterNames() {
            this.assureParametersFromRequest();
            return ((Hashtable)this.formParameters).keys();
        }

        public String getParameter(String string) {
            String[] stringArray = this.getParameterValues(string);
            if (stringArray == null || stringArray.length == 0) {
                return null;
            }
            return stringArray[0];
        }

        public String[] getParameterValues(String string) {
            this.assureParametersFromRequest();
            return (String[])this.formParameters.get(string);
        }

        public Object getAttribute(String string) {
            return this.attributes.get(string);
        }

        public Cookie[] getCookies() {
            Object[] objectArray = new Cookie[this.inCookies.size()];
            this.inCookies.copyInto(objectArray);
            return objectArray;
        }

        public String getMethod() {
            return this.reqMethod;
        }

        public String getRequestURI() {
            return this.reqUriPathUn;
        }

        public StringBuffer getRequestURL() {
            int n = this.getServerPort();
            return new StringBuffer().append(this.getScheme()).append("://").append(this.getServerName()).append("https".equals(this.getScheme()) && n == 443 || n == 80 ? "" : ":" + String.valueOf(n)).append(this.getRequestURI());
        }

        public String getServletPath() {
            return this.uriLen > 0 ? this.reqUriPath.substring(0, this.uriLen) : "";
        }

        public String getPathInfo() {
            return this.uriLen >= this.reqUriPath.length() ? null : this.reqUriPath.substring(this.uriLen);
        }

        public String getPathTranslated() {
            return this.getRealPath(this.getPathInfo());
        }

        public String getQueryString() {
            return this.reqQuery;
        }

        public String getRemoteUser() {
            return this.remoteUser;
        }

        public String getAuthType() {
            return this.authType;
        }

        public String getHeader(String string) {
            string = string.toLowerCase();
            int n = -1;
            if (this.serve.proxyConfig && HOST.equals(string)) {
                n = this.reqHeaderNames.indexOf(FORWARDED_HOST);
            }
            if (n < 0) {
                n = this.reqHeaderNames.indexOf(string);
            }
            if (n < 0) {
                return null;
            }
            return (String)this.reqHeaderValues.elementAt(n);
        }

        public int getIntHeader(String string) {
            String string2 = this.getHeader(string);
            if (string2 == null) {
                return -1;
            }
            return Integer.parseInt(string2);
        }

        public long getDateHeader(String string) {
            String string2 = this.getHeader(string);
            if (string2 == null) {
                return -1L;
            }
            try {
                return this.headerdateformat.parse(string2).getTime();
            }
            catch (ParseException parseException) {
                try {
                    return this.rfc850DateFmt.parse(string2).getTime();
                }
                catch (ParseException parseException2) {
                    try {
                        return this.asciiDateFmt.parse(string2).getTime();
                    }
                    catch (ParseException parseException3) {
                        throw new IllegalArgumentException("Value " + string2 + " can't be converted to Date using any of formats: [" + this.headerdateformat.toPattern() + "][ " + this.rfc850DateFmt.toPattern() + "][" + this.asciiDateFmt.toPattern());
                    }
                }
            }
        }

        public Enumeration getHeaderNames() {
            return this.reqHeaderNames.elements();
        }

        public synchronized HttpSession getSession(boolean bl) {
            AcmeSession acmeSession = null;
            if (this.sessionValue != null && (acmeSession = this.serve.getSession(this.sessionValue)) != null && !acmeSession.isValid()) {
                this.serve.removeSession(this.sessionValue);
                acmeSession = null;
            }
            if (acmeSession == null && bl) {
                acmeSession = this.serve.createSession();
                if (acmeSession != null) {
                    this.sessionValue = acmeSession.getId();
                } else {
                    throw new RuntimeException("A session can't be created");
                }
            }
            return acmeSession;
        }

        public HttpSession getSession() {
            return this.getSession(true);
        }

        public boolean isRequestedSessionIdFromURL() {
            return this.isRequestedSessionIdFromUrl();
        }

        public Enumeration getAttributeNames() {
            return this.attributes.keys();
        }

        public void setAttribute(String string, Object object) {
            if (object != null) {
                this.attributes.put(string, object);
            } else {
                this.attributes.remove(string);
            }
        }

        public String getRequestedSessionId() {
            return this.reqSessionValue;
        }

        public boolean isRequestedSessionIdValid() {
            if (this.reqSessionValue != null) {
                AcmeSession acmeSession = this.serve.getSession(this.reqSessionValue);
                return acmeSession != null && acmeSession.isValid();
            }
            return false;
        }

        public boolean isRequestedSessionIdFromCookie() {
            return this.sessionCookieValue != null;
        }

        public boolean isRequestedSessionIdFromUrl() {
            return this.sessionUrlValue != null && this.sessionCookieValue == null;
        }

        public void setContentLength(int n) {
            if (n >= 0) {
                this.setIntHeader(CONTENTLENGTH, n);
            } else {
                this.setHeader(CONTENTLENGTH, null);
            }
        }

        public void setContentType(String string) {
            this.setHeader(CONTENTTYPE, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServletOutputStream getOutputStream() {
            ServletOutputStream servletOutputStream = this.out;
            synchronized (servletOutputStream) {
                if (this.rout == null) {
                    if (this.pw != null) {
                        throw new IllegalStateException("Already returned as a writer");
                    }
                    this.rout = this.out;
                }
            }
            return this.rout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PrintWriter getWriter() throws IOException {
            ServletOutputStream servletOutputStream = this.out;
            synchronized (servletOutputStream) {
                if (this.pw == null) {
                    if (this.rout != null) {
                        throw new IllegalStateException("Already was returned as servlet output stream");
                    }
                    String string = this.getCharacterEncoding();
                    this.pw = string != null ? new PrintWriter(new OutputStreamWriter((OutputStream)this.out, string)) : new PrintWriter((OutputStream)this.out);
                }
            }
            return this.pw;
        }

        public String getCharacterEncoding() {
            String string;
            String string2 = (String)this.resHeaderNames.get(CONTENTTYPE.toLowerCase());
            if (string2 != null && (string = this.extractEncodingFromContentType(string2)) != null) {
                return string;
            }
            return this.charEncoding;
        }

        private String extractEncodingFromContentType(String string) {
            if (string == null) {
                return null;
            }
            int n = string.indexOf(59);
            if (n > 0 && (n = string.toLowerCase().indexOf("charset=", n)) >= 0) {
                int n2;
                if ((n = (string = string.substring(n + "charset=".length()).trim()).indexOf(59)) > 0) {
                    string = string.substring(0, n);
                }
                if ((n2 = string.length()) > 2 && string.charAt(0) == '\"') {
                    return string.substring(1, n2 - 1);
                }
                return string;
            }
            return null;
        }

        public void flushBuffer() throws IOException {
            ((ServeOutputStream)this.out).flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetBuffer() {
            ((ServeOutputStream)this.out).reset();
            ServeConnection serveConnection = this;
            synchronized (serveConnection) {
                this.headersWritten = false;
            }
        }

        public int getBufferSize() {
            return ((ServeOutputStream)this.out).getBufferSize();
        }

        public void setBufferSize(int n) {
            ((ServeOutputStream)this.out).setBufferSize(n);
        }

        public boolean isCommitted() {
            return this.headersWritten && ((ServeOutputStream)this.out).lengthWritten() > 0L;
        }

        public void reset() throws IllegalStateException {
            if (!this.isCommitted()) {
                if (this.outCookies != null) {
                    this.outCookies.clear();
                }
            } else {
                throw new IllegalStateException("Header have already been committed.");
            }
            this.resHeaderNames.clear();
            this.pw = null;
            this.rout = null;
            ((ServeOutputStream)this.out).reset();
            this.assureHeaders();
        }

        public void setLocale(Locale locale) {
            this.locale = locale;
        }

        public Locale getLocale() {
            if (this.locale != null) {
                return this.locale;
            }
            Enumeration enumeration = this.getLocales();
            if (enumeration.hasMoreElements()) {
                return (Locale)enumeration.nextElement();
            }
            return Locale.getDefault();
        }

        public Enumeration getLocales() {
            String string = this.getHeader(ACCEPT_LANGUAGE);
            TreeSet<LocaleWithWeight> treeSet = new TreeSet<LocaleWithWeight>();
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
                try {
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken(";");
                        String string3 = stringTokenizer.nextToken(";=");
                        string3 = stringTokenizer.nextToken("=,");
                        float f = 0.0f;
                        try {
                            f = Float.valueOf(string3).floatValue();
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (!(f > 0.0f)) continue;
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ", ", false);
                        while (stringTokenizer2.hasMoreTokens()) {
                            String string4 = stringTokenizer2.nextToken();
                            int n = string4.indexOf(45);
                            if (n < 0) {
                                treeSet.add(new LocaleWithWeight(new Locale(string4.trim()), f));
                                continue;
                            }
                            treeSet.add(new LocaleWithWeight(new Locale(string4.substring(0, n), string4.substring(n + 1).trim().toUpperCase()), f));
                        }
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            if (treeSet.size() == 0) {
                treeSet.add(new LocaleWithWeight(Locale.getDefault(), 1.0f));
            }
            return new AcceptLocaleEnumeration(treeSet);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCharacterEncoding(String string) {
            this.charEncoding = string;
            ServeConnection serveConnection = this;
            synchronized (serveConnection) {
                this.formParameters = null;
            }
        }

        public void addDateHeader(String string, long l) {
            this.addHeader(string, this.headerdateformat.format(new Date(l)));
        }

        public void addHeader(String string, String string2) {
            Object v = this.resHeaderNames.get(string = string.trim().toLowerCase());
            if (v == null) {
                this.setHeader(string, string2);
            } else if (v instanceof String[]) {
                String[] stringArray = (String[])v;
                String[] stringArray2 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                stringArray2[stringArray.length] = string2;
                this.resHeaderNames.put(string, stringArray2);
            } else if (v instanceof String) {
                String[] stringArray = new String[]{(String)v, string2};
                this.resHeaderNames.put(string, stringArray);
            } else {
                throw new RuntimeException("Invalid content of header hash - " + v.getClass().getName());
            }
        }

        public void addIntHeader(String string, int n) {
            this.addHeader(string, Integer.toString(n));
        }

        public RequestDispatcher getRequestDispatcher(String string) {
            if (string.length() > 0 && string.charAt(0) != '/') {
                String string2 = this.getContextPath();
                String string3 = this.getPathInfo();
                String string4 = this.getServletPath();
                if (string3 != null) {
                    string2 = string2 + string4;
                    int n = string3.indexOf(47, 1);
                    if (n > 0) {
                        string2 = string2 + string3.substring(0, n - 1);
                    }
                } else {
                    int n = string4.lastIndexOf(47);
                    if (n >= 0) {
                        string2 = string2 + string4.substring(0, n);
                    }
                }
                string = string2 + '/' + string;
            }
            return this.serve.getRequestDispatcher(string);
        }

        public boolean isSecure() {
            return "https".equals(this.getScheme());
        }

        public void removeAttribute(String string) {
            this.attributes.remove(string);
        }

        public String getContextPath() {
            return "";
        }

        public Enumeration getHeaders(String string) {
            Vector vector = new Vector();
            int n = -1;
            while ((n = this.reqHeaderNames.indexOf(string.toLowerCase(), n + 1)) >= 0) {
                vector.addElement(this.reqHeaderValues.elementAt(n));
            }
            return vector.elements();
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public boolean isUserInRole(String string) {
            return false;
        }

        public Map getParameterMap() {
            this.assureParametersFromRequest();
            return this.formParameters;
        }

        public void addCookie(Cookie cookie) {
            if (this.outCookies == null) {
                this.outCookies = new Vector();
            }
            this.outCookies.addElement(cookie);
        }

        public boolean containsHeader(String string) {
            return this.resHeaderNames.contains(string);
        }

        public String encodeURL(String string) {
            int n = string.indexOf(SESSION_URL_NAME);
            if (n > 0) {
                string = string.substring(0, n);
            }
            if (this.sessionValue == null || this.isRequestedSessionIdFromCookie()) {
                return string;
            }
            try {
                new URL(string);
                int n2 = string.indexOf(47);
                if (n2 < 0) {
                    n2 = string.indexOf(63);
                }
                if (n2 < 0) {
                    n2 = string.indexOf(35);
                }
                if (n2 < 0) {
                    n2 = string.length();
                }
                if (!string.regionMatches(true, 0, this.getRequestURL().toString(), 0, n2)) {
                    return string;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            return string + SESSION_URL_NAME + this.sessionValue;
        }

        public String encodeRedirectURL(String string) {
            return this.encodeURL(string);
        }

        public int getRemotePort() {
            return this.getServerPort();
        }

        public String getLocalName() {
            InetAddress inetAddress = this.socket.getLocalAddress();
            return inetAddress == null ? null : inetAddress.getCanonicalHostName();
        }

        public String getLocalAddr() {
            InetAddress inetAddress = this.socket.getLocalAddress();
            return inetAddress == null ? null : inetAddress.getHostAddress();
        }

        public int getLocalPort() {
            return this.socket.getLocalPort();
        }

        public void setStatus(int n, String string) {
            this.resCode = n;
            this.resMessage = string;
        }

        public void setStatus(int n) {
            switch (n) {
                case 100: {
                    this.setStatus(n, "Continue");
                    break;
                }
                case 101: {
                    this.setStatus(n, "Switching protocols");
                    break;
                }
                case 200: {
                    this.setStatus(n, "Ok");
                    break;
                }
                case 201: {
                    this.setStatus(n, "Created");
                    break;
                }
                case 202: {
                    this.setStatus(n, "Accepted");
                    break;
                }
                case 203: {
                    this.setStatus(n, "Non-authoritative");
                    break;
                }
                case 204: {
                    this.setStatus(n, "No content");
                    break;
                }
                case 205: {
                    this.setStatus(n, "Reset content");
                    break;
                }
                case 206: {
                    this.setStatus(n, "Partial content");
                    break;
                }
                case 300: {
                    this.setStatus(n, "Multiple choices");
                    break;
                }
                case 301: {
                    this.setStatus(n, "Moved permanentently");
                    break;
                }
                case 302: {
                    this.setStatus(n, "Moved temporarily");
                    break;
                }
                case 303: {
                    this.setStatus(n, "See other");
                    break;
                }
                case 304: {
                    this.setStatus(n, "Not modified");
                    break;
                }
                case 305: {
                    this.setStatus(n, "Use proxy");
                    break;
                }
                case 400: {
                    this.setStatus(n, "Bad request");
                    break;
                }
                case 401: {
                    this.setStatus(n, "Unauthorized");
                    break;
                }
                case 402: {
                    this.setStatus(n, "Payment required");
                    break;
                }
                case 403: {
                    this.setStatus(n, "Forbidden");
                    break;
                }
                case 404: {
                    this.setStatus(n, "Not found");
                    break;
                }
                case 405: {
                    this.setStatus(n, "Method not allowed");
                    break;
                }
                case 406: {
                    this.setStatus(n, "Not acceptable");
                    break;
                }
                case 407: {
                    this.setStatus(n, "Proxy auth required");
                    break;
                }
                case 408: {
                    this.setStatus(n, "Request timeout");
                    break;
                }
                case 409: {
                    this.setStatus(n, "Conflict");
                    break;
                }
                case 410: {
                    this.setStatus(n, "Gone");
                    break;
                }
                case 411: {
                    this.setStatus(n, "Length required");
                    break;
                }
                case 412: {
                    this.setStatus(n, "Precondition failed");
                    break;
                }
                case 413: {
                    this.setStatus(n, "Request entity too large");
                    break;
                }
                case 414: {
                    this.setStatus(n, "Request URI too long");
                    break;
                }
                case 415: {
                    this.setStatus(n, "Unsupported media type");
                    break;
                }
                case 500: {
                    this.setStatus(n, "Internal server error");
                    break;
                }
                case 501: {
                    this.setStatus(n, "Not implemented");
                    break;
                }
                case 502: {
                    this.setStatus(n, "Bad gateway");
                    break;
                }
                case 503: {
                    this.setStatus(n, "Service unavailable");
                    break;
                }
                case 504: {
                    this.setStatus(n, "Gateway timeout");
                    break;
                }
                case 505: {
                    this.setStatus(n, "HTTP version not supported");
                    break;
                }
                case 207: {
                    this.setStatus(n, "Multi Status");
                    break;
                }
                default: {
                    this.setStatus(n, "");
                }
            }
        }

        public void setHeader(String string, String string2) {
            string = string.trim().toLowerCase();
            if (string2 == null) {
                this.resHeaderNames.remove(string);
            } else {
                this.resHeaderNames.put(string, string2);
            }
        }

        public void setIntHeader(String string, int n) {
            this.setHeader(string, Integer.toString(n));
        }

        public void setLongHeader(String string, long l) {
            this.setHeader(string, Long.toString(l));
        }

        public void setDateHeader(String string, long l) {
            this.setHeader(string, this.headerdateformat.format(new Date(l)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeHeaders() throws IOException {
            ServeConnection serveConnection = this;
            synchronized (serveConnection) {
                if (this.headersWritten) {
                    return;
                }
                this.headersWritten = true;
            }
            if (this.reqMime) {
                Object v;
                AcmeSession acmeSession;
                Object object;
                StringBuffer stringBuffer;
                CharSequence charSequence;
                boolean bl = false;
                long l = -1L;
                if (this.resMessage.length() < 256) {
                    this.out.println(this.reqProtocol + " " + this.resCode + " " + this.resMessage.replace('\r', '/').replace('\n', '/'));
                } else {
                    this.out.println(this.reqProtocol + " " + this.resCode + " " + this.resMessage.substring(0, 255).replace('\r', '/').replace('\n', '/'));
                }
                Enumeration enumeration = this.resHeaderNames.keys();
                while (enumeration.hasMoreElements()) {
                    int n;
                    charSequence = (String)enumeration.nextElement();
                    if (CONNECTION.equals(charSequence) || KEEPALIVE.equals(charSequence)) continue;
                    stringBuffer = (StringBuffer)this.resHeaderNames.get(charSequence);
                    if (stringBuffer instanceof String) {
                        object = (String[])stringBuffer;
                        if (object == null) continue;
                        if (CONTENTTYPE.equals(charSequence) && this.charEncoding != null && ((String)object).startsWith("text/")) {
                            n = ((String)object).indexOf(59);
                            if (n > 0) {
                                object = ((String)object).substring(0, n);
                            }
                            object = (String)object + "; charset=" + this.charEncoding;
                        }
                        this.out.println((String)charSequence + ": " + (String)object);
                        if (l < 0L && CONTENTLENGTH.equals(charSequence)) {
                            try {
                                l = Long.parseLong((String)object);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (bl || !TRANSFERENCODING.equals(charSequence) || !CHUNKED.equals(object)) continue;
                        bl = true;
                        continue;
                    }
                    if (!(stringBuffer instanceof String[])) continue;
                    object = (String[])stringBuffer;
                    this.out.print((String)charSequence + ": " + (String)object[0]);
                    for (n = 1; n < ((Object)object).length; ++n) {
                        this.out.print("," + (String)object[n]);
                    }
                    this.out.println();
                }
                charSequence = null;
                stringBuffer = null;
                object = null;
                if (this.sessionValue != null && (acmeSession = this.serve.getSession(this.sessionValue)) != null) {
                    if (acmeSession.isValid()) {
                        if (acmeSession.isNew()) {
                            object = new AcmeCookie(SESSION_COOKIE_NAME, this.sessionValue);
                            if (this.serve.expiredIn < 0) {
                                object.setMaxAge(Math.abs(this.serve.expiredIn) * 60);
                            }
                            ((AcmeCookie)((Object)object)).setHttpOnly(this.serve.httpSessCookie);
                            if (this.serve.secureSessCookie) {
                                ((AcmeCookie)((Object)object)).setSecure(true);
                            }
                            ServletContext servletContext = acmeSession.getServletContext();
                            try {
                                String string = (String)servletContext.getClass().getMethod("getContextPath", Utils.EMPTY_CLASSES).invoke((Object)servletContext, Utils.EMPTY_OBJECTS);
                                if (string.length() == 0) {
                                    string = "/";
                                }
                                object.setPath(string);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.addCookie((Cookie)object);
                        }
                    } else {
                        object = new AcmeCookie(SESSION_COOKIE_NAME, "");
                        object.setMaxAge(0);
                        ((AcmeCookie)((Object)object)).setHttpOnly(this.serve.httpSessCookie);
                        this.addCookie((Cookie)object);
                    }
                }
                for (int i = 0; this.outCookies != null && i < this.outCookies.size(); ++i) {
                    object = (Cookie)this.outCookies.elementAt(i);
                    if (object.getSecure() && !this.isSecure()) continue;
                    int n = object.getVersion();
                    boolean bl2 = false;
                    try {
                        bl2 = Boolean.TRUE.equals(object.getClass().getMethod("isHttpOnly", Utils.EMPTY_CLASSES).invoke(object, Utils.EMPTY_OBJECTS));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n > 1) {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer(SETCOOKIE + "2: ");
                        } else {
                            stringBuffer.append(',');
                        }
                        stringBuffer.append(object.getName());
                        stringBuffer.append("=\"");
                        stringBuffer.append(object.getValue()).append('\"');
                        String string = object.getComment();
                        if (string != null) {
                            stringBuffer.append("; Comment=\"").append(string).append('\"');
                        }
                        if ((string = object.getDomain()) != null) {
                            stringBuffer.append("; Domain=\"").append(string).append('\"');
                        }
                        if (object.getMaxAge() >= 0) {
                            stringBuffer.append("; Max-Age=\"").append(object.getMaxAge()).append('\"');
                        }
                        if ((string = object.getPath()) != null) {
                            stringBuffer.append("; Path=\"").append(string).append('\"');
                        }
                        if (object.getSecure()) {
                            stringBuffer.append("; Secure");
                        }
                        if (bl2) {
                            stringBuffer.append("; HttpOnly");
                        }
                        stringBuffer.append("; Version=\"").append(n).append('\"');
                        continue;
                    }
                    if (charSequence == null) {
                        charSequence = new StringBuffer(SETCOOKIE + ": ");
                    } else {
                        ((StringBuffer)charSequence).append("\r\n" + SETCOOKIE + ": ");
                    }
                    ((StringBuffer)charSequence).append(object.getName());
                    ((StringBuffer)charSequence).append('=');
                    ((StringBuffer)charSequence).append(object.getValue());
                    if (object.getDomain() != null && object.getDomain().length() > 0) {
                        ((StringBuffer)charSequence).append("; domain=" + object.getDomain());
                    }
                    if (object.getMaxAge() >= 0) {
                        ((StringBuffer)charSequence).append("; expires=");
                        ((StringBuffer)charSequence).append(this.expdatefmt.format(new Date(new Date().getTime() + 1000L * (long)object.getMaxAge())));
                    }
                    if (object.getPath() != null && object.getPath().length() > 0) {
                        ((StringBuffer)charSequence).append("; path=" + object.getPath());
                    }
                    if (object.getSecure()) {
                        ((StringBuffer)charSequence).append("; secure");
                    }
                    if (!bl2) continue;
                    ((StringBuffer)charSequence).append("; HttpOnly");
                }
                if (charSequence != null) {
                    this.out.println(((StringBuffer)charSequence).toString());
                }
                if (stringBuffer != null) {
                    this.out.println(stringBuffer.toString());
                }
                if (!bl && l < 0L) {
                    if (this.serve.isKeepAlive() && this.oneOne) {
                        if (this.resCode != 204) {
                            this.out.println(TRANSFERENCODING + ": " + CHUNKED);
                            bl = true;
                        }
                    } else {
                        this.keepAlive = false;
                        this.setHeader(CONNECTION, "close");
                        this.setHeader(KEEPALIVE, null);
                    }
                }
                if ((v = this.resHeaderNames.get(CONNECTION)) instanceof String) {
                    this.out.println(CONNECTION + ": " + v);
                }
                if ((v = this.resHeaderNames.get(KEEPALIVE)) instanceof String) {
                    this.out.println(KEEPALIVE + ": " + v);
                }
                this.out.println();
                this.out.flush();
                if (this.resCode == 204) {
                    this.out.close();
                } else {
                    ((ServeOutputStream)this.out).setChunked(bl);
                }
            }
        }

        public void sendError(int n, String string) throws IOException {
            this.setStatus(n, string);
            this.realSendError();
        }

        public void sendError(int n) throws IOException {
            this.setStatus(n);
            this.realSendError();
        }

        private void realSendError() throws IOException {
            if (this.isCommitted()) {
                throw new IllegalStateException("Can not send an error (" + this.resCode + ") - " + this.resMessage + ", headers have been already written");
            }
            this.setContentType("text/html");
            StringBuffer stringBuffer = new StringBuffer(100);
            int n = this.resMessage.indexOf(10);
            stringBuffer.append("<HTML><HEAD>").append("<TITLE>" + this.resCode + " " + (n < 0 ? this.resMessage : this.resMessage.substring(0, n)) + "</TITLE>").append("</HEAD><BODY BGCOLOR=\"#D1E9FE\"").append("><H2>" + this.resCode + " " + (n < 0 ? this.resMessage : this.resMessage.substring(0, n)) + "</H2>");
            if (n > 0) {
                stringBuffer.append("<PRE>").append(Utils.htmlEncode(this.resMessage.substring(n), false)).append("</PRE>");
            }
            stringBuffer.append("<HR>");
            this.sendEnd(stringBuffer);
        }

        public void sendRedirect(String string) throws IOException {
            CharSequence charSequence;
            if (this.isCommitted()) {
                throw new IllegalStateException("Can not redirect, headers have been already written");
            }
            if (string.indexOf(":/") < 0) {
                charSequence = "";
                if ("https".equalsIgnoreCase(this.getScheme())) {
                    if (this.getServerPort() != 443) {
                        charSequence = ":" + this.getServerPort();
                    }
                } else if (this.getServerPort() != 80) {
                    charSequence = ":" + this.getServerPort();
                }
                if (string.length() > 0 && string.charAt(0) == '/') {
                    string = this.getScheme() + "://" + this.getServerName() + (String)charSequence + string;
                } else {
                    String string2;
                    int n = this.reqUriPathUn.lastIndexOf(47);
                    if (n < 0) {
                        string2 = this.reqUriPathUn + '/';
                        n = string2.length();
                    } else {
                        string2 = this.reqUriPathUn;
                        ++n;
                    }
                    string = this.getScheme() + "://" + this.getServerName() + (String)charSequence + string2.substring(0, n) + string;
                }
            }
            this.setHeader("Location", string);
            this.setStatus(302);
            this.setContentType("text/html");
            charSequence = new StringBuffer(200);
            ((StringBuffer)charSequence).append("<HTML><HEAD><TITLE>302 Moved</TITLE></HEAD><BODY BGCOLOR=\"#D1E9FE\"><H2>302 Moved</H2>This document has moved <a href=\"" + string + "\">here.<HR>");
            this.sendEnd((StringBuffer)charSequence);
        }

        private void sendEnd(StringBuffer stringBuffer) throws IOException {
            stringBuffer.append("<ADDRESS><A HREF=\"http://tjws.sourceforge.net\">D. Rogatkin's TJWS with Android support (aka Acme.Serve) Version 1.105, $Revision: 1.267 $</A></ADDRESS>");
            stringBuffer.append("</BODY></HTML>");
            this.setContentLength(stringBuffer.length());
            if (!this.oneOne) {
                this.keepAlive = false;
                this.setHeader(CONNECTION, "close");
                this.setHeader(KEEPALIVE, null);
            }
            this.out.print(stringBuffer.toString());
            this.out.close();
        }

        public String encodeUrl(String string) {
            return this.encodeURL(string);
        }

        public String encodeRedirectUrl(String string) {
            return this.encodeRedirectURL(string);
        }

        public Socket getSocket() {
            return this.socket;
        }

        static {
            tz.setID("GMT");
        }
    }

    protected static class ServeConfig
    implements ServletConfig {
        private ServletContext context;
        private Hashtable init_params;
        private String servletName;

        public ServeConfig(ServletContext servletContext) {
            this(servletContext, null, "undefined");
        }

        public ServeConfig(ServletContext servletContext, Hashtable hashtable, String string) {
            this.context = servletContext;
            this.init_params = hashtable;
            this.servletName = string;
        }

        public ServletContext getServletContext() {
            return this.context;
        }

        public String getInitParameter(String string) {
            if (this.init_params != null) {
                return (String)this.init_params.get(string);
            }
            return null;
        }

        public Enumeration getInitParameterNames() {
            if (this.init_params != null) {
                return this.init_params.keys();
            }
            return new Vector().elements();
        }

        public String getServletName() {
            return this.servletName;
        }
    }

    public static interface Identification {
        public static final String serverName = "D. Rogatkin's TJWS with Android support (aka Acme.Serve)";
        public static final String serverVersion = "Version 1.105, $Revision: 1.267 $";
        public static final String serverUrl = "http://tjws.sourceforge.net";
        public static final String serverIdHtml = "<ADDRESS><A HREF=\"http://tjws.sourceforge.net\">D. Rogatkin's TJWS with Android support (aka Acme.Serve) Version 1.105, $Revision: 1.267 $</A></ADDRESS>";
    }

    class KeepAliveCleaner
    extends Thread {
        protected List connections;
        protected List ingoings;
        protected boolean stopped;
        private boolean noCheckClose;

        KeepAliveCleaner() {
            super("KeepAlive cleaner");
            this.connections = new LinkedList();
            this.ingoings = new LinkedList();
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addConnection(ServeConnection serveConnection) {
            List list = this.ingoings;
            synchronized (list) {
                if (!this.stopped) {
                    this.ingoings.add(serveConnection);
                }
            }
        }

        void clear() {
            if (!this.stopped) {
                new IllegalStateException("Can't clear running cleaner");
            }
            this.clear(this.ingoings);
            this.clear(this.connections);
        }

        private void clear(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ServeConnection serveConnection = (ServeConnection)iterator.next();
                iterator.remove();
                serveConnection.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int n = Serve.this.getMaxTimesConnectionUse();
            while (true) {
                Object object = this.ingoings;
                synchronized (object) {
                    Iterator iterator = this.ingoings.iterator();
                    while (iterator.hasNext()) {
                        this.connections.add(iterator.next());
                        iterator.remove();
                    }
                }
                object = this.connections.iterator();
                long l = System.currentTimeMillis();
                long l2 = Serve.this.getKeepAliveDuration();
                while (object.hasNext()) {
                    ServeConnection serveConnection;
                    boolean bl;
                    ServeConnection serveConnection2 = (ServeConnection)object.next();
                    boolean bl2 = bl = serveConnection2.socket == null;
                    if (!this.noCheckClose) {
                        serveConnection = serveConnection2;
                        synchronized (serveConnection) {
                            if (serveConnection2.socket != null) {
                                try {
                                    bl = (Boolean)serveConnection2.socket.getClass().getMethod("isClosed", Utils.EMPTY_CLASSES).invoke((Object)serveConnection2.socket, Utils.EMPTY_OBJECTS);
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    this.noCheckClose = true;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    if (bl || !serveConnection2.keepAlive || l - serveConnection2.lastWait > l2 && serveConnection2.lastRun < serveConnection2.lastWait || this.stopped) {
                        object.remove();
                        serveConnection = serveConnection2;
                        synchronized (serveConnection) {
                            if (serveConnection2.socket != null) {
                                try {
                                    serveConnection2.socket.getInputStream().close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    if (serveConnection2.asyncTimeout <= 0L) continue;
                    if (l >= serveConnection2.asyncTimeout) {
                        if (serveConnection2.asyncMode == null) continue;
                        serveConnection2.asyncMode.notifyTimeout();
                        serveConnection2.keepAlive = false;
                        serveConnection2.joinAsync();
                        continue;
                    }
                    long l3 = serveConnection2.asyncTimeout - l;
                    if (l3 >= l2) continue;
                    l2 = l3;
                }
                if (this.stopped && this.connections.size() == 0) break;
                try {
                    KeepAliveCleaner.sleep(l2);
                }
                catch (InterruptedException interruptedException) {
                    this.stopped = true;
                }
            }
        }
    }

    protected class SimpleRequestDispatcher
    implements RequestDispatcher {
        HttpServlet servlet;
        String dispatchPath;
        String dispatchQuery;
        int dispatchLen;

        SimpleRequestDispatcher(String string) {
            PathTreeDictionary pathTreeDictionary = (PathTreeDictionary)currentRegistry.get();
            if (pathTreeDictionary == null) {
                pathTreeDictionary = Serve.this.defaultRegistry;
            }
            Object[] objectArray = pathTreeDictionary.get(string);
            this.servlet = (HttpServlet)objectArray[0];
            if (this.servlet == null) {
                throw new NullPointerException();
            }
            this.dispatchLen = (Integer)objectArray[1];
            int n = string.indexOf(63);
            if (n < 0 || n >= string.length() - 1) {
                this.dispatchPath = string;
            } else {
                this.dispatchPath = string.substring(0, n);
                this.dispatchQuery = string.substring(n + 1);
            }
        }

        public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
            servletRequest.removeAttribute("javax.servlet.forward.request_uri");
            servletResponse.reset();
            this.servlet.service((ServletRequest)new HttpServletRequestWrapper((HttpServletRequest)servletRequest){

                public String getPathInfo() {
                    return SimpleRequestDispatcher.this.dispatchLen >= SimpleRequestDispatcher.this.dispatchPath.length() ? null : SimpleRequestDispatcher.this.dispatchPath.substring(SimpleRequestDispatcher.this.dispatchLen);
                }

                public String getRequestURI() {
                    return SimpleRequestDispatcher.this.dispatchPath;
                }

                public String getQueryString() {
                    return SimpleRequestDispatcher.this.dispatchQuery;
                }

                public String getPathTranslated() {
                    return this.getRequest().getRealPath(this.getPathInfo());
                }

                public String getServletPath() {
                    return SimpleRequestDispatcher.this.dispatchLen <= 0 ? "" : SimpleRequestDispatcher.this.dispatchPath.substring(0, SimpleRequestDispatcher.this.dispatchLen);
                }

                public synchronized Enumeration getAttributeNames() {
                    if (super.getAttribute("javax.servlet.forward.request_uri") == null) {
                        this.setAttribute("javax.servlet.forward.request_uri", super.getRequestURI());
                        this.setAttribute("javax.servlet.forward.context_path", this.getContextPath());
                        this.setAttribute("javax.servlet.forward.servlet_path", super.getServletPath());
                        this.setAttribute("javax.servlet.forward.path_info", super.getPathInfo());
                        this.setAttribute("javax.servlet.forward.query_string", super.getQueryString());
                    }
                    return super.getAttributeNames();
                }

                public Object getAttribute(String string) {
                    this.getAttributeNames();
                    return super.getAttribute(string);
                }
            }, servletResponse);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
            servletRequest.removeAttribute("javax.servlet.include.request_uri");
            ((ServeConnection)servletResponse).setInInclude(true);
            try {
                this.servlet.service((ServletRequest)new HttpServletRequestWrapper((HttpServletRequest)servletRequest){

                    public synchronized Enumeration getAttributeNames() {
                        if (super.getAttribute("javax.servlet.include.request_uri") == null) {
                            this.setAttribute("javax.servlet.include.request_uri", SimpleRequestDispatcher.this.dispatchPath);
                            this.setAttribute("javax.servlet.include.context_path", this.getContextPath());
                            this.setAttribute("javax.servlet.include.servlet_path", SimpleRequestDispatcher.this.dispatchLen <= 0 ? "" : SimpleRequestDispatcher.this.dispatchPath.substring(0, SimpleRequestDispatcher.this.dispatchLen));
                            this.setAttribute("javax.servlet.include.path_info", SimpleRequestDispatcher.this.dispatchLen >= SimpleRequestDispatcher.this.dispatchPath.length() ? null : SimpleRequestDispatcher.this.dispatchPath.substring(SimpleRequestDispatcher.this.dispatchLen));
                            this.setAttribute("javax.servlet.include.query_string", SimpleRequestDispatcher.this.dispatchQuery);
                        }
                        return super.getAttributeNames();
                    }

                    public Object getAttribute(String string) {
                        this.getAttributeNames();
                        return super.getAttribute(string);
                    }
                }, servletResponse);
            }
            finally {
                ((ServeConnection)servletResponse).setInInclude(false);
            }
        }
    }

    public static interface AsyncCallback {
        public void notifyTimeout();

        public long getTimeout();
    }

    public static interface Acceptor {
        public void init(Map var1, Map var2) throws IOException;

        public Socket accept() throws IOException;

        public void destroy() throws IOException;
    }
}

