/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.android;

import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import com.couchbase.lite.storage.ContentValues;
import com.couchbase.lite.storage.Cursor;
import com.couchbase.lite.storage.SQLiteStorageEngine;
import com.couchbase.lite.util.Log;
import com.couchbase.touchdb.RevCollator;
import com.couchbase.touchdb.TDCollateJSON;
import java.util.Map;

public class AndroidSQLiteStorageEngine
implements SQLiteStorageEngine {
    public static final String TAG = "AndroidSQLiteStorageEngine";
    private SQLiteDatabase database;

    public boolean open(String path) {
        if (this.database != null && this.database.isOpen()) {
            return true;
        }
        try {
            this.database = SQLiteDatabase.openDatabase((String)path, null, (int)0x10000000);
            Log.v((String)"Database", (String)"%s: Opened Android sqlite db", (Object[])new Object[]{this});
            TDCollateJSON.registerCustomCollators(this.database);
            RevCollator.register(this.database);
        }
        catch (SQLiteException e) {
            Log.e((String)TAG, (String)"Error opening", (Throwable)e);
            if (this.database != null) {
                this.database.close();
            }
            return false;
        }
        return this.database.isOpen();
    }

    public int getVersion() {
        return this.database.getVersion();
    }

    public void setVersion(int version) {
        this.database.setVersion(version);
    }

    public boolean isOpen() {
        return this.database.isOpen();
    }

    public void beginTransaction() {
        this.database.beginTransaction();
    }

    public void endTransaction() {
        this.database.endTransaction();
    }

    public void setTransactionSuccessful() {
        this.database.setTransactionSuccessful();
    }

    public void execSQL(String sql) throws com.couchbase.lite.storage.SQLException {
        try {
            this.database.execSQL(sql);
        }
        catch (SQLException e) {
            throw new com.couchbase.lite.storage.SQLException((Throwable)e);
        }
    }

    public void execSQL(String sql, Object[] bindArgs) throws com.couchbase.lite.storage.SQLException {
        try {
            this.database.execSQL(sql, bindArgs);
        }
        catch (SQLException e) {
            throw new com.couchbase.lite.storage.SQLException((Throwable)e);
        }
    }

    public Cursor rawQuery(String sql, String[] selectionArgs) {
        return new SQLiteCursorWrapper(this.database.rawQuery(sql, selectionArgs));
    }

    public long insert(String table, String nullColumnHack, ContentValues values) {
        return this.database.insert(table, nullColumnHack, this._toAndroidContentValues(values));
    }

    public long insertWithOnConflict(String table, String nullColumnHack, ContentValues initialValues, int conflictAlgorithm) {
        return this.database.insertWithOnConflict(table, nullColumnHack, this._toAndroidContentValues(initialValues), conflictAlgorithm);
    }

    public int update(String table, ContentValues values, String whereClause, String[] whereArgs) {
        return this.database.update(table, this._toAndroidContentValues(values), whereClause, whereArgs);
    }

    public int delete(String table, String whereClause, String[] whereArgs) {
        return this.database.delete(table, whereClause, whereArgs);
    }

    public void close() {
        this.database.close();
        Log.v((String)"Database", (String)"%s: Closed Android sqlite db", (Object[])new Object[]{this});
    }

    public String toString() {
        return "AndroidSQLiteStorageEngine{database=" + Integer.toHexString(System.identityHashCode(this.database)) + '}';
    }

    private android.content.ContentValues _toAndroidContentValues(ContentValues values) {
        android.content.ContentValues contentValues = new android.content.ContentValues(values.size());
        for (Map.Entry value : values.valueSet()) {
            if (value.getValue() == null) {
                contentValues.put((String)value.getKey(), (String)null);
                continue;
            }
            if (value.getValue() instanceof String) {
                contentValues.put((String)value.getKey(), (String)value.getValue());
                continue;
            }
            if (value.getValue() instanceof Integer) {
                contentValues.put((String)value.getKey(), (Integer)value.getValue());
                continue;
            }
            if (value.getValue() instanceof Long) {
                contentValues.put((String)value.getKey(), (Long)value.getValue());
                continue;
            }
            if (value.getValue() instanceof Boolean) {
                contentValues.put((String)value.getKey(), (Boolean)value.getValue());
                continue;
            }
            if (!(value.getValue() instanceof byte[])) continue;
            contentValues.put((String)value.getKey(), (byte[])value.getValue());
        }
        return contentValues;
    }

    private class SQLiteCursorWrapper
    implements Cursor {
        private android.database.Cursor delegate;

        public SQLiteCursorWrapper(android.database.Cursor delegate) {
            this.delegate = delegate;
        }

        public boolean moveToNext() {
            return this.delegate.moveToNext();
        }

        public boolean isAfterLast() {
            return this.delegate.isAfterLast();
        }

        public String getString(int columnIndex) {
            return this.delegate.getString(columnIndex);
        }

        public int getInt(int columnIndex) {
            return this.delegate.getInt(columnIndex);
        }

        public long getLong(int columnIndex) {
            return this.delegate.getLong(columnIndex);
        }

        public byte[] getBlob(int columnIndex) {
            return this.delegate.getBlob(columnIndex);
        }

        public void close() {
            this.delegate.close();
        }
    }
}

