/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.BlobStoreWriter;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.Document;
import com.couchbase.lite.Revision;
import com.couchbase.lite.internal.AttachmentInternal;
import com.couchbase.lite.internal.InterfaceAudience;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Attachment {
    private Revision revision;
    private boolean gzipped;
    private Document document;
    private String name;
    private Map<String, Object> metadata;
    private InputStream body;

    @InterfaceAudience.Private
    Attachment(InputStream contentStream, String contentType) {
        this.body = contentStream;
        this.metadata = new HashMap<String, Object>();
        this.metadata.put("content_type", contentType);
        this.metadata.put("follows", true);
        this.gzipped = false;
    }

    @InterfaceAudience.Private
    Attachment(Revision revision, String name, Map<String, Object> metadata) {
        this.revision = revision;
        this.name = name;
        this.metadata = metadata;
        this.gzipped = false;
    }

    @InterfaceAudience.Public
    public Revision getRevision() {
        return this.revision;
    }

    @InterfaceAudience.Public
    public Document getDocument() {
        return this.revision.getDocument();
    }

    @InterfaceAudience.Public
    public String getName() {
        return this.name;
    }

    @InterfaceAudience.Public
    public String getContentType() {
        return (String)this.metadata.get("content_type");
    }

    @InterfaceAudience.Public
    public InputStream getContent() throws CouchbaseLiteException {
        if (this.body != null) {
            return this.body;
        }
        Database db = this.revision.getDatabase();
        Attachment attachment = db.getAttachmentForSequence(this.revision.getSequence(), this.name);
        this.body = attachment.getContent();
        return this.body;
    }

    @InterfaceAudience.Public
    public long getLength() {
        Number length = (Number)this.metadata.get("length");
        if (length != null) {
            return length.longValue();
        }
        return 0L;
    }

    @InterfaceAudience.Public
    public Map<String, Object> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    @InterfaceAudience.Private
    void setName(String name) {
        this.name = name;
    }

    @InterfaceAudience.Private
    void setRevision(Revision revision) {
        this.revision = revision;
    }

    @InterfaceAudience.Private
    InputStream getBodyIfNew() {
        return this.body;
    }

    @InterfaceAudience.Private
    static Map<String, Object> installAttachmentBodies(Map<String, Object> attachments, Database database) {
        HashMap<String, Object> updatedAttachments = new HashMap<String, Object>();
        for (String name : attachments.keySet()) {
            Object value = attachments.get(name);
            if (value instanceof Attachment) {
                Attachment attachment = (Attachment)value;
                HashMap<String, Object> metadataMutable = new HashMap<String, Object>();
                metadataMutable.putAll(attachment.getMetadata());
                InputStream body = attachment.getBodyIfNew();
                if (body != null) {
                    BlobStoreWriter writer = Attachment.blobStoreWriterForBody(body, database);
                    metadataMutable.put("length", Long.valueOf(writer.getLength()));
                    metadataMutable.put("digest", writer.mD5DigestString());
                    metadataMutable.put("follows", true);
                    database.rememberAttachmentWriter(writer);
                }
                updatedAttachments.put(name, metadataMutable);
                continue;
            }
            if (value instanceof AttachmentInternal) {
                throw new IllegalArgumentException("AttachmentInternal objects not expected here.  Could indicate a bug");
            }
            if (value == null) continue;
            updatedAttachments.put(name, value);
        }
        return updatedAttachments;
    }

    @InterfaceAudience.Private
    static BlobStoreWriter blobStoreWriterForBody(InputStream body, Database database) {
        BlobStoreWriter writer = database.getAttachmentWriter();
        writer.read(body);
        writer.finish();
        return writer;
    }

    @InterfaceAudience.Private
    public boolean getGZipped() {
        return this.gzipped;
    }

    @InterfaceAudience.Private
    public void setGZipped(boolean gzipped) {
        this.gzipped = gzipped;
    }
}

