/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.Attachment;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.DocumentChange;
import com.couchbase.lite.QueryRow;
import com.couchbase.lite.RevisionList;
import com.couchbase.lite.SavedRevision;
import com.couchbase.lite.UnsavedRevision;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Document {
    private Database database;
    private String documentId;
    private SavedRevision currentRevision;
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    @InterfaceAudience.Private
    public Document(Database database, String documentId) {
        this.database = database;
        this.documentId = documentId;
    }

    @InterfaceAudience.Public
    public Database getDatabase() {
        return this.database;
    }

    @InterfaceAudience.Public
    public String getId() {
        return this.documentId;
    }

    @InterfaceAudience.Public
    public boolean isDeleted() {
        try {
            return this.getCurrentRevision() == null && this.getLeafRevisions().size() > 0;
        }
        catch (CouchbaseLiteException e) {
            throw new RuntimeException(e);
        }
    }

    @InterfaceAudience.Public
    public String getCurrentRevisionId() {
        SavedRevision rev = this.getCurrentRevision();
        if (rev == null) {
            return null;
        }
        return rev.getId();
    }

    @InterfaceAudience.Public
    public SavedRevision getCurrentRevision() {
        if (this.currentRevision == null) {
            this.currentRevision = this.getRevisionWithId(null);
        }
        return this.currentRevision;
    }

    @InterfaceAudience.Public
    public List<SavedRevision> getRevisionHistory() throws CouchbaseLiteException {
        if (this.getCurrentRevision() == null) {
            Log.w("CBLite", "getRevisionHistory() called but no currentRevision");
            return null;
        }
        return this.getCurrentRevision().getRevisionHistory();
    }

    @InterfaceAudience.Public
    public List<SavedRevision> getConflictingRevisions() throws CouchbaseLiteException {
        return this.getLeafRevisions(false);
    }

    @InterfaceAudience.Public
    public List<SavedRevision> getLeafRevisions() throws CouchbaseLiteException {
        return this.getLeafRevisions(true);
    }

    @InterfaceAudience.Public
    public Map<String, Object> getProperties() {
        return this.getCurrentRevision().getProperties();
    }

    @InterfaceAudience.Public
    public Map<String, Object> getUserProperties() {
        return this.getCurrentRevision().getUserProperties();
    }

    @InterfaceAudience.Public
    public boolean delete() throws CouchbaseLiteException {
        return this.getCurrentRevision().deleteDocument() != null;
    }

    @InterfaceAudience.Public
    public void purge() throws CouchbaseLiteException {
        HashMap<String, List<String>> docsToRevs = new HashMap<String, List<String>>();
        ArrayList<String> revs = new ArrayList<String>();
        revs.add("*");
        docsToRevs.put(this.documentId, revs);
        this.database.purgeRevisions(docsToRevs);
        this.database.removeDocumentFromCache(this);
    }

    @InterfaceAudience.Public
    public SavedRevision getRevision(String id) {
        if (this.currentRevision != null && id.equals(this.currentRevision.getId())) {
            return this.currentRevision;
        }
        EnumSet<Database.TDContentOptions> contentOptions = EnumSet.noneOf(Database.TDContentOptions.class);
        RevisionInternal revisionInternal = this.database.getDocumentWithIDAndRev(this.getId(), id, contentOptions);
        SavedRevision revision = null;
        revision = this.getRevisionFromRev(revisionInternal);
        return revision;
    }

    @InterfaceAudience.Public
    public UnsavedRevision createRevision() {
        return new UnsavedRevision(this, this.getCurrentRevision());
    }

    @InterfaceAudience.Public
    public Object getProperty(String key) {
        if (this.getCurrentRevision().getProperties().containsKey(key)) {
            return this.getCurrentRevision().getProperties().get(key);
        }
        return null;
    }

    @InterfaceAudience.Public
    public SavedRevision putProperties(Map<String, Object> properties) throws CouchbaseLiteException {
        String prevID = (String)properties.get("_rev");
        boolean allowConflict = false;
        return this.putProperties(properties, prevID, allowConflict);
    }

    @InterfaceAudience.Public
    public SavedRevision update(DocumentUpdater updater) throws CouchbaseLiteException {
        UnsavedRevision newRev;
        int lastErrorCode = -1;
        while (updater.update(newRev = this.createRevision())) {
            try {
                SavedRevision savedRev = newRev.save();
                if (savedRev != null) {
                    return savedRev;
                }
            }
            catch (CouchbaseLiteException e) {
                lastErrorCode = e.getCBLStatus().getCode();
            }
            if (lastErrorCode == 409) continue;
        }
        return null;
    }

    @InterfaceAudience.Public
    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    @InterfaceAudience.Public
    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    @InterfaceAudience.Private
    public String getAbbreviatedId() {
        String abbreviated = this.documentId;
        if (this.documentId.length() > 10) {
            String firstFourChars = this.documentId.substring(0, 4);
            String lastFourChars = this.documentId.substring(abbreviated.length() - 4);
            return String.format("%s..%s", firstFourChars, lastFourChars);
        }
        return this.documentId;
    }

    @InterfaceAudience.Private
    List<SavedRevision> getLeafRevisions(boolean includeDeleted) throws CouchbaseLiteException {
        ArrayList<SavedRevision> result = new ArrayList<SavedRevision>();
        RevisionList revs = this.database.getAllRevisionsOfDocumentID(this.documentId, true);
        for (RevisionInternal rev : revs) {
            if (!includeDeleted && rev.isDeleted()) continue;
            result.add(this.getRevisionFromRev(rev));
        }
        return Collections.unmodifiableList(result);
    }

    @InterfaceAudience.Private
    SavedRevision putProperties(Map<String, Object> properties, String prevID, boolean allowConflict) throws CouchbaseLiteException {
        RevisionInternal newRev;
        String newId = null;
        if (properties != null && properties.containsKey("_id")) {
            newId = (String)properties.get("_id");
        }
        if (newId != null && !newId.equalsIgnoreCase(this.getId())) {
            Log.w("CBLite", "Trying to put wrong _id to this: %s properties: %s", this, properties);
        }
        Map attachments = null;
        if (properties != null && properties.containsKey("_attachments")) {
            attachments = (Map)properties.get("_attachments");
        }
        if (attachments != null && attachments.size() > 0) {
            Map<String, Object> updatedAttachments = Attachment.installAttachmentBodies(attachments, this.database);
            properties.put("_attachments", updatedAttachments);
        }
        boolean hasTrueDeletedProperty = false;
        if (properties != null) {
            hasTrueDeletedProperty = properties.get("_deleted") != null && (Boolean)properties.get("_deleted") != false;
        }
        boolean deleted = properties == null || hasTrueDeletedProperty;
        RevisionInternal rev = new RevisionInternal(this.documentId, null, deleted, this.database);
        if (properties != null) {
            rev.setProperties(properties);
        }
        if ((newRev = this.database.putRevision(rev, prevID, allowConflict)) == null) {
            return null;
        }
        return new SavedRevision(this, newRev);
    }

    @InterfaceAudience.Private
    SavedRevision getRevisionFromRev(RevisionInternal internalRevision) {
        if (internalRevision == null) {
            return null;
        }
        if (this.currentRevision != null && internalRevision.getRevId().equals(this.currentRevision.getId())) {
            return this.currentRevision;
        }
        return new SavedRevision(this, internalRevision);
    }

    @InterfaceAudience.Private
    SavedRevision getRevisionWithId(String revId) {
        if (revId != null && this.currentRevision != null && revId.equals(this.currentRevision.getId())) {
            return this.currentRevision;
        }
        return this.getRevisionFromRev(this.database.getDocumentWithIDAndRev(this.getId(), revId, EnumSet.noneOf(Database.TDContentOptions.class)));
    }

    @InterfaceAudience.Private
    void loadCurrentRevisionFrom(QueryRow row) {
        Map<String, Object> properties;
        if (row.getDocumentRevisionId() == null) {
            return;
        }
        String revId = row.getDocumentRevisionId();
        if ((this.currentRevision == null || this.revIdGreaterThanCurrent(revId)) && (properties = row.getDocumentProperties()) != null) {
            RevisionInternal rev = new RevisionInternal(properties, row.getDatabase());
            this.currentRevision = new SavedRevision(this, rev);
        }
    }

    @InterfaceAudience.Private
    private boolean revIdGreaterThanCurrent(String revId) {
        return RevisionInternal.CBLCompareRevIDs(revId, this.currentRevision.getId()) > 0;
    }

    @InterfaceAudience.Private
    void revisionAdded(DocumentChange documentChange) {
        RevisionInternal rev = documentChange.getWinningRevision();
        if (rev == null) {
            return;
        }
        if (this.currentRevision != null && !rev.getRevId().equals(this.currentRevision.getId())) {
            this.currentRevision = !rev.isDeleted() ? new SavedRevision(this, rev) : null;
        }
        for (ChangeListener listener : this.changeListeners) {
            listener.changed(new ChangeEvent(this, documentChange));
        }
    }

    @InterfaceAudience.Public
    public static interface ChangeListener {
        public void changed(ChangeEvent var1);
    }

    @InterfaceAudience.Public
    public static class ChangeEvent {
        private Document source;
        private DocumentChange change;

        public ChangeEvent(Document source, DocumentChange documentChange) {
            this.source = source;
            this.change = documentChange;
        }

        public Document getSource() {
            return this.source;
        }

        public DocumentChange getChange() {
            return this.change;
        }
    }

    @InterfaceAudience.Public
    public static interface DocumentUpdater {
        public boolean update(UnsavedRevision var1);
    }
}

