/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal;

import com.couchbase.lite.Manager;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectWriter;

public class Body {
    private byte[] json;
    private Object object;

    public Body(byte[] json) {
        this.json = json;
    }

    public Body(Map<String, Object> properties) {
        this.object = properties;
    }

    public Body(List<?> array) {
        this.object = array;
    }

    public static Body bodyWithProperties(Map<String, Object> properties) {
        Body result = new Body(properties);
        return result;
    }

    public static Body bodyWithJSON(byte[] json) {
        Body result = new Body(json);
        return result;
    }

    public byte[] getJson() {
        if (this.json == null) {
            this.lazyLoadJsonFromObject();
        }
        return this.json;
    }

    private void lazyLoadJsonFromObject() {
        if (this.object == null) {
            throw new IllegalStateException("Both json and object are null for this body: " + this);
        }
        try {
            this.json = Manager.getObjectMapper().writeValueAsBytes(this.object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getObject() {
        if (this.object == null) {
            this.lazyLoadObjectFromJson();
        }
        return this.object;
    }

    private void lazyLoadObjectFromJson() {
        if (this.json == null) {
            throw new IllegalStateException("Both object and json are null for this body: " + this);
        }
        try {
            this.object = Manager.getObjectMapper().readValue(this.json, Object.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isValidJSON() {
        if (this.object == null) {
            boolean gotException = false;
            if (this.json == null) {
                throw new IllegalStateException("Both object and json are null for this body: " + this);
            }
            try {
                this.object = Manager.getObjectMapper().readValue(this.json, Object.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.object != null;
    }

    public byte[] getPrettyJson() {
        Object properties = this.getObject();
        if (properties != null) {
            ObjectWriter writer = Manager.getObjectMapper().writerWithDefaultPrettyPrinter();
            try {
                this.json = writer.writeValueAsBytes(properties);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.getJson();
    }

    public String getJSONString() {
        return new String(this.getJson());
    }

    public Map<String, Object> getProperties() {
        Object object = this.getObject();
        if (object instanceof Map) {
            Map map = (Map)object;
            return Collections.unmodifiableMap(map);
        }
        return null;
    }

    public Object getPropertyForKey(String key) {
        Map<String, Object> theProperties = this.getProperties();
        if (theProperties == null) {
            return null;
        }
        return theProperties.get(key);
    }
}

