/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.replicator;

import com.couchbase.lite.Manager;
import com.couchbase.lite.auth.Authenticator;
import com.couchbase.lite.auth.AuthenticatorImpl;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.replicator.ChangeTrackerBackoff;
import com.couchbase.lite.replicator.ChangeTrackerClient;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.URIUtils;
import com.couchbase.lite.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

@InterfaceAudience.Private
public class ChangeTracker
implements Runnable {
    private URL databaseURL;
    private ChangeTrackerClient client;
    private ChangeTrackerMode mode;
    private Object lastSequenceID;
    private boolean includeConflicts;
    private Thread thread;
    private boolean running = false;
    private HttpUriRequest request;
    private String filterName;
    private Map<String, Object> filterParams;
    private List<String> docIDs;
    private Throwable error;
    protected Map<String, Object> requestHeaders;
    protected ChangeTrackerBackoff backoff;
    private boolean usePOST;
    private int heartBeatSeconds;
    private int limit;
    private boolean caughtUp = false;
    private boolean continuous = false;
    private Authenticator authenticator;

    public ChangeTracker(URL databaseURL, ChangeTrackerMode mode, boolean includeConflicts, Object lastSequenceID, ChangeTrackerClient client) {
        this.databaseURL = databaseURL;
        this.mode = mode;
        this.includeConflicts = includeConflicts;
        this.lastSequenceID = lastSequenceID;
        this.client = client;
        this.requestHeaders = new HashMap<String, Object>();
        this.heartBeatSeconds = 300;
        this.limit = 50;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public void setContinuous(boolean continuous) {
        this.continuous = continuous;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public void setFilterParams(Map<String, Object> filterParams) {
        this.filterParams = filterParams;
    }

    public void setClient(ChangeTrackerClient client) {
        this.client = client;
    }

    public String getDatabaseName() {
        int pathLastSlashPos;
        String result = null;
        if (this.databaseURL != null && (result = this.databaseURL.getPath()) != null && (pathLastSlashPos = result.lastIndexOf(47)) > 0) {
            result = result.substring(pathLastSlashPos);
        }
        return result;
    }

    public String getFeed() {
        switch (this.mode) {
            case OneShot: {
                return "normal";
            }
            case LongPoll: {
                return "longpoll";
            }
            case Continuous: {
                return "continuous";
            }
        }
        return "normal";
    }

    public long getHeartbeatMilliseconds() {
        return this.heartBeatSeconds * 1000;
    }

    public String getChangesFeedPath() {
        if (this.usePOST) {
            return "_changes";
        }
        String path = "_changes?feed=";
        path = path + this.getFeed();
        if (this.mode == ChangeTrackerMode.LongPoll) {
            path = path + String.format("&limit=%s", this.limit);
        }
        path = path + String.format("&heartbeat=%s", this.getHeartbeatMilliseconds());
        if (this.includeConflicts) {
            path = path + "&style=all_docs";
        }
        if (this.lastSequenceID != null) {
            path = path + "&since=" + URLEncoder.encode(this.lastSequenceID.toString());
        }
        if (this.docIDs != null && this.docIDs.size() > 0) {
            this.filterName = "_doc_ids";
            this.filterParams = new HashMap<String, Object>();
            this.filterParams.put("doc_ids", this.docIDs);
        }
        if (this.filterName != null) {
            path = path + "&filter=" + URLEncoder.encode(this.filterName);
            if (this.filterParams != null) {
                for (String filterParamKey : this.filterParams.keySet()) {
                    Object value = this.filterParams.get(filterParamKey);
                    if (!(value instanceof String)) {
                        try {
                            value = Manager.getObjectMapper().writeValueAsString(value);
                        }
                        catch (IOException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                    path = path + "&" + URLEncoder.encode(filterParamKey) + "=" + URLEncoder.encode(value.toString());
                }
            }
        }
        return path;
    }

    public URL getChangesFeedURL() {
        String dbURLString = this.databaseURL.toExternalForm();
        if (!dbURLString.endsWith("/")) {
            dbURLString = dbURLString + "/";
        }
        dbURLString = dbURLString + this.getChangesFeedPath();
        URL result = null;
        try {
            result = new URL(dbURLString);
        }
        catch (MalformedURLException e) {
            Log.e("ChangeTracker", this + ": Changes feed ULR is malformed", e);
        }
        return result;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        if (this.client == null) {
            Log.w("ChangeTracker", "%s: ChangeTracker run() loop aborting because client == null", this);
            return;
        }
        if (this.mode == ChangeTrackerMode.Continuous) {
            throw new RuntimeException("ChangeTracker does not correctly support continuous mode");
        }
        HttpClient httpClient = this.client.getHttpClient();
        this.backoff = new ChangeTrackerBackoff();
        while (this.running) {
            URL url = this.getChangesFeedURL();
            if (this.usePOST) {
                StringEntity entity;
                HttpPost postRequest = new HttpPost(url.toString());
                postRequest.setHeader("Content-Type", "application/json");
                try {
                    entity = new StringEntity(this.changesFeedPOSTBody());
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                postRequest.setEntity((HttpEntity)entity);
                this.request = postRequest;
            } else {
                this.request = new HttpGet(url.toString());
            }
            this.addRequestHeaders(this.request);
            boolean isUrlBasedUserInfo = false;
            String userInfo = url.getUserInfo();
            if (userInfo != null) {
                isUrlBasedUserInfo = true;
            } else if (this.authenticator != null) {
                AuthenticatorImpl auth = (AuthenticatorImpl)this.authenticator;
                userInfo = auth.authUserInfo();
            }
            if (userInfo != null) {
                if (userInfo.contains(":") && !userInfo.trim().equals(":")) {
                    String[] userInfoElements = userInfo.split(":");
                    String username = isUrlBasedUserInfo ? URIUtils.decode(userInfoElements[0]) : userInfoElements[0];
                    String password = isUrlBasedUserInfo ? URIUtils.decode(userInfoElements[1]) : userInfoElements[1];
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
                    if (httpClient instanceof DefaultHttpClient) {
                        DefaultHttpClient dhc = (DefaultHttpClient)httpClient;
                        HttpRequestInterceptor preemptiveAuth = new HttpRequestInterceptor((Credentials)credentials){
                            final /* synthetic */ Credentials val$credentials;
                            {
                                this.val$credentials = credentials;
                            }

                            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                                AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
                                if (authState.getAuthScheme() == null) {
                                    authState.setAuthScheme((AuthScheme)new BasicScheme());
                                    authState.setCredentials(this.val$credentials);
                                }
                            }
                        };
                        dhc.addRequestInterceptor(preemptiveAuth, 0);
                    }
                } else {
                    Log.w("ChangeTracker", "RemoteRequest Unable to parse user info, not setting credentials");
                }
            }
            try {
                String maskedRemoteWithoutCredentials = this.getChangesFeedURL().toString();
                maskedRemoteWithoutCredentials = maskedRemoteWithoutCredentials.replaceAll("://.*:.*@", "://---:---@");
                if (this.client == null) {
                    Log.w("ChangeTracker", "%s: ChangeTracker run() loop aborting because client == null", this);
                    return;
                }
                Log.v("ChangeTracker", "%s: Making request to %s", this, maskedRemoteWithoutCredentials);
                HttpResponse response = httpClient.execute(this.request);
                StatusLine status = response.getStatusLine();
                if (status.getStatusCode() >= 300 && !Utils.isTransientError(status)) {
                    Log.e("ChangeTracker", "%s: Change tracker got error %d", this, status.getStatusCode());
                    this.error = new HttpResponseException(status.getStatusCode(), status.getReasonPhrase());
                    this.stop();
                    return;
                }
                if (this.client == null) {
                    Log.w("ChangeTracker", "%s: ChangeTracker run() loop aborting because client == null", this);
                    return;
                }
                HttpEntity entity = response.getEntity();
                Log.v("ChangeTracker", "%s: got response. status: %s mode: %s", new Object[]{this, status, this.mode});
                InputStream input = null;
                if (entity == null) continue;
                try {
                    input = entity.getContent();
                    Log.v("ChangeTracker", "%s: /entity.getContent().  mode: %s", new Object[]{this, this.mode});
                    if (this.mode == ChangeTrackerMode.LongPoll) {
                        Log.v("ChangeTracker", "%s: readValue", this);
                        Map fullBody = (Map)Manager.getObjectMapper().readValue(input, Map.class);
                        Log.v("ChangeTracker", "%s: /readValue.  fullBody: %s", this, fullBody);
                        boolean responseOK = this.receivedPollResponse(fullBody);
                        Log.v("ChangeTracker", "%s: responseOK: %s", this, responseOK);
                        if (this.mode == ChangeTrackerMode.LongPoll && responseOK) {
                            if (!this.caughtUp) {
                                this.caughtUp = true;
                                this.client.changeTrackerCaughtUp();
                            }
                            Log.v("ChangeTracker", "%s: Starting new longpoll", this);
                            this.backoff.resetBackoff();
                            continue;
                        }
                        Log.w("ChangeTracker", "%s: Change tracker calling stop (LongPoll)", this);
                        this.client.changeTrackerFinished(this);
                        this.stop();
                    } else {
                        Log.v("ChangeTracker", "%s: readValue (oneshot)", this);
                        JsonFactory jsonFactory = Manager.getObjectMapper().getJsonFactory();
                        JsonParser jp = jsonFactory.createJsonParser(input);
                        while (jp.nextToken() != JsonToken.START_ARRAY) {
                        }
                        while (jp.nextToken() == JsonToken.START_OBJECT) {
                            Map change = (Map)Manager.getObjectMapper().readValue(jp, Map.class);
                            if (this.receivedChange(change)) continue;
                            Log.w("ChangeTracker", "Received unparseable change line from server: %s", change);
                        }
                        Log.v("ChangeTracker", "%s: /readValue (oneshot)", this);
                        if (!this.caughtUp) {
                            this.caughtUp = true;
                            this.client.changeTrackerCaughtUp();
                        }
                        if (this.isContinuous()) {
                            this.mode = ChangeTrackerMode.LongPoll;
                        } else {
                            Log.w("ChangeTracker", "%s: Change tracker calling stop (OneShot)", this);
                            this.client.changeTrackerFinished(this);
                            this.stopped();
                            break;
                        }
                    }
                    this.backoff.resetBackoff();
                }
                finally {
                    try {
                        entity.consumeContent();
                    }
                    catch (IOException ex) {}
                }
            }
            catch (Exception e) {
                if (this.running || !(e instanceof IOException)) {
                    Log.e("ChangeTracker", this + ": Exception in change tracker", e);
                    this.error = e;
                }
                this.backoff.sleepAppropriateAmountOfTime();
            }
        }
        Log.v("ChangeTracker", "%s: Change tracker run loop exiting", this);
    }

    public boolean receivedChange(Map<String, Object> change) {
        Object seq = change.get("seq");
        if (seq == null) {
            return false;
        }
        if (this.client != null) {
            Log.d("ChangeTracker", "%s: changeTrackerReceivedChange: %s", this, change);
            this.client.changeTrackerReceivedChange(change);
            Log.d("ChangeTracker", "%s: /changeTrackerReceivedChange: %s", this, change);
        }
        this.lastSequenceID = seq;
        return true;
    }

    public boolean receivedPollResponse(Map<String, Object> response) {
        List changes = (List)response.get("results");
        if (changes == null) {
            return false;
        }
        for (Map change : changes) {
            if (this.receivedChange(change)) continue;
            return false;
        }
        return true;
    }

    public void setUpstreamError(String message) {
        Log.w("ChangeTracker", "Server error: %s", message);
        this.error = new Throwable(message);
    }

    public boolean start() {
        Log.d("ChangeTracker", "%s: Changed tracker asked to start", this);
        this.error = null;
        String maskedRemoteWithoutCredentials = this.databaseURL.toExternalForm();
        maskedRemoteWithoutCredentials = maskedRemoteWithoutCredentials.replaceAll("://.*:.*@", "://---:---@");
        this.thread = new Thread((Runnable)this, "ChangeTracker-" + maskedRemoteWithoutCredentials);
        this.thread.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Log.d("ChangeTracker", "%s: Changed tracker asked to stop", this);
        try {
            this.running = false;
            try {
                if (this.thread != null) {
                    this.thread.interrupt();
                }
            }
            catch (Exception e) {
                Log.d("ChangeTracker", "%s: Exception interrupting thread: %s", this);
            }
            if (this.request != null) {
                Log.d("ChangeTracker", "%s: Changed tracker aborting request: %s", this, this.request);
                this.request.abort();
            }
        }
        finally {
            this.stopped();
        }
    }

    public synchronized void stopped() {
        Log.d("ChangeTracker", "%s: Change tracker in stopped()", this);
        if (this.client != null) {
            Log.w("ChangeTracker", "%s: Change tracker calling changeTrackerStopped, client: %s", this, this.client);
            this.client.changeTrackerStopped(this);
        } else {
            Log.w("ChangeTracker", "%s: Change tracker not calling changeTrackerStopped, client == null", this);
        }
        this.client = null;
    }

    public void setRequestHeaders(Map<String, Object> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    private void addRequestHeaders(HttpUriRequest request) {
        if (this.requestHeaders != null) {
            for (String requestHeaderKey : this.requestHeaders.keySet()) {
                request.addHeader(requestHeaderKey, this.requestHeaders.get(requestHeaderKey).toString());
            }
        }
    }

    public Throwable getLastError() {
        return this.error;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setDocIDs(List<String> docIDs) {
        this.docIDs = docIDs;
    }

    public String changesFeedPOSTBody() {
        Map<String, Object> postBodyMap = this.changesFeedPOSTBodyMap();
        try {
            return Manager.getObjectMapper().writeValueAsString(postBodyMap);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isUsePOST() {
        return this.usePOST;
    }

    public void setUsePOST(boolean usePOST) {
        this.usePOST = usePOST;
    }

    public Map<String, Object> changesFeedPOSTBodyMap() {
        if (!this.usePOST) {
            return null;
        }
        if (this.docIDs != null && this.docIDs.size() > 0) {
            this.filterName = "_doc_ids";
            this.filterParams = new HashMap<String, Object>();
            this.filterParams.put("doc_ids", this.docIDs);
        }
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("feed", this.getFeed());
        post.put("heartbeat", this.getHeartbeatMilliseconds());
        if (this.includeConflicts) {
            post.put("style", "all_docs");
        } else {
            post.put("style", null);
        }
        if (this.lastSequenceID != null) {
            try {
                post.put("since", Long.parseLong(this.lastSequenceID.toString()));
            }
            catch (NumberFormatException e) {
                post.put("since", this.lastSequenceID.toString());
            }
        }
        if (this.mode == ChangeTrackerMode.LongPoll && this.limit > 0) {
            post.put("limit", this.limit);
        } else {
            post.put("limit", null);
        }
        if (this.filterName != null) {
            post.put("filter", this.filterName);
            post.putAll(this.filterParams);
        }
        return post;
    }

    public static enum ChangeTrackerMode {
        OneShot,
        LongPoll,
        Continuous;

    }
}

