/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.replicator;

import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.util.Log;

@InterfaceAudience.Private
public class ChangeTrackerBackoff {
    private static int MAX_SLEEP_MILLISECONDS = 300000;
    private int numAttempts = 0;

    public void resetBackoff() {
        this.numAttempts = 0;
    }

    public int getSleepMilliseconds() {
        int result = (int)(Math.pow(this.numAttempts, 2.0) - 1.0) / 2;
        if ((result *= 100) < MAX_SLEEP_MILLISECONDS) {
            this.increaseBackoff();
        }
        result = Math.abs(result);
        return result;
    }

    public void sleepAppropriateAmountOfTime() {
        try {
            int sleepMilliseconds = this.getSleepMilliseconds();
            if (sleepMilliseconds > 0) {
                Log.d("ChangeTracker", "%s: sleeping for %d", this, sleepMilliseconds);
                Thread.sleep(sleepMilliseconds);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void increaseBackoff() {
        ++this.numAttempts;
    }

    public int getNumAttempts() {
        return this.numAttempts;
    }
}

