/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.replicator;

import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.Manager;
import com.couchbase.lite.Misc;
import com.couchbase.lite.RevisionList;
import com.couchbase.lite.Status;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.replicator.BulkDownloader;
import com.couchbase.lite.replicator.ChangeTracker;
import com.couchbase.lite.replicator.ChangeTrackerClient;
import com.couchbase.lite.replicator.PulledRevision;
import com.couchbase.lite.replicator.Replication;
import com.couchbase.lite.replicator.ReplicationInternal;
import com.couchbase.lite.replicator.ReplicationState;
import com.couchbase.lite.replicator.ReplicationTrigger;
import com.couchbase.lite.storage.SQLException;
import com.couchbase.lite.support.BatchProcessor;
import com.couchbase.lite.support.Batcher;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.support.RemoteRequestCompletionBlock;
import com.couchbase.lite.support.SequenceMap;
import com.couchbase.lite.util.CollectionUtils;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.Utils;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;

@InterfaceAudience.Private
public class PullerInternal
extends ReplicationInternal
implements ChangeTrackerClient {
    private static final int MAX_OPEN_HTTP_CONNECTIONS = 16;
    public static final int MAX_REVS_TO_GET_IN_BULK = 50;
    public static final int MAX_NUMBER_OF_ATTS_SINCE = 50;
    public static int CHANGE_TRACKER_RESTART_DELAY_MS = 10000;
    private ChangeTracker changeTracker;
    protected SequenceMap pendingSequences;
    protected Boolean canBulkGet;
    protected List<RevisionInternal> revsToPull;
    protected List<RevisionInternal> bulkRevsToPull;
    protected List<RevisionInternal> deletedRevsToPull;
    protected int httpConnectionCount;
    protected Batcher<RevisionInternal> downloadsToInsert;

    public PullerInternal(Database db, URL remote, HttpClientFactory clientFactory, ScheduledExecutorService workExecutor, Replication.Lifecycle lifecycle, Replication parentReplication) {
        super(db, remote, clientFactory, workExecutor, lifecycle, parentReplication);
    }

    @Override
    protected void beginReplicating() {
        Log.d("Sync", "startReplicating()");
        this.initPendingSequences();
        this.initDownloadsToInsert();
        this.startChangeTracker();
    }

    private void initDownloadsToInsert() {
        if (this.downloadsToInsert == null) {
            int capacity = 200;
            int delay = 1000;
            this.downloadsToInsert = new Batcher<RevisionInternal>(this.workExecutor, capacity, delay, new BatchProcessor<RevisionInternal>(){

                @Override
                public void process(List<RevisionInternal> inbox) {
                    PullerInternal.this.insertDownloads(inbox);
                }
            });
        }
    }

    @Override
    public boolean isPull() {
        return true;
    }

    @Override
    void maybeCreateRemoteDB() {
    }

    protected void startChangeTracker() {
        ChangeTracker.ChangeTrackerMode changeTrackerMode = ChangeTracker.ChangeTrackerMode.OneShot;
        Log.w("Sync", "%s: starting ChangeTracker with since=%s mode=%s", new Object[]{this, this.lastSequence, changeTrackerMode});
        this.changeTracker = new ChangeTracker(this.remote, changeTrackerMode, true, this.lastSequence, this);
        this.changeTracker.setAuthenticator(this.getAuthenticator());
        Log.w("Sync", "%s: started ChangeTracker %s", this, this.changeTracker);
        if (this.filterName != null) {
            this.changeTracker.setFilterName(this.filterName);
            if (this.filterParams != null) {
                this.changeTracker.setFilterParams(this.filterParams);
            }
        }
        this.changeTracker.setDocIDs(this.documentIDs);
        this.changeTracker.setRequestHeaders(this.requestHeaders);
        this.changeTracker.setContinuous(this.lifecycle == Replication.Lifecycle.CONTINUOUS);
        this.changeTracker.setUsePOST(this.serverIsSyncGatewayVersion("0.93"));
        this.changeTracker.start();
    }

    @Override
    @InterfaceAudience.Private
    protected void processInbox(RevisionList inbox) {
        Log.d("Sync", "processInbox called");
        if (this.canBulkGet == null) {
            this.canBulkGet = this.serverIsSyncGatewayVersion("0.81");
        }
        String lastInboxSequence = ((PulledRevision)inbox.get(inbox.size() - 1)).getRemoteSequenceID();
        int numRevisionsRemoved = 0;
        try {
            numRevisionsRemoved = this.db.findMissingRevisions(inbox);
        }
        catch (SQLException e) {
            Log.e("Sync", String.format("%s failed to look up local revs", this), e);
            inbox = null;
        }
        int inboxCount = 0;
        if (inbox != null) {
            inboxCount = inbox.size();
        }
        if (numRevisionsRemoved > 0) {
            Log.v("Sync", "%s: processInbox() setting changesCount to: %s", this, this.getChangesCount().get() - numRevisionsRemoved);
            this.addToChangesCount(-1 * numRevisionsRemoved);
        }
        if (inboxCount == 0) {
            Log.w("Sync", "%s no new remote revisions to fetch.  add lastInboxSequence (%s) to pendingSequences (%s)", this, lastInboxSequence, this.pendingSequences);
            long seq = this.pendingSequences.addValue(lastInboxSequence);
            this.pendingSequences.removeSequence(seq);
            this.setLastSequence(this.pendingSequences.getCheckpointedValue());
            return;
        }
        Log.v("Sync", "%s: fetching %s remote revisions...", this, inboxCount);
        int numBulked = 0;
        for (int i = 0; i < inbox.size(); ++i) {
            PulledRevision rev = (PulledRevision)inbox.get(i);
            if (this.canBulkGet.booleanValue() || rev.getGeneration() == 1 && !rev.isDeleted()) {
                if (this.bulkRevsToPull == null) {
                    this.bulkRevsToPull = new ArrayList<RevisionInternal>(100);
                }
                this.bulkRevsToPull.add(rev);
                ++numBulked;
            } else {
                this.queueRemoteRevision(rev);
            }
            rev.setSequence(this.pendingSequences.addValue(rev.getRemoteSequenceID()));
        }
        this.pullRemoteRevisions();
    }

    @InterfaceAudience.Private
    public void pullRemoteRevisions() {
        ArrayList<RevisionInternal> workToStartNow = new ArrayList<RevisionInternal>();
        ArrayList<RevisionInternal> bulkWorkToStartNow = new ArrayList<RevisionInternal>();
        while (this.httpConnectionCount + workToStartNow.size() < 16) {
            int nBulk = 0;
            if (this.bulkRevsToPull != null) {
                int n = nBulk = this.bulkRevsToPull.size() < 50 ? this.bulkRevsToPull.size() : 50;
            }
            if (nBulk == 1) {
                this.queueRemoteRevision(this.bulkRevsToPull.get(0));
                this.bulkRevsToPull.remove(0);
                nBulk = 0;
            }
            if (nBulk > 0) {
                bulkWorkToStartNow.addAll(this.bulkRevsToPull.subList(0, nBulk));
                this.bulkRevsToPull.subList(0, nBulk).clear();
                continue;
            }
            List<RevisionInternal> queue = this.revsToPull;
            if (!(queue != null && queue.size() != 0 || (queue = this.deletedRevsToPull) != null && queue.size() != 0)) break;
            workToStartNow.add(queue.get(0));
            queue.remove(0);
        }
        if (bulkWorkToStartNow.size() > 0) {
            this.pullBulkRevisions(bulkWorkToStartNow);
        }
        for (RevisionInternal work : workToStartNow) {
            this.pullRemoteRevision(work);
        }
    }

    protected void pullBulkRevisions(List<RevisionInternal> bulkRevs) {
        BulkDownloader dl;
        int nRevs = bulkRevs.size();
        if (nRevs == 0) {
            return;
        }
        Log.v("Sync", "%s bulk-fetching %d remote revisions...", this, nRevs);
        Log.v("Sync", "%s bulk-fetching remote revisions: %s", this, bulkRevs);
        if (!this.canBulkGet.booleanValue()) {
            this.pullBulkWithAllDocs(bulkRevs);
            return;
        }
        Log.v("Sync", "%s: POST _bulk_get", this);
        final ArrayList<RevisionInternal> remainingRevs = new ArrayList<RevisionInternal>(bulkRevs);
        ++this.httpConnectionCount;
        try {
            dl = new BulkDownloader(this.workExecutor, this.clientFactory, this.remote, bulkRevs, this.db, this.requestHeaders, new BulkDownloader.BulkDownloaderDocumentBlock(){

                @Override
                public void onDocument(Map<String, Object> props) {
                    RevisionInternal rev = props.get("_id") != null ? new RevisionInternal(props, PullerInternal.this.db) : new RevisionInternal((String)props.get("id"), (String)props.get("rev"), false, PullerInternal.this.db);
                    int pos = remainingRevs.indexOf(rev);
                    if (pos > -1) {
                        rev.setSequence(((RevisionInternal)remainingRevs.get(pos)).getSequence());
                        remainingRevs.remove(pos);
                    } else {
                        Log.w("Sync", "%s : Received unexpected rev rev", this);
                    }
                    if (props.get("_id") != null) {
                        PullerInternal.this.queueDownloadedRevision(rev);
                    } else {
                        Status status = ReplicationInternal.statusFromBulkDocsResponseItem(props);
                        PullerInternal.this.error = new CouchbaseLiteException(status);
                        PullerInternal.this.revisionFailed(rev, PullerInternal.this.error);
                    }
                }
            }, new RemoteRequestCompletionBlock(){

                @Override
                public void onCompletion(HttpResponse httpResponse, Object result, Throwable e) {
                    if (e != null) {
                        PullerInternal.this.setError(e);
                        PullerInternal.this.revisionFailed();
                        PullerInternal.this.completedChangesCount.addAndGet(remainingRevs.size());
                    }
                    --PullerInternal.this.httpConnectionCount;
                    PullerInternal.this.pullRemoteRevisions();
                }
            });
        }
        catch (Exception e) {
            Log.e("Sync", "%s: pullBulkRevisions Exception: %s", this, e);
            return;
        }
        dl.setAuthenticator(this.getAuthenticator());
        Future<?> future = this.remoteRequestExecutor.submit(dl);
        this.pendingFutures.add(future);
    }

    private void queueDownloadedRevision(RevisionInternal rev) {
        if (this.revisionBodyTransformationBlock != null) {
            for (Map.Entry entry : ((Map)rev.getProperties().get("_attachments")).entrySet()) {
                String filePath;
                String name = (String)entry.getKey();
                Map attachment = (Map)entry.getValue();
                attachment.remove("file");
                if (attachment.get("follows") == null || attachment.get("data") != null || (filePath = this.db.fileForAttachmentDict(attachment).getPath()) == null) continue;
                attachment.put("file", filePath);
            }
            RevisionInternal xformed = this.transformRevision(rev);
            if (xformed == null) {
                Log.v("Sync", "%s: Transformer rejected revision %s", this, rev);
                this.pendingSequences.removeSequence(rev.getSequence());
                this.lastSequence = this.pendingSequences.getCheckpointedValue();
                return;
            }
            rev = xformed;
            Map attachments = (Map)rev.getProperties().get("_attachments");
            for (Map.Entry entry : ((Map)rev.getProperties().get("_attachments")).entrySet()) {
                Map attachment = (Map)entry.getValue();
                attachment.remove("file");
            }
        }
        this.downloadsToInsert.queueObject(rev);
    }

    protected void pullBulkWithAllDocs(final List<RevisionInternal> bulkRevs) {
        ++this.httpConnectionCount;
        final RevisionList remainingRevs = new RevisionList(bulkRevs);
        Collection<String> keys = CollectionUtils.transform(bulkRevs, new CollectionUtils.Functor<RevisionInternal, String>(){

            @Override
            public String invoke(RevisionInternal rev) {
                return rev.getDocId();
            }
        });
        HashMap<String, Collection<String>> body = new HashMap<String, Collection<String>>();
        body.put("keys", keys);
        Future future = this.sendAsyncRequest("POST", "/_all_docs?include_docs=true", body, new RemoteRequestCompletionBlock(){

            @Override
            public void onCompletion(HttpResponse httpResponse, Object result, Throwable e) {
                Map res = (Map)result;
                if (e != null) {
                    PullerInternal.this.setError(e);
                    PullerInternal.this.revisionFailed();
                } else {
                    List rows = (List)res.get("rows");
                    Log.v("Sync", "%s checking %d bulk-fetched remote revisions", this, rows.size());
                    for (Map row : rows) {
                        RevisionInternal rev;
                        Map doc = (Map)row.get("doc");
                        if (doc != null && doc.get("_attachments") == null) {
                            RevisionInternal rev2 = new RevisionInternal(doc, PullerInternal.this.db);
                            RevisionInternal removedRev = remainingRevs.removeAndReturnRev(rev2);
                            if (removedRev == null) continue;
                            rev2.setSequence(removedRev.getSequence());
                            PullerInternal.this.queueDownloadedRevision(rev2);
                            continue;
                        }
                        Status status = ReplicationInternal.statusFromBulkDocsResponseItem(row);
                        if (!status.isError() || !row.containsKey("key") || row.get("key") == null || (rev = remainingRevs.revWithDocId((String)row.get("key"))) == null) continue;
                        remainingRevs.remove(rev);
                        PullerInternal.this.revisionFailed(rev, new CouchbaseLiteException(status));
                    }
                }
                if (remainingRevs.size() > 0) {
                    Log.v("Sync", "%s bulk-fetch didn't work for %d of %d revs; getting individually", this, remainingRevs.size(), bulkRevs.size());
                    for (RevisionInternal rev : remainingRevs) {
                        PullerInternal.this.queueRemoteRevision(rev);
                    }
                    PullerInternal.this.pullRemoteRevisions();
                }
                --PullerInternal.this.httpConnectionCount;
                PullerInternal.this.pullRemoteRevisions();
            }
        });
        this.pendingFutures.add(future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public void insertDownloads(List<RevisionInternal> downloads) {
        Log.i("Sync", this + " inserting " + downloads.size() + " revisions...");
        long time = System.currentTimeMillis();
        Collections.sort(downloads, this.getRevisionListComparator());
        this.db.beginTransaction();
        boolean success = false;
        try {
            for (RevisionInternal rev : downloads) {
                long fakeSequence = rev.getSequence();
                List<String> history = Database.parseCouchDBRevisionHistory(rev.getProperties());
                if (history.isEmpty() && rev.getGeneration() > 1) {
                    Log.w("Sync", "%s: Missing revision history in response for: %s", this, rev);
                    this.setError(new CouchbaseLiteException(589));
                    this.revisionFailed();
                    continue;
                }
                Log.v("Sync", "%s: inserting %s %s", this, rev.getDocId(), history);
                try {
                    this.db.forceInsert(rev, history, this.remote);
                }
                catch (CouchbaseLiteException e) {
                    if (e.getCBLStatus().getCode() == 403) {
                        Log.i("Sync", "%s: Remote rev failed validation: %s", this, rev);
                    }
                    Log.w("Sync", "%s: failed to write %s: status=%s", this, rev, e.getCBLStatus().getCode());
                    this.revisionFailed();
                    this.setError((Throwable)new HttpResponseException(e.getCBLStatus().getCode(), null));
                    continue;
                }
                this.pendingSequences.removeSequence(fakeSequence);
            }
            Log.v("Sync", "%s: finished inserting %d revisions", this, downloads.size());
            success = true;
        }
        catch (SQLException e) {
            try {
                Log.e("Sync", this + ": Exception inserting revisions", e);
                this.db.endTransaction(success);
            }
            catch (Throwable throwable) {
                this.db.endTransaction(success);
                if (success) {
                    this.setLastSequence(this.pendingSequences.getCheckpointedValue());
                    long delta = System.currentTimeMillis() - time;
                    Log.v("Sync", "%s: inserted %d revs in %d milliseconds", this, downloads.size(), delta);
                    int newCompletedChangesCount = this.getCompletedChangesCount().get() + downloads.size();
                    Log.d("Sync", "%s insertDownloads() updating completedChangesCount from %d -> %d ", this, this.getCompletedChangesCount().get(), newCompletedChangesCount);
                    this.addToCompletedChangesCount(downloads.size());
                }
                throw throwable;
            }
            if (success) {
                this.setLastSequence(this.pendingSequences.getCheckpointedValue());
                long delta = System.currentTimeMillis() - time;
                Log.v("Sync", "%s: inserted %d revs in %d milliseconds", this, downloads.size(), delta);
                int newCompletedChangesCount = this.getCompletedChangesCount().get() + downloads.size();
                Log.d("Sync", "%s insertDownloads() updating completedChangesCount from %d -> %d ", this, this.getCompletedChangesCount().get(), newCompletedChangesCount);
                this.addToCompletedChangesCount(downloads.size());
            }
        }
        this.db.endTransaction(success);
        if (success) {
            this.setLastSequence(this.pendingSequences.getCheckpointedValue());
            long delta = System.currentTimeMillis() - time;
            Log.v("Sync", "%s: inserted %d revs in %d milliseconds", this, downloads.size(), delta);
            int newCompletedChangesCount = this.getCompletedChangesCount().get() + downloads.size();
            Log.d("Sync", "%s insertDownloads() updating completedChangesCount from %d -> %d ", this, this.getCompletedChangesCount().get(), newCompletedChangesCount);
            this.addToCompletedChangesCount(downloads.size());
        }
    }

    @InterfaceAudience.Private
    private Comparator<RevisionInternal> getRevisionListComparator() {
        return new Comparator<RevisionInternal>(){

            @Override
            public int compare(RevisionInternal reva, RevisionInternal revb) {
                return Misc.TDSequenceCompare(reva.getSequence(), revb.getSequence());
            }
        };
    }

    private void revisionFailed(RevisionInternal rev, Throwable throwable) {
        if (Utils.isTransientError(throwable)) {
            this.revisionFailed();
        } else {
            Log.v("Sync", "%s: giving up on %s: %s", this, rev, throwable);
            this.pendingSequences.removeSequence(rev.getSequence());
        }
        this.completedChangesCount.getAndIncrement();
    }

    @InterfaceAudience.Private
    public void pullRemoteRevision(final RevisionInternal rev) {
        Log.d("Sync", "%s: pullRemoteRevision with rev: %s", this, rev);
        ++this.httpConnectionCount;
        StringBuilder path = new StringBuilder("/" + URLEncoder.encode(rev.getDocId()) + "?rev=" + URLEncoder.encode(rev.getRevId()) + "&revs=true&attachments=true");
        List<String> knownRevs = this.knownCurrentRevIDs(rev);
        if (knownRevs == null) {
            Log.w("Sync", "knownRevs == null, something is wrong, possibly the replicator has shut down");
            --this.httpConnectionCount;
            return;
        }
        if (knownRevs.size() > 0) {
            path.append("&atts_since=");
            path.append(this.joinQuotedEscaped(knownRevs));
        }
        String pathInside = path.toString();
        Future future = this.sendAsyncMultipartDownloaderRequest("GET", pathInside, null, this.db, new RemoteRequestCompletionBlock(){

            @Override
            public void onCompletion(HttpResponse httpResponse, Object result, Throwable e) {
                if (e != null) {
                    Log.e("Sync", "Error pulling remote revision", e);
                    PullerInternal.this.revisionFailed(rev, e);
                } else {
                    Map properties = (Map)result;
                    PulledRevision gotRev = new PulledRevision(properties, PullerInternal.this.db);
                    gotRev.setSequence(rev.getSequence());
                    Log.d("Sync", "%s: pullRemoteRevision add rev: %s to batcher: %s", PullerInternal.this, gotRev, PullerInternal.this.downloadsToInsert);
                    PullerInternal.this.downloadsToInsert.queueObject(gotRev);
                }
                --PullerInternal.this.httpConnectionCount;
                PullerInternal.this.pullRemoteRevisions();
            }
        });
        this.pendingFutures.add(future);
    }

    @InterfaceAudience.Private
    public String joinQuotedEscaped(List<String> strings) {
        if (strings.size() == 0) {
            return "[]";
        }
        byte[] json = null;
        try {
            json = Manager.getObjectMapper().writeValueAsBytes(strings);
        }
        catch (Exception e) {
            Log.w("Sync", "Unable to serialize json", e);
        }
        return URLEncoder.encode(new String(json));
    }

    @InterfaceAudience.Private
    List<String> knownCurrentRevIDs(RevisionInternal rev) {
        if (this.db != null) {
            return this.db.getAllRevisionsOfDocumentID(rev.getDocId(), true).getAllRevIds();
        }
        return null;
    }

    @InterfaceAudience.Private
    protected void queueRemoteRevision(RevisionInternal rev) {
        if (rev.isDeleted()) {
            if (this.deletedRevsToPull == null) {
                this.deletedRevsToPull = new ArrayList<RevisionInternal>(100);
            }
            this.deletedRevsToPull.add(rev);
        } else {
            if (this.revsToPull == null) {
                this.revsToPull = new ArrayList<RevisionInternal>(100);
            }
            this.revsToPull.add(rev);
        }
    }

    private void initPendingSequences() {
        if (this.pendingSequences == null) {
            this.pendingSequences = new SequenceMap();
            if (this.getLastSequence() != null) {
                long seq = this.pendingSequences.addValue(this.getLastSequence());
                this.pendingSequences.removeSequence(seq);
                assert (this.pendingSequences.getCheckpointedValue().equals(this.getLastSequence()));
            }
        }
    }

    @InterfaceAudience.Private
    public String getLastSequence() {
        return this.lastSequence;
    }

    @Override
    public HttpClient getHttpClient() {
        HttpClient httpClient = this.clientFactory.getHttpClient();
        return httpClient;
    }

    @Override
    public void changeTrackerReceivedChange(final Map<String, Object> change) {
        this.workExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Log.d("Sync", "changeTrackerReceivedChange: %s", change);
                    PullerInternal.this.processChangeTrackerChange(change);
                }
                catch (Exception e) {
                    Log.e("Sync", "Error processChangeTrackerChange(): %s", e);
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        });
    }

    protected void processChangeTrackerChange(Map<String, Object> change) {
        String lastSequence = change.get("seq").toString();
        String docID = (String)change.get("id");
        if (docID == null) {
            return;
        }
        if (!Database.isValidDocumentId(docID)) {
            Log.w("Sync", "%s: Received invalid doc ID from _changes: %s", this, change);
            return;
        }
        boolean deleted = change.containsKey("deleted") && ((Boolean)change.get("deleted")).equals(Boolean.TRUE);
        List changes = (List)change.get("changes");
        for (Map changeDict : changes) {
            String revID = (String)changeDict.get("rev");
            if (revID == null) continue;
            PulledRevision rev = new PulledRevision(docID, revID, deleted, this.db);
            rev.setRemoteSequenceID(lastSequence);
            Log.d("Sync", "%s: adding rev to inbox %s", this, rev);
            Log.v("Sync", "%s: changeTrackerReceivedChange() incrementing changesCount by 1", this);
            this.addToChangesCount(1);
            this.addToInbox(rev);
        }
    }

    @Override
    public void changeTrackerStopped(ChangeTracker tracker) {
        this.workExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    PullerInternal.this.processChangeTrackerStopped(PullerInternal.this.changeTracker);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        });
    }

    private void processChangeTrackerStopped(ChangeTracker tracker) {
        Log.d("Sync", "changeTrackerStopped.  lifecycle: %s", new Object[]{this.lifecycle});
        switch (this.lifecycle) {
            case ONESHOT: {
                Log.d("Sync", "fire STOP_GRACEFUL");
                if (tracker.getLastError() != null) {
                    this.setError(tracker.getLastError());
                }
                this.stateMachine.fire((Object)ReplicationTrigger.STOP_GRACEFUL);
                break;
            }
            case CONTINUOUS: {
                if (this.stateMachine.isInState((Object)ReplicationState.OFFLINE)) {
                    Log.d("Sync", "Change tracker stopped because we are going offline");
                    break;
                }
                String msg = String.format("Change tracker stopped during continuous replication", new Object[0]);
                Log.e("Sync", msg);
                this.parentReplication.setLastError(new Exception(msg));
                this.fireTrigger(ReplicationTrigger.WAITING_FOR_CHANGES);
                Log.d("Sync", "Scheduling change tracker restart in %d ms", CHANGE_TRACKER_RESTART_DELAY_MS);
                this.workExecutor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (PullerInternal.this.stateMachine.isInState((Object)ReplicationState.RUNNING)) {
                            Log.d("Sync", "%s still running, restarting change tracker", this);
                            PullerInternal.this.startChangeTracker();
                        } else {
                            Log.d("Sync", "%s still no longer running, not restarting change tracker", this);
                        }
                    }
                }, (long)CHANGE_TRACKER_RESTART_DELAY_MS, TimeUnit.MILLISECONDS);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unknown lifecycle: %s", new Object[]{this.lifecycle}));
            }
        }
    }

    @Override
    public void changeTrackerFinished(ChangeTracker tracker) {
        this.workExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Log.d("Sync", "changeTrackerFinished");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public void changeTrackerCaughtUp() {
        this.workExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Log.d("Sync", "changeTrackerCaughtUp");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        });
        if (this.isContinuous()) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (PullerInternal.this.batcher != null) {
                            Log.d("Sync", "batcher.waitForPendingFutures()");
                            PullerInternal.this.batcher.waitForPendingFutures();
                        }
                        Log.d("Sync", "waitForPendingFutures()");
                        PullerInternal.this.waitForPendingFutures();
                        if (PullerInternal.this.downloadsToInsert != null) {
                            Log.d("Sync", "downloadsToInsert.waitForPendingFutures()");
                            PullerInternal.this.downloadsToInsert.waitForPendingFutures();
                        }
                    }
                    catch (Exception e) {
                        Log.e("Sync", "Exception waiting for jobs to drain: %s", e);
                        e.printStackTrace();
                    }
                    finally {
                        PullerInternal.this.fireTrigger(ReplicationTrigger.WAITING_FOR_CHANGES);
                    }
                    Log.e("Sync", "PullerInternal stopGraceful.run() finished");
                }
            }).start();
        }
    }

    @Override
    protected void stopGraceful() {
        super.stopGraceful();
        Log.d("Sync", "PullerInternal stopGraceful()");
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (PullerInternal.this.batcher != null) {
                        Log.d("Sync", "batcher.waitForPendingFutures()");
                        PullerInternal.this.batcher.waitForPendingFutures();
                    }
                    Log.d("Sync", "waitForPendingFutures()");
                    PullerInternal.this.waitForPendingFutures();
                    if (PullerInternal.this.downloadsToInsert != null) {
                        Log.d("Sync", "downloadsToInsert.waitForPendingFutures()");
                        PullerInternal.this.downloadsToInsert.waitForPendingFutures();
                    }
                    if (PullerInternal.this.changeTracker != null) {
                        Log.d("Sync", "stopping change tracker");
                        PullerInternal.this.changeTracker.stop();
                        Log.d("Sync", "stopped change tracker");
                    }
                }
                catch (Exception e) {
                    Log.e("Sync", "stopGraceful.run() had exception: %s", e);
                    e.printStackTrace();
                }
                finally {
                    PullerInternal.this.triggerStopImmediate();
                }
                Log.e("Sync", "PullerInternal stopGraceful.run() finished");
            }
        }).start();
    }

    public void waitForPendingFutures() {
        block5: while (true) {
            try {
                while (!this.pendingFutures.isEmpty()) {
                    Future future = (Future)this.pendingFutures.take();
                    try {
                        Log.d("Sync", "calling future.get() on %s", future);
                        future.get();
                        Log.d("Sync", "done calling future.get() on %s", future);
                        continue block5;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
                break;
            }
            catch (Exception e) {
                Log.e("Sync", "Exception waiting for pending futures: %s", e);
                break;
            }
        }
    }

    @Override
    public boolean shouldCreateTarget() {
        return false;
    }

    @Override
    public void setCreateTarget(boolean createTarget) {
    }

    @Override
    protected void goOffline() {
        super.goOffline();
        if (this.changeTracker != null) {
            this.changeTracker.stop();
        }
    }

    @Override
    protected void goOnline() {
        super.goOnline();
        this.beginReplicating();
    }
}

