/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.router;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

class Header {
    private ArrayList<String> props = new ArrayList(20);
    private SortedMap<String, LinkedList<String>> keyTable = new TreeMap<String, LinkedList<String>>(String.CASE_INSENSITIVE_ORDER);

    public Header() {
    }

    public Header(Map<String, List<String>> map) {
        this();
        for (Map.Entry<String, List<String>> next : map.entrySet()) {
            String key = next.getKey();
            List<String> value = next.getValue();
            LinkedList<String> linkedList = new LinkedList<String>();
            for (String element : value) {
                linkedList.add(element);
                this.props.add(key);
                this.props.add(element);
            }
            this.keyTable.put(key, linkedList);
        }
    }

    public void add(String key, String value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return;
        }
        LinkedList<String> list = (LinkedList<String>)this.keyTable.get(key);
        if (list == null) {
            list = new LinkedList<String>();
            this.keyTable.put(key, list);
        }
        list.add(value);
        this.props.add(key);
        this.props.add(value);
    }

    public void removeAll(String key) {
        this.keyTable.remove(key);
        for (int i = 0; i < this.props.size(); i += 2) {
            if (!key.equals(this.props.get(i))) continue;
            this.props.remove(i);
            this.props.remove(i);
        }
    }

    public void addAll(String key, List<String> headers) {
        for (String header : headers) {
            this.add(key, header);
        }
    }

    public void addIfAbsent(String key, String value) {
        if (this.get(key) == null) {
            this.add(key, value);
        }
    }

    public void set(String key, String value) {
        this.removeAll(key);
        this.add(key, value);
    }

    public Map<String, List<String>> getFieldMap() {
        TreeMap result = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, LinkedList<String>> next : this.keyTable.entrySet()) {
            List v = next.getValue();
            result.put(next.getKey(), Collections.unmodifiableList(v));
        }
        return Collections.unmodifiableMap(result);
    }

    public String get(int pos) {
        if (pos >= 0 && pos < this.props.size() / 2) {
            return this.props.get(pos * 2 + 1);
        }
        return null;
    }

    public String getKey(int pos) {
        if (pos >= 0 && pos < this.props.size() / 2) {
            return this.props.get(pos * 2);
        }
        return null;
    }

    public String get(String key) {
        LinkedList result = (LinkedList)this.keyTable.get(key);
        if (result == null) {
            return null;
        }
        return (String)result.getLast();
    }

    public int length() {
        return this.props.size() / 2;
    }
}

