/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.storage;

import com.couchbase.lite.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class ContentValues {
    public static final String TAG = "ContentValues";
    private HashMap<String, Object> mValues;

    public ContentValues() {
        this.mValues = new HashMap(8);
    }

    public ContentValues(int size) {
        this.mValues = new HashMap(size, 1.0f);
    }

    public ContentValues(ContentValues from) {
        this.mValues = new HashMap<String, Object>(from.mValues);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ContentValues)) {
            return false;
        }
        return this.mValues.equals(((ContentValues)object).mValues);
    }

    public int hashCode() {
        return this.mValues.hashCode();
    }

    public void put(String key, String value) {
        this.mValues.put(key, value);
    }

    public void putAll(ContentValues other) {
        this.mValues.putAll(other.mValues);
    }

    public void put(String key, Byte value) {
        this.mValues.put(key, value);
    }

    public void put(String key, Short value) {
        this.mValues.put(key, value);
    }

    public void put(String key, Integer value) {
        this.mValues.put(key, value);
    }

    public void put(String key, Long value) {
        this.mValues.put(key, value);
    }

    public void put(String key, Float value) {
        this.mValues.put(key, value);
    }

    public void put(String key, Double value) {
        this.mValues.put(key, value);
    }

    public void put(String key, Boolean value) {
        this.mValues.put(key, value);
    }

    public void put(String key, byte[] value) {
        this.mValues.put(key, value);
    }

    public void putNull(String key) {
        this.mValues.put(key, null);
    }

    public int size() {
        return this.mValues.size();
    }

    public void remove(String key) {
        this.mValues.remove(key);
    }

    public void clear() {
        this.mValues.clear();
    }

    public boolean containsKey(String key) {
        return this.mValues.containsKey(key);
    }

    public Object get(String key) {
        return this.mValues.get(key);
    }

    public String getAsString(String key) {
        Object value = this.mValues.get(key);
        return value != null ? value.toString() : null;
    }

    public Long getAsLong(String key) {
        Object value = this.mValues.get(key);
        try {
            return value != null ? Long.valueOf(((Number)value).longValue()) : null;
        }
        catch (ClassCastException e) {
            if (value instanceof CharSequence) {
                try {
                    return Long.valueOf(value.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e(TAG, "Cannot parse Long value for %s at key %s", value, key);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for %s to a Long: %s", e, key, value);
            return null;
        }
    }

    public Integer getAsInteger(String key) {
        Object value = this.mValues.get(key);
        try {
            return value != null ? Integer.valueOf(((Number)value).intValue()) : null;
        }
        catch (ClassCastException e) {
            if (value instanceof CharSequence) {
                try {
                    return Integer.valueOf(value.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e(TAG, "Cannot parse Integer value for %s at key %s", value, key);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for %s to a Integer: %s", e, key, value);
            return null;
        }
    }

    public Short getAsShort(String key) {
        Object value = this.mValues.get(key);
        try {
            return value != null ? Short.valueOf(((Number)value).shortValue()) : null;
        }
        catch (ClassCastException e) {
            if (value instanceof CharSequence) {
                try {
                    return Short.valueOf(value.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e(TAG, "Cannot parse Short value for %s at key %s", value, key);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for %s to a Short: %s", e, key, value);
            return null;
        }
    }

    public Byte getAsByte(String key) {
        Object value = this.mValues.get(key);
        try {
            return value != null ? Byte.valueOf(((Number)value).byteValue()) : null;
        }
        catch (ClassCastException e) {
            if (value instanceof CharSequence) {
                try {
                    return Byte.valueOf(value.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e(TAG, "Cannot parse Byte value for %s at key %s", value, key);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for %s to a Byte: %s", e, key, value);
            return null;
        }
    }

    public Double getAsDouble(String key) {
        Object value = this.mValues.get(key);
        try {
            return value != null ? Double.valueOf(((Number)value).doubleValue()) : null;
        }
        catch (ClassCastException e) {
            if (value instanceof CharSequence) {
                try {
                    return Double.valueOf(value.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e(TAG, "Cannot parse Double value for %s at key %s", value, key);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for %s to a Double: %s", e, key, value);
            return null;
        }
    }

    public Float getAsFloat(String key) {
        Object value = this.mValues.get(key);
        try {
            return value != null ? Float.valueOf(((Number)value).floatValue()) : null;
        }
        catch (ClassCastException e) {
            if (value instanceof CharSequence) {
                try {
                    return Float.valueOf(value.toString());
                }
                catch (NumberFormatException e2) {
                    Log.e(TAG, "Cannot parse Float value for %s at key %s", value, key);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for %s to a Float: %s", e, key, value);
            return null;
        }
    }

    public Boolean getAsBoolean(String key) {
        Object value = this.mValues.get(key);
        try {
            return (Boolean)value;
        }
        catch (ClassCastException e) {
            if (value instanceof CharSequence) {
                return Boolean.valueOf(value.toString());
            }
            if (value instanceof Number) {
                return ((Number)value).intValue() != 0;
            }
            Log.e(TAG, "Cannot cast value for " + key + " to a Boolean: " + value, e);
            return null;
        }
    }

    public byte[] getAsByteArray(String key) {
        Object value = this.mValues.get(key);
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        return null;
    }

    public Set<Map.Entry<String, Object>> valueSet() {
        return this.mValues.entrySet();
    }

    public Set<String> keySet() {
        return this.mValues.keySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String name : this.mValues.keySet()) {
            String value = this.getAsString(name);
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(name + "=" + value);
        }
        return sb.toString();
    }
}

