/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

import com.couchbase.lite.support.BatchProcessor;
import com.couchbase.lite.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Batcher<T> {
    private ScheduledExecutorService workExecutor;
    private int capacity;
    private int delayMs;
    private int scheduledDelay;
    private BlockingQueue<T> inbox;
    private BatchProcessor<T> processor;
    private boolean scheduled = false;
    private long lastProcessedTime;
    private BlockingQueue<ScheduledFuture> pendingFutures;
    private Lock lock = new ReentrantLock();
    private Runnable processNowRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Batcher.this.lock.lock();
                Batcher.this.processNow();
            }
            catch (Exception e) {
                Log.e("Batcher", this + ": BatchProcessor throw exception", e);
            }
            finally {
                Batcher.this.lock.unlock();
            }
        }
    };

    public Batcher(ScheduledExecutorService workExecutor, int capacity, int delayMs, BatchProcessor<T> processor) {
        this.workExecutor = workExecutor;
        this.capacity = capacity;
        this.delayMs = delayMs;
        this.processor = processor;
        this.inbox = new LinkedBlockingQueue<T>();
        this.pendingFutures = new LinkedBlockingQueue<ScheduledFuture>();
    }

    private boolean isCurrentlyProcessing() {
        boolean processingNotInProgress = this.lock.tryLock();
        if (processingNotInProgress) {
            this.lock.unlock();
        }
        boolean isProcessing = !processingNotInProgress;
        return isProcessing;
    }

    public void queueObjects(List<T> objects) {
        Log.v("Batcher", "%s: queueObjects called with %d objects. Thread: %s", this, objects.size(), Thread.currentThread());
        if (objects.size() == 0) {
            return;
        }
        Log.v("Batcher", "%s: inbox size before adding objects: %d", this, this.inbox.size());
        this.inbox.addAll(objects);
        if (this.inbox.size() >= this.capacity) {
            Log.v("Batcher", "%s: calling scheduleWithDelay(0)", this);
            if (!this.isCurrentlyProcessing()) {
                this.unscheduleAllPending();
                this.scheduleWithDelay(0);
            }
        } else {
            int suggestedDelay = this.delayToUse();
            Log.v("Batcher", "%s: calling scheduleWithDelay(%d)", this, suggestedDelay);
            this.scheduleWithDelay(suggestedDelay);
        }
    }

    public void waitForPendingFutures() {
        Log.d("Batcher", "%s: waitForPendingFutures", this);
        block5: while (true) {
            try {
                while (!this.pendingFutures.isEmpty()) {
                    Future future = this.pendingFutures.take();
                    try {
                        Log.d("Batcher", "calling future.get() on %s", future);
                        future.get();
                        Log.d("Batcher", "done calling future.get() on %s", future);
                        continue block5;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
                break;
            }
            catch (Exception e) {
                Log.e("Batcher", "Exception waiting for pending futures: %s", e);
                break;
            }
        }
        Log.d("Batcher", "%s: /waitForPendingFutures", this);
    }

    public void queueObject(T object) {
        List<Object> objects = Arrays.asList(object);
        this.queueObjects(objects);
    }

    public void flush() {
        this.scheduleWithDelay(this.delayToUse());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() {
        Batcher batcher = this;
        synchronized (batcher) {
            if (this.inbox == null) {
                return 0;
            }
            return this.inbox.size();
        }
    }

    private void processNow() {
        Log.v("Batcher", this + ": processNow() called");
        this.scheduled = false;
        ArrayList<T> toProcess = new ArrayList<T>();
        if (this.inbox == null || this.inbox.size() == 0) {
            Log.v("Batcher", this + ": processNow() called, but inbox is empty");
            return;
        }
        if (this.inbox.size() <= this.capacity) {
            Log.v("Batcher", "%s: inbox.size() <= capacity, adding %d items from inbox -> toProcess", this, this.inbox.size());
            while (this.inbox.size() > 0) {
                try {
                    T t = this.inbox.take();
                    toProcess.add(t);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else {
            Log.v("Batcher", "%s: processNow() called, inbox size: %d", this, this.inbox.size());
            for (int i = 0; this.inbox.size() > 0 && i < this.capacity; ++i) {
                try {
                    T t = this.inbox.take();
                    toProcess.add(t);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Log.v("Batcher", "%s: inbox.size() > capacity, moving %d items from inbox -> toProcess array", this, toProcess.size());
        }
        if (toProcess != null && toProcess.size() > 0) {
            Log.v("Batcher", "%s: invoking processor %s with %d items ", this, this.processor, toProcess.size());
            this.processor.process(toProcess);
        } else {
            Log.v("Batcher", "%s: nothing to process", this);
        }
        this.lastProcessedTime = System.currentTimeMillis();
        if (this.inbox.size() > 0) {
            Log.v("Batcher", "%s: finished processing a batch, but inbox size > 0: %d", this, this.inbox.size());
            int delayToUse = this.delayToUse();
            Log.v("Batcher", "%s: going to process with delay: %d", this, delayToUse);
            ScheduledFuture<?> pendingFuture = this.workExecutor.schedule(this.processNowRunnable, (long)delayToUse, TimeUnit.MILLISECONDS);
            this.pendingFutures.add(pendingFuture);
        }
    }

    private void scheduleWithDelay(int suggestedDelay) {
        ArrayList<ScheduledFuture> futuresToForget = new ArrayList<ScheduledFuture>();
        for (ScheduledFuture scheduledFuture : this.pendingFutures) {
            if (scheduledFuture != null && !scheduledFuture.isCancelled() && !scheduledFuture.isDone()) {
                Log.v("Batcher", "%s: scheduleWithDelay already has a pending task: %s. ignoring.", this, scheduledFuture);
                return;
            }
            futuresToForget.add(scheduledFuture);
        }
        this.forgetExpiredFutures(futuresToForget);
        Log.v("Batcher", "%s: scheduleWithDelay called with delayMs: %d ms", this, suggestedDelay);
        this.scheduledDelay = suggestedDelay;
        Log.v("Batcher", "workExecutor.schedule() with delayMs: %d ms", suggestedDelay);
        ScheduledFuture<?> scheduledFuture = this.workExecutor.schedule(this.processNowRunnable, (long)suggestedDelay, TimeUnit.MILLISECONDS);
        Log.v("Batcher", "%s: created future: %s", this, scheduledFuture);
        this.pendingFutures.add(scheduledFuture);
    }

    private void forgetExpiredFutures(List<ScheduledFuture> futuresToForget) {
        for (ScheduledFuture futureToForget : futuresToForget) {
            Log.v("Batcher", "%s: forgetting about expired future: %s", this, futureToForget);
            this.pendingFutures.remove(futureToForget);
        }
    }

    private void unscheduleAllPending() {
        ArrayList<ScheduledFuture> futuresToForget = new ArrayList<ScheduledFuture>();
        for (ScheduledFuture pendingFuture : this.pendingFutures) {
            pendingFuture.cancel(true);
            futuresToForget.add(pendingFuture);
        }
        this.forgetExpiredFutures(futuresToForget);
    }

    private int delayToUse() {
        int delayToUse = this.delayMs;
        if (this.lastProcessedTime > 0L) {
            long delta = System.currentTimeMillis() - this.lastProcessedTime;
            if (delta >= (long)this.delayMs) {
                delayToUse = 0;
            }
            Log.v("Batcher", "%s: delayToUse() delta: %d, delayToUse: %d, delayMs: %d", this, delta, delayToUse, this.delayMs);
        }
        return delayToUse;
    }
}

