/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

class KMPMatch {
    KMPMatch() {
    }

    public int indexOf(byte[] data, byte[] pattern, int dataOffset) {
        int[] failure = this.computeFailure(pattern);
        int j = 0;
        if (data.length == 0) {
            return -1;
        }
        int dataLength = data.length;
        int patternLength = pattern.length;
        for (int i = dataOffset; i < dataLength; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != patternLength) continue;
            return i - patternLength + 1;
        }
        return -1;
    }

    private int[] computeFailure(byte[] pattern) {
        int[] failure = new int[pattern.length];
        int j = 0;
        for (int i = 1; i < pattern.length; ++i) {
            while (j > 0 && pattern[j] != pattern[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == pattern[i]) {
                // empty if block
            }
            failure[i] = ++j;
        }
        return failure;
    }
}

