/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

import com.couchbase.lite.Database;
import com.couchbase.lite.Manager;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.support.MultipartDocumentReader;
import com.couchbase.lite.support.RemoteRequest;
import com.couchbase.lite.support.RemoteRequestCompletionBlock;
import com.couchbase.lite.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class RemoteMultipartDownloaderRequest
extends RemoteRequest {
    private Database db;

    public RemoteMultipartDownloaderRequest(ScheduledExecutorService workExecutor, HttpClientFactory clientFactory, String method, URL url, Object body, Database db, Map<String, Object> requestHeaders, RemoteRequestCompletionBlock onCompletion) {
        super(workExecutor, clientFactory, method, url, body, db, requestHeaders, onCompletion);
        this.db = db;
    }

    @Override
    public void run() {
        HttpClient httpClient = this.clientFactory.getHttpClient();
        this.preemptivelySetAuthCredentials(httpClient);
        this.request.addHeader("Accept", "*/*");
        this.addRequestHeaders(this.request);
        this.executeRequest(httpClient, this.request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void executeRequest(HttpClient httpClient, HttpUriRequest request) {
        block30: {
            block29: {
                HttpResponse response;
                Exception error;
                Map<String, Object> fullBody;
                block28: {
                    fullBody = null;
                    error = null;
                    response = null;
                    if (!request.isAborted()) break block28;
                    this.respondWithResult(fullBody, new Exception(String.format("%s: Request %s has been aborted", this, request)), response);
                    Log.d("RemoteRequest", "%s: executeRequest() finally", this);
                    return;
                }
                try {
                    response = httpClient.execute(request);
                    try {
                        if (httpClient instanceof DefaultHttpClient) {
                            DefaultHttpClient defaultHttpClient = (DefaultHttpClient)httpClient;
                            this.clientFactory.addCookies(defaultHttpClient.getCookieStore().getCookies());
                        }
                    }
                    catch (Exception e) {
                        Log.e("RemoteRequest", "Unable to add in cookies to global store", e);
                    }
                    StatusLine status = response.getStatusLine();
                    if (status.getStatusCode() >= 300) {
                        Log.e("RemoteRequest", "Got error status: %d for %s.  Reason: %s", status.getStatusCode(), request, status.getReasonPhrase());
                        error = new HttpResponseException(status.getStatusCode(), status.getReasonPhrase());
                        this.respondWithResult(fullBody, error, response);
                        break block29;
                    }
                    HttpEntity entity = response.getEntity();
                    Header contentTypeHeader = entity.getContentType();
                    InputStream inputStream = null;
                    if (contentTypeHeader != null && contentTypeHeader.getValue().contains("multipart/related")) {
                        try {
                            MultipartDocumentReader reader = new MultipartDocumentReader(response, this.db);
                            reader.setContentType(contentTypeHeader.getValue());
                            inputStream = entity.getContent();
                            int bufLen = 1024;
                            byte[] buffer = new byte[bufLen];
                            int numBytesRead = 0;
                            while ((numBytesRead = inputStream.read(buffer)) != -1) {
                                if (numBytesRead != bufLen) {
                                    byte[] bufferToAppend = Arrays.copyOfRange(buffer, 0, numBytesRead);
                                    reader.appendData(bufferToAppend);
                                    continue;
                                }
                                reader.appendData(buffer);
                            }
                            reader.finish();
                            fullBody = reader.getDocumentProperties();
                            this.respondWithResult(fullBody, error, response);
                            break block29;
                        }
                        finally {
                            try {
                                inputStream.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    if (entity == null) break block29;
                    try {
                        inputStream = entity.getContent();
                        fullBody = Manager.getObjectMapper().readValue(inputStream, Object.class);
                        this.respondWithResult(fullBody, error, response);
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {}
                    }
                }
                catch (IOException e) {
                    Log.e("RemoteRequest", "%s: io exception", e, this);
                    error = e;
                    this.respondWithResult(fullBody, e, response);
                    Log.d("RemoteRequest", "%s: executeRequest() finally", this);
                    break block30;
                }
                catch (Exception e2) {
                    Log.e("RemoteRequest", "%s: executeRequest() Exception: ", e2, this);
                    error = e2;
                    this.respondWithResult(fullBody, e2, response);
                    {
                        catch (Throwable throwable) {
                            Log.d("RemoteRequest", "%s: executeRequest() finally", this);
                            throw throwable;
                        }
                    }
                    Log.d("RemoteRequest", "%s: executeRequest() finally", this);
                }
            }
            Log.d("RemoteRequest", "%s: executeRequest() finally", this);
        }
    }
}

