/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

import com.couchbase.lite.Database;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.support.RemoteRequest;
import com.couchbase.lite.support.RemoteRequestCompletionBlock;
import com.couchbase.org.apache.http.entity.mime.MultipartEntity;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;

public class RemoteMultipartRequest
extends RemoteRequest {
    private MultipartEntity multiPart;

    public RemoteMultipartRequest(ScheduledExecutorService workExecutor, HttpClientFactory clientFactory, String method, URL url, MultipartEntity multiPart, Database db, Map<String, Object> requestHeaders, RemoteRequestCompletionBlock onCompletion) {
        super(workExecutor, clientFactory, method, url, null, db, requestHeaders, onCompletion);
        this.multiPart = multiPart;
    }

    @Override
    public void run() {
        HttpClient httpClient = this.clientFactory.getHttpClient();
        this.preemptivelySetAuthCredentials(httpClient);
        HttpPut request = null;
        if (this.method.equalsIgnoreCase("PUT")) {
            HttpPut putRequest = new HttpPut(this.url.toExternalForm());
            putRequest.setEntity((HttpEntity)this.multiPart);
            request = putRequest;
        } else if (this.method.equalsIgnoreCase("POST")) {
            HttpPost postRequest = new HttpPost(this.url.toExternalForm());
            postRequest.setEntity((HttpEntity)this.multiPart);
            request = postRequest;
        } else {
            throw new IllegalArgumentException("Invalid request method: " + this.method);
        }
        request.addHeader("Accept", "*/*");
        this.executeRequest(httpClient, (HttpUriRequest)request);
    }
}

