/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

import com.couchbase.lite.Database;
import com.couchbase.lite.Manager;
import com.couchbase.lite.auth.Authenticator;
import com.couchbase.lite.auth.AuthenticatorImpl;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.support.RemoteRequestCompletionBlock;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.URIUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;

public class RemoteRequest
implements Runnable {
    protected ScheduledExecutorService workExecutor;
    protected final HttpClientFactory clientFactory;
    protected String method;
    protected URL url;
    protected Object body;
    protected Authenticator authenticator;
    protected RemoteRequestCompletionBlock onPreCompletion;
    protected RemoteRequestCompletionBlock onCompletion;
    protected RemoteRequestCompletionBlock onPostCompletion;
    private int retryCount;
    private Database db;
    protected HttpUriRequest request;
    protected Map<String, Object> requestHeaders;
    private boolean dontLog404;

    public RemoteRequest(ScheduledExecutorService workExecutor, HttpClientFactory clientFactory, String method, URL url, Object body, Database db, Map<String, Object> requestHeaders, RemoteRequestCompletionBlock onCompletion) {
        this.clientFactory = clientFactory;
        this.method = method;
        this.url = url;
        this.body = body;
        this.onCompletion = onCompletion;
        this.workExecutor = workExecutor;
        this.requestHeaders = requestHeaders;
        this.db = db;
        this.request = this.createConcreteRequest();
        Log.v("Sync", "%s: RemoteRequest created, url: %s", this, url);
    }

    @Override
    public void run() {
        try {
            Log.v("Sync", "%s: RemoteRequest run() called, url: %s", this, this.url);
            HttpClient httpClient = this.clientFactory.getHttpClient();
            ClientConnectionManager manager = httpClient.getConnectionManager();
            this.preemptivelySetAuthCredentials(httpClient);
            this.request.addHeader("Accept", "multipart/related, application/json");
            this.addRequestHeaders(this.request);
            this.setBody(this.request);
            this.executeRequest(httpClient, this.request);
            Log.v("Sync", "%s: RemoteRequest run() finished, url: %s", this, this.url);
        }
        catch (Throwable e) {
            Log.e("Sync", "RemoteRequest.run() exception: %s", e);
        }
    }

    public void abort() {
        Log.w("RemoteRequest", "%s: aborting request: %s", this, this.request);
        if (this.request != null) {
            this.request.abort();
        } else {
            Log.w("RemoteRequest", "%s: Unable to abort request since underlying request is null", this);
        }
    }

    public HttpUriRequest getRequest() {
        return this.request;
    }

    protected void addRequestHeaders(HttpUriRequest request) {
        if (this.requestHeaders != null) {
            for (String requestHeaderKey : this.requestHeaders.keySet()) {
                request.addHeader(requestHeaderKey, this.requestHeaders.get(requestHeaderKey).toString());
            }
        }
    }

    public void setOnPostCompletion(RemoteRequestCompletionBlock onPostCompletion) {
        this.onPostCompletion = onPostCompletion;
    }

    public void setOnPreCompletion(RemoteRequestCompletionBlock onPreCompletion) {
        this.onPreCompletion = onPreCompletion;
    }

    protected HttpUriRequest createConcreteRequest() {
        HttpGet request = null;
        if (this.method.equalsIgnoreCase("GET")) {
            request = new HttpGet(this.url.toExternalForm());
        } else if (this.method.equalsIgnoreCase("PUT")) {
            request = new HttpPut(this.url.toExternalForm());
        } else if (this.method.equalsIgnoreCase("POST")) {
            request = new HttpPost(this.url.toExternalForm());
        }
        return request;
    }

    protected void setBody(HttpUriRequest request) {
        if (this.body != null && request instanceof HttpEntityEnclosingRequestBase) {
            byte[] bodyBytes = null;
            try {
                bodyBytes = Manager.getObjectMapper().writeValueAsBytes(this.body);
            }
            catch (Exception e) {
                Log.e("RemoteRequest", "Error serializing body of request", e);
            }
            ByteArrayEntity entity = new ByteArrayEntity(bodyBytes);
            entity.setContentType("application/json");
            ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)entity);
        }
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    /*
     * Exception decompiling
     */
    protected void executeRequest(HttpClient httpClient, HttpUriRequest requestParam) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void preemptivelySetAuthCredentials(HttpClient httpClient) {
        boolean isUrlBasedUserInfo = false;
        String userInfo = this.url.getUserInfo();
        if (userInfo != null) {
            isUrlBasedUserInfo = true;
        } else if (this.authenticator != null) {
            AuthenticatorImpl auth = (AuthenticatorImpl)this.authenticator;
            userInfo = auth.authUserInfo();
        }
        if (userInfo != null) {
            if (userInfo.contains(":") && !userInfo.trim().equals(":")) {
                String[] userInfoElements = userInfo.split(":");
                String username = isUrlBasedUserInfo ? URIUtils.decode(userInfoElements[0]) : userInfoElements[0];
                String password = isUrlBasedUserInfo ? URIUtils.decode(userInfoElements[1]) : userInfoElements[1];
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
                if (httpClient instanceof DefaultHttpClient) {
                    DefaultHttpClient dhc = (DefaultHttpClient)httpClient;
                    HttpRequestInterceptor preemptiveAuth = new HttpRequestInterceptor((Credentials)credentials){
                        final /* synthetic */ Credentials val$credentials;
                        {
                            this.val$credentials = credentials;
                        }

                        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
                            if (authState.getAuthScheme() == null) {
                                authState.setAuthScheme((AuthScheme)new BasicScheme());
                                authState.setCredentials(this.val$credentials);
                            }
                        }
                    };
                    dhc.addRequestInterceptor(preemptiveAuth, 0);
                }
            } else {
                Log.w("RemoteRequest", "RemoteRequest Unable to parse user info, not setting credentials");
            }
        }
    }

    public void respondWithResult(Object result, Throwable error, HttpResponse response) {
        try {
            if (this.onPreCompletion != null) {
                this.onPreCompletion.onCompletion(response, null, error);
            }
            this.onCompletion.onCompletion(response, result, error);
            if (this.onPostCompletion != null) {
                this.onPostCompletion.onCompletion(response, null, error);
            }
        }
        catch (Exception e) {
            Log.e("RemoteRequest", "RemoteRequestCompletionBlock throw Exception", e);
        }
    }

    public void setDontLog404(boolean dontLog404) {
        this.dontLog404 = dontLog404;
    }
}

