/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

import com.couchbase.lite.Database;
import com.couchbase.lite.auth.Authenticator;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.support.RemoteMultipartDownloaderRequest;
import com.couchbase.lite.support.RemoteMultipartRequest;
import com.couchbase.lite.support.RemoteRequest;
import com.couchbase.lite.support.RemoteRequestCompletionBlock;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.Utils;
import com.couchbase.org.apache.http.entity.mime.MultipartEntity;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;

public class RemoteRequestRetry<T>
implements Future<T> {
    public static int MAX_RETRIES = 3;
    public static int RETRY_DELAY_MS = 10000;
    protected ScheduledExecutorService workExecutor;
    protected ExecutorService requestExecutor;
    protected final HttpClientFactory clientFactory;
    protected String method;
    protected URL url;
    protected Object body;
    protected Authenticator authenticator;
    protected RemoteRequestCompletionBlock onCompletionCaller;
    protected RemoteRequestCompletionBlock onPreCompletionCaller;
    private int retryCount;
    private Database db;
    protected HttpUriRequest request;
    private AtomicBoolean completedSuccessfully = new AtomicBoolean(false);
    private HttpResponse requestHttpResponse;
    private Object requestResult;
    private Throwable requestThrowable;
    private BlockingQueue<Future> pendingRequests;
    private boolean dontLog404;
    protected Map<String, Object> requestHeaders;
    private RemoteRequestType requestType;
    RemoteRequestCompletionBlock onCompletionInner = new RemoteRequestCompletionBlock(){

        private void completed(HttpResponse httpResponse, Object result, Throwable e) {
            RemoteRequestRetry.this.requestHttpResponse = httpResponse;
            RemoteRequestRetry.this.requestResult = result;
            RemoteRequestRetry.this.requestThrowable = e;
            RemoteRequestRetry.this.completedSuccessfully.set(true);
            RemoteRequestRetry.this.onCompletionCaller.onCompletion(RemoteRequestRetry.this.requestHttpResponse, RemoteRequestRetry.this.requestResult, RemoteRequestRetry.this.requestThrowable);
        }

        @Override
        public void onCompletion(HttpResponse httpResponse, Object result, Throwable e) {
            Log.d("Sync", "%s: RemoteRequestRetry inner request finished, url: %s", this, RemoteRequestRetry.this.url);
            if (e == null) {
                Log.d("Sync", "%s: RemoteRequestRetry was successful, calling callback url: %s", this, RemoteRequestRetry.this.url);
                this.completed(httpResponse, result, e);
            } else if (RemoteRequestRetry.this.isTransientError(httpResponse, e)) {
                if (RemoteRequestRetry.this.retryCount >= MAX_RETRIES) {
                    Log.d("Sync", "%s: RemoteRequestRetry failed, but transient error.  retries exhausted. url: %s", this, RemoteRequestRetry.this.url);
                    this.completed(httpResponse, result, e);
                } else {
                    Log.d("Sync", "%s: RemoteRequestRetry failed, but transient error.  will retry. url: %s", this, RemoteRequestRetry.this.url);
                    RemoteRequestRetry.this.requestHttpResponse = httpResponse;
                    RemoteRequestRetry.this.requestResult = result;
                    RemoteRequestRetry.this.requestThrowable = e;
                    RemoteRequestRetry.this.retryCount += 1;
                    RemoteRequestRetry.this.submit();
                }
            } else {
                Log.d("Sync", "%s: RemoteRequestRetry failed, non-transient error.  NOT retrying. url: %s", this, RemoteRequestRetry.this.url);
                this.completed(httpResponse, result, e);
            }
        }
    };

    public RemoteRequestRetry(RemoteRequestType requestType, ScheduledExecutorService requestExecutor, ScheduledExecutorService workExecutor, HttpClientFactory clientFactory, String method, URL url, Object body, Database db, Map<String, Object> requestHeaders, RemoteRequestCompletionBlock onCompletionCaller) {
        this.requestType = requestType;
        this.requestExecutor = requestExecutor;
        this.clientFactory = clientFactory;
        this.method = method;
        this.url = url;
        this.body = body;
        this.onCompletionCaller = onCompletionCaller;
        this.workExecutor = workExecutor;
        this.requestHeaders = requestHeaders;
        this.db = db;
        this.pendingRequests = new LinkedBlockingQueue<Future>();
        this.validateParameters();
        Log.v("Sync", "%s: RemoteRequestRetry created, url: %s", this, url);
    }

    public Future submit() {
        RemoteRequest request = this.generateRemoteRequest();
        Future<?> future = this.requestExecutor.submit(request);
        this.pendingRequests.add(future);
        return this;
    }

    private RemoteRequest generateRemoteRequest() {
        this.requestHttpResponse = null;
        this.requestResult = null;
        this.requestThrowable = null;
        RemoteRequest request = null;
        switch (this.requestType) {
            case REMOTE_MULTIPART_REQUEST: {
                request = new RemoteMultipartRequest(this.workExecutor, this.clientFactory, this.method, this.url, (MultipartEntity)this.body, this.db, this.requestHeaders, this.onCompletionInner);
                break;
            }
            case REMOTE_MULTIPART_DOWNLOADER_REQUEST: {
                request = new RemoteMultipartDownloaderRequest(this.workExecutor, this.clientFactory, this.method, this.url, this.body, this.db, this.requestHeaders, this.onCompletionInner);
                break;
            }
            default: {
                request = new RemoteRequest(this.workExecutor, this.clientFactory, this.method, this.url, this.body, this.db, this.requestHeaders, this.onCompletionInner);
            }
        }
        request.setDontLog404(this.dontLog404);
        if (this.authenticator != null) {
            request.setAuthenticator(this.authenticator);
        }
        if (this.onPreCompletionCaller != null) {
            request.setOnPreCompletion(this.onPreCompletionCaller);
        }
        return request;
    }

    private boolean isTransientError(HttpResponse httpResponse, Throwable e) {
        Log.d("Sync", "%s: isTransientError called, httpResponse: %s e: %s", this, httpResponse, e);
        if (httpResponse != null) {
            if (Utils.isTransientError(httpResponse.getStatusLine())) {
                Log.d("Sync", "%s: its a transient error, return true", this);
                return true;
            }
        } else if (e instanceof IOException) {
            Log.d("Sync", "%s: its an ioexception, return true", this);
            return true;
        }
        Log.d("Sync", "%s: return false");
        return false;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setOnPreCompletionCaller(RemoteRequestCompletionBlock onPreCompletionCaller) {
        this.onPreCompletionCaller = onPreCompletionCaller;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        while (this.retryCount <= MAX_RETRIES) {
            Future future = this.pendingRequests.take();
            future.get();
            if (!this.completedSuccessfully.get()) continue;
            return null;
        }
        return null;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.get();
    }

    private void validateParameters() {
        switch (this.requestType) {
            case REMOTE_MULTIPART_REQUEST: {
                if (this.body instanceof MultipartEntity) break;
                throw new IllegalArgumentException("body must be a MultipartEntity for REMOTE_MULTIPART_REQUESTs");
            }
        }
    }

    public void setDontLog404(boolean dontLog404) {
        this.dontLog404 = dontLog404;
    }

    public static enum RemoteRequestType {
        REMOTE_REQUEST,
        REMOTE_MULTIPART_REQUEST,
        REMOTE_MULTIPART_DOWNLOADER_REQUEST;

    }
}

