/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;

public class URIUtils {
    private static final int NOT_FOUND = -1;
    private static final String UTF_8_ENCODING = "UTF-8";
    private static final String NOT_HIERARCHICAL = "This isn't a hierarchical URI.";
    private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();

    public static String decode(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLDecoder.decode(s, UTF_8_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getQueryParameter(URI uri, String key) {
        if (uri.isOpaque()) {
            throw new UnsupportedOperationException(NOT_HIERARCHICAL);
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        String query = uri.getRawQuery();
        if (query == null) {
            return null;
        }
        String encodedKey = URIUtils.encode(key, null);
        int length = query.length();
        int start = 0;
        while (true) {
            int nextAmpersand;
            int end = (nextAmpersand = query.indexOf(38, start)) != -1 ? nextAmpersand : length;
            int separator = query.indexOf(61, start);
            if (separator > end || separator == -1) {
                separator = end;
            }
            if (separator - start == encodedKey.length() && query.regionMatches(start, encodedKey, 0, encodedKey.length())) {
                if (separator == end) {
                    return "";
                }
                String encodedValue = query.substring(separator + 1, end);
                return URIUtils.decode(encodedValue, true, Charset.forName(UTF_8_ENCODING));
            }
            if (nextAmpersand == -1) break;
            start = nextAmpersand + 1;
        }
        return null;
    }

    public static String encode(String s) {
        return URIUtils.encode(s, null);
    }

    public static String encode(String s, String allow) {
        if (s == null) {
            return null;
        }
        StringBuilder encoded = null;
        int oldLength = s.length();
        int current = 0;
        while (current < oldLength) {
            int nextAllowed;
            int nextToEncode;
            for (nextToEncode = current; nextToEncode < oldLength && URIUtils.isAllowed(s.charAt(nextToEncode), allow); ++nextToEncode) {
            }
            if (nextToEncode == oldLength) {
                if (current == 0) {
                    return s;
                }
                encoded.append(s, current, oldLength);
                return encoded.toString();
            }
            if (encoded == null) {
                encoded = new StringBuilder();
            }
            if (nextToEncode > current) {
                encoded.append(s, current, nextToEncode);
            }
            current = nextToEncode;
            for (nextAllowed = current + 1; nextAllowed < oldLength && !URIUtils.isAllowed(s.charAt(nextAllowed), allow); ++nextAllowed) {
            }
            String toEncode = s.substring(current, nextAllowed);
            try {
                byte[] bytes = toEncode.getBytes(UTF_8_ENCODING);
                int bytesLength = bytes.length;
                for (int i = 0; i < bytesLength; ++i) {
                    encoded.append('%');
                    encoded.append(HEX_DIGITS[(bytes[i] & 0xF0) >> 4]);
                    encoded.append(HEX_DIGITS[bytes[i] & 0xF]);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
            current = nextAllowed;
        }
        return encoded == null ? s : encoded.toString();
    }

    private static boolean isAllowed(char c, String allow) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || "_-!.~'()*".indexOf(c) != -1 || allow != null && allow.indexOf(c) != -1;
    }

    public static String decode(String s, boolean convertPlus, Charset charset) {
        if (!(s.indexOf(37) != -1 || convertPlus && s.indexOf(43) != -1)) {
            return s;
        }
        StringBuilder result = new StringBuilder(s.length());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < s.length()) {
            int c = s.charAt(i);
            if (c == 37) {
                do {
                    if (i + 2 >= s.length()) {
                        throw new IllegalArgumentException("Incomplete % sequence at: " + i);
                    }
                    int d1 = URIUtils.hexToInt(s.charAt(i + 1));
                    int d2 = URIUtils.hexToInt(s.charAt(i + 2));
                    if (d1 == -1 || d2 == -1) {
                        throw new IllegalArgumentException("Invalid % sequence " + s.substring(i, i + 3) + " at " + i);
                    }
                    out.write((byte)((d1 << 4) + d2));
                } while ((i += 3) < s.length() && s.charAt(i) == '%');
                result.append(new String(out.toByteArray(), charset));
                out.reset();
                continue;
            }
            if (convertPlus && c == 43) {
                c = 32;
            }
            result.append((char)c);
            ++i;
        }
        return result.toString();
    }

    private static int hexToInt(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return 10 + (c - 97);
        }
        if ('A' <= c && c <= 'F') {
            return 10 + (c - 65);
        }
        return -1;
    }
}

