/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.javascript;

import com.couchbase.lite.Emitter;
import com.couchbase.lite.Mapper;
import com.couchbase.lite.javascript.CustomWrapFactory;
import com.couchbase.lite.util.Log;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrapFactory;

class ViewMapBlockRhino
implements Mapper {
    private static WrapFactory wrapFactory = new CustomWrapFactory();
    private Scriptable globalScope;
    private String src;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewMapBlockRhino(String src) {
        this.src = src;
        Context ctx = Context.enter();
        try {
            ctx.setOptimizationLevel(-1);
            ctx.setWrapFactory(wrapFactory);
            this.globalScope = ctx.initStandardObjects(null, true);
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void map(Map<String, Object> document, Emitter emitter) {
        Context ctx = Context.enter();
        try {
            ctx.setOptimizationLevel(-1);
            ctx.setWrapFactory(wrapFactory);
            String placeHolder = "var map_results = [];";
            ctx.evaluateString(this.globalScope, placeHolder, "placeHolder", 1, null);
            String emitFunction = "var emit = function(key, value) { map_results.push([key, value]); };";
            ctx.evaluateString(this.globalScope, emitFunction, "emit", 1, null);
            String mapSrc = "var map = " + this.src + ";";
            try {
                ctx.evaluateString(this.globalScope, mapSrc, "map", 1, null);
            }
            catch (EvaluatorException e) {
                Log.e((String)"CBLite", (String)("Javascript syntax error in view:\n" + this.src), (Throwable)e);
                Context.exit();
                return;
            }
            ObjectMapper mapper = new ObjectMapper();
            String json = null;
            try {
                json = mapper.writeValueAsString(document);
            }
            catch (IOException e) {
                Log.e((String)"CBLite", (String)("Error reserializing json from the db: " + document), (Throwable)e);
                Context.exit();
                return;
            }
            String mapInvocation = "map(" + json + ");";
            try {
                ctx.evaluateString(this.globalScope, mapInvocation, "map invocation", 1, null);
            }
            catch (RhinoException e) {
                Log.e((String)"CBLite", (String)("Error in javascript view:\n" + this.src + "\n with document:\n" + document), (Throwable)e);
                Context.exit();
                return;
            }
            NativeArray mapResults = (NativeArray)this.globalScope.get("map_results", this.globalScope);
            int i = 0;
            while ((long)i < mapResults.getLength()) {
                NativeArray mapResultItem = (NativeArray)mapResults.get(i);
                if (mapResultItem.getLength() == 2L) {
                    Object key = mapResultItem.get(0);
                    Object value = mapResultItem.get(1);
                    emitter.emit(key, value);
                } else {
                    Log.e((String)"CBLite", (String)String.format("Expected 2 element array with key and value.  Got: %s", mapResultItem));
                }
                ++i;
            }
        }
        finally {
            Context.exit();
        }
    }
}

