/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.javascript.support;

import java.util.List;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeList
implements Scriptable,
Wrapper {
    private static final long serialVersionUID = 3664761893203964569L;
    private List<Object> list;
    private Scriptable parentScope;
    private Scriptable prototype;

    public static NativeList wrap(Scriptable scope, List<Object> list) {
        return new NativeList(scope, list);
    }

    public NativeList(Scriptable scope, List<Object> list) {
        this.parentScope = scope;
        this.list = list;
    }

    public Object unwrap() {
        return this.list;
    }

    public String getClassName() {
        return "NativeList";
    }

    public Object get(String name, Scriptable start) {
        if ("length".equals(name)) {
            return this.list.size();
        }
        return Undefined.instance;
    }

    public Object get(int index, Scriptable start) {
        if (index < 0 || index >= this.list.size()) {
            return Undefined.instance;
        }
        return this.list.get(index);
    }

    public boolean has(String name, Scriptable start) {
        return "length".equals(name);
    }

    public boolean has(int index, Scriptable start) {
        return index >= 0 && index < this.list.size();
    }

    public void put(String name, Scriptable start, Object value) {
    }

    public void put(int index, Scriptable start, Object value) {
        if (index == this.list.size()) {
            this.list.add(value);
        } else {
            this.list.set(index, value);
        }
    }

    public void delete(String name) {
    }

    public void delete(int index) {
        this.list.remove(index);
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    public void setPrototype(Scriptable prototype) {
        this.prototype = prototype;
    }

    public Scriptable getParentScope() {
        return this.parentScope;
    }

    public void setParentScope(Scriptable parent) {
        this.parentScope = parent;
    }

    public Object[] getIds() {
        int size = this.list.size();
        Object[] ids = new Object[size];
        for (int i = 0; i < size; ++i) {
            ids[i] = i;
        }
        return ids;
    }

    public Object getDefaultValue(Class hint) {
        return null;
    }

    public boolean hasInstance(Scriptable value) {
        if (!(value instanceof Wrapper)) {
            return false;
        }
        Object instance = ((Wrapper)value).unwrap();
        return List.class.isInstance(instance);
    }
}

