# DownloadLcbDeb(url location)
MACRO(DOWNLOAD_LCB_DEP url dest)
    FIND_PROGRAM(WGET wget)
    FIND_PROGRAM(CURL curl)
    IF(CURL)
        EXECUTE_PROCESS(COMMAND "${CURL}" "${url}" -L -o "${dest}" RESULT_VARIABLE DLRC)
    ELSEIF(WGET)
        EXECUTE_PROCESS(COMMAND "${WGET}" "${url}" -O "${dest}" RESULT_VARIABLE DLRC)
    ENDIF()
    IF(NOT DLRC EQUAL 0)
      MESSAGE(WARNING "Using buggy built-in CMake downloader")
      FILE(DOWNLOAD ${url} ${dest} INACTIVITY_TIMEOUT 30 SHOW_PROGRESS STATUS RET)
      LIST(GET RET 0 DLRC)
    ENDIF()
    IF(NOT DLRC EQUAL 0)
        MESSAGE(FATAL_ERROR "Failed to download ${url}")
    ENDIF()
ENDMACRO()
