// This file was generated by queries.rb
typedef struct fts_query_str { const char *comment; size_t query_len; const char *query; } fts_query_str;
size_t num_queries = 14;
fts_query_str queries[15] = {
{"Simple Text Query on a single word, targeting an index with dynamic fields not stored.",
 110,
 "{\"indexName\":\"travel-sample-index-unstored\",\"size\":10,\"highlight\":{\"style\":\"html\"},\"query\":{\"match\":\"swanky\"}}"},

{"Simple Text Query on Non-Default Index, specifying an index that consists only of content derived from a specific field from a specific document-type.",
 90,
 "{\"indexName\":\"travel-sample-index-hotel-description\",\"size\":10,\"query\":{\"match\":\"swanky\"}}"},

{"Simple Text Query on Stored Field, specifying the field to be searched; targeting an index with dynamic fields stored, to ensure that field-content is included in the return object.",
 134,
 "{\"indexName\":\"travel-sample-index-stored\",\"size\":10,\"highlight\":{\"style\":\"html\"},\"query\":{\"field\":\"destinationairport\",\"match\":\"MDG\"}}"},

{"Match Query with Facet, showing how query-results can be displayed either by row or by hits; and demonstrating use of a facet, which provides aggregation-data.",
 211,
 "{\"indexName\":\"travel-sample-index-stored\",\"highlight\":{\"style\":\"html\"},\"size\":10,\"query\":{\"field\":\"reviews.content\",\"match\":\"La Rue Saint Denis!!\"},\"facets\":{\"Countries Referenced\":{\"size\":5,\"field\":\"country\"}}}"},

{"DocId Query, showing results of a query on two document IDs.",
 90,
 "{\"indexName\":\"travel-sample-index-unstored\",\"query\":{\"ids\":[\"hotel_26223\",\"hotel_28960\"]}}"},

{"Unanalyzed Term Query with Fuzziness Level of 0, demonstrating how to query on a term with no analysis. Zero fuzziness is specified, to ensure that matches are exact.",
 132,
 "{\"indexName\":\"travel-sample-index-stored\",\"size\":50,\"highlight\":{\"style\":\"html\"},\"query\":{\"field\":\"reviews.content\",\"term\":\"sushi\"}}"},

{"Unanalyzed Term Query with Fuzziness Level of 2, which is almost identical to the immediately preceding query; but which this time specifies a fuzziness factor of 2, allowing partial matches to be made. The output from this query can be compared to that of the one immediately preceding.",
 146,
 "{\"indexName\":\"travel-sample-index-stored\",\"size\":50,\"highlight\":{\"style\":\"html\"},\"query\":{\"field\":\"reviews.content\",\"fuzziness\":2,\"term\":\"sushi\"}}"},

{"Match Phrase Query, using Analysis, for searching on a phrase.",
 143,
 "{\"indexName\":\"travel-sample-index-stored\",\"size\":10,\"highlight\":{\"style\":\"html\"},\"query\":{\"field\":\"description\",\"match_phrase\":\"Eiffel Tower\"}}"},

{"Phrase Query, without Analysis, for searching on a phrase without analysis supported.",
 138,
 "{\"indexName\":\"travel-sample-index-stored\",\"size\":10,\"highlight\":{\"style\":\"html\"},\"query\":{\"field\":\"description\",\"terms\":[\"dorm\",\"rooms\"]}}"},

{"Query String Query, showing how a query string is specified as search-input.",
 96,
 "{\"indexName\":\"travel-sample-index-unstored\",\"size\":10,\"query\":{\"query\":\"description: Imperial\"}}"},

{"Conjunction Query, whereby two separate queries are defined and then run as part of the search, with only the matches returned by both included in the result-object.",
 207,
 "{\"indexName\":\"travel-sample-index-stored\",\"size\":10,\"highlight\":{\"style\":\"html\"},\"query\":{\"conjuncts\":[{\"field\":\"reviews.content\",\"match\":\"La Rue Saint Denis!!\"},{\"field\":\"description\",\"match\":\"boutique\"}]}}"},

{"Wild Card Query, whereby a wildcard is used in the string submitted for the search.",
 135,
 "{\"indexName\":\"travel-sample-index-stored\",\"size\":10,\"highlight\":{\"style\":\"html\"},\"query\":{\"field\":\"description\",\"wildcard\":\"bouti*ue\"}}"},

{"Numeric Range Query, whereby minimum and maximum numbers are specified, and matches within the range returned.",
 105,
 "{\"indexName\":\"travel-sample-index-unstored\",\"size\":10,\"query\":{\"field\":\"id\",\"max\":10200.0,\"min\":10100.0}}"},

{"Regexp Query, whereby a regular expression is submitted, to generate the conditions for successful matches.",
 130,
 "{\"indexName\":\"travel-sample-index-stored\",\"size\":10,\"highlight\":{\"style\":\"html\"},\"query\":{\"field\":\"description\",\"regexp\":\"[a-z]\"}}"},

{NULL, 0, NULL}};
