/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._helpers.esql.objects;

import co.elastic.clients.ApiClient;
import co.elastic.clients.elasticsearch._helpers.esql.EsqlAdapter;
import co.elastic.clients.elasticsearch._helpers.esql.EsqlAdapterBase;
import co.elastic.clients.elasticsearch._helpers.esql.EsqlMetadata;
import co.elastic.clients.elasticsearch.esql.QueryRequest;
import co.elastic.clients.json.BufferingJsonGenerator;
import co.elastic.clients.json.BufferingJsonpMapper;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.endpoints.BinaryResponse;
import jakarta.json.stream.JsonParser;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ObjectsEsqlAdapter<T>
implements EsqlAdapter<Iterable<T>> {
    private final Type type;

    public static <T> ObjectsEsqlAdapter<T> of(Class<T> clazz) {
        return new ObjectsEsqlAdapter<T>(clazz);
    }

    public static <T> ObjectsEsqlAdapter<T> of(Type type) {
        return new ObjectsEsqlAdapter<T>(type);
    }

    public ObjectsEsqlAdapter(Type type) {
        this.type = type;
    }

    @Override
    public String format() {
        return "json";
    }

    @Override
    public boolean columnar() {
        return false;
    }

    @Override
    public Iterable<T> deserialize(ApiClient<ElasticsearchTransport, ?> client, QueryRequest request, BinaryResponse response) throws IOException {
        JsonParser.Event event;
        JsonpMapper mapper = client._jsonpMapper();
        if (!(mapper instanceof BufferingJsonpMapper)) {
            throw new IllegalArgumentException("ES|QL object mapping currently only works with JacksonJsonpMapper");
        }
        JsonParser parser = mapper.jsonProvider().createParser(response.content());
        List<EsqlMetadata.EsqlColumn> columns = EsqlAdapterBase.readHeader((JsonParser)parser, (JsonpMapper)mapper).columns;
        ArrayList<T> results = new ArrayList<T>();
        while ((event = parser.next()) != JsonParser.Event.END_ARRAY) {
            JsonpUtils.expectEvent(parser, JsonParser.Event.START_ARRAY, event);
            results.add(this.parseRow(columns, parser, mapper));
            JsonpUtils.expectNextEvent(parser, JsonParser.Event.END_ARRAY);
        }
        EsqlAdapterBase.readFooter(parser);
        return results;
    }

    private T parseRow(List<EsqlMetadata.EsqlColumn> columns, JsonParser parser, JsonpMapper mapper) {
        BufferingJsonGenerator buffer = ((BufferingJsonpMapper)mapper).createBufferingGenerator();
        buffer.writeStartObject();
        for (EsqlMetadata.EsqlColumn column : columns) {
            buffer.writeKey(column.name());
            JsonpUtils.copy(parser, buffer);
        }
        buffer.writeEnd();
        return mapper.deserialize(buffer.getParser(), this.type);
    }
}

