/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateBase;
import co.elastic.clients.json.ExternallyTaggedUnion;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class SingleBucketAggregateBase
extends AggregateBase {
    private final Map<String, Aggregate> aggregations;
    private final long docCount;

    protected SingleBucketAggregateBase(AbstractBuilder<?> builder) {
        super(builder);
        this.aggregations = ApiTypeHelper.unmodifiable(builder.aggregations);
        this.docCount = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).docCount, this, "docCount");
    }

    public final Map<String, Aggregate> aggregations() {
        return this.aggregations;
    }

    public final long docCount() {
        return this.docCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        ExternallyTaggedUnion.serializeTypedKeysInner(this.aggregations, generator, mapper);
        super.serializeInternal(generator, mapper);
        generator.writeKey("doc_count");
        generator.write(this.docCount);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupSingleBucketAggregateBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        AggregateBase.setupAggregateBaseDeserializer(op);
        op.add(AbstractBuilder::docCount, JsonpDeserializer.longDeserializer(), "doc_count");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            if (builder.aggregations == null) {
                builder.aggregations = new HashMap<String, Aggregate>();
            }
            Aggregate._TYPED_KEYS_DESERIALIZER.deserializeEntry((String)name, (JsonParser)parser, (JsonpMapper)mapper, builder.aggregations);
        });
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AggregateBase.AbstractBuilder<BuilderT> {
        @Nullable
        protected Map<String, Aggregate> aggregations = new HashMap<String, Aggregate>();
        private Long docCount;

        public final BuilderT aggregations(Map<String, Aggregate> map) {
            this.aggregations = AbstractBuilder._mapPutAll(this.aggregations, map);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT aggregations(String key, Aggregate value) {
            this.aggregations = AbstractBuilder._mapPut(this.aggregations, key, value);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT aggregations(String key, Function<Aggregate.Builder, ObjectBuilder<Aggregate>> fn) {
            return this.aggregations(key, fn.apply(new Aggregate.Builder()).build());
        }

        public final BuilderT docCount(long value) {
            this.docCount = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

