/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class OpenPointInTimeResponse
implements JsonpSerializable {
    private final ShardStatistics shards;
    private final String id;
    public static final JsonpDeserializer<OpenPointInTimeResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OpenPointInTimeResponse::setupOpenPointInTimeResponseDeserializer);

    private OpenPointInTimeResponse(Builder builder) {
        this.shards = ApiTypeHelper.requireNonNull(builder.shards, this, "shards");
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
    }

    public static OpenPointInTimeResponse of(Function<Builder, ObjectBuilder<OpenPointInTimeResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ShardStatistics shards() {
        return this.shards;
    }

    public final String id() {
        return this.id;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        generator.writeKey("id");
        generator.write(this.id);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupOpenPointInTimeResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<OpenPointInTimeResponse> {
        private ShardStatistics shards;
        private String id;

        public final Builder shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public final Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public OpenPointInTimeResponse build() {
            this._checkSingleUse();
            return new OpenPointInTimeResponse(this);
        }
    }
}

