/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.update_aliases;

import co.elastic.clients.elasticsearch.indices.update_aliases.Action;
import co.elastic.clients.elasticsearch.indices.update_aliases.ActionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RemoveIndexAction
implements ActionVariant,
JsonpSerializable {
    @Nullable
    private final String index;
    private final List<String> indices;
    @Nullable
    private final Boolean mustExist;
    public static final JsonpDeserializer<RemoveIndexAction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RemoveIndexAction::setupRemoveIndexActionDeserializer);

    private RemoveIndexAction(Builder builder) {
        this.index = builder.index;
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.mustExist = builder.mustExist;
    }

    public static RemoveIndexAction of(Function<Builder, ObjectBuilder<RemoveIndexAction>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Action.Kind _actionKind() {
        return Action.Kind.RemoveIndex;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    public final List<String> indices() {
        return this.indices;
    }

    @Nullable
    public final Boolean mustExist() {
        return this.mustExist;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index);
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String item0 : this.indices) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.mustExist != null) {
            generator.writeKey("must_exist");
            generator.write(this.mustExist.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRemoveIndexActionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::mustExist, JsonpDeserializer.booleanDeserializer(), "must_exist");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RemoveIndexAction> {
        @Nullable
        private String index;
        @Nullable
        private List<String> indices;
        @Nullable
        private Boolean mustExist;

        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder mustExist(@Nullable Boolean value) {
            this.mustExist = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RemoveIndexAction build() {
            this._checkSingleUse();
            return new RemoveIndexAction(this);
        }
    }
}

