/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.GeoGridTargetFormat;
import co.elastic.clients.elasticsearch.ingest.GeoGridTileType;
import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GeoGridProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    private final GeoGridTileType tileType;
    @Nullable
    private final String targetField;
    @Nullable
    private final String parentField;
    @Nullable
    private final String childrenField;
    @Nullable
    private final String nonChildrenField;
    @Nullable
    private final String precisionField;
    @Nullable
    private final Boolean ignoreMissing;
    @Nullable
    private final GeoGridTargetFormat targetFormat;
    public static final JsonpDeserializer<GeoGridProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoGridProcessor::setupGeoGridProcessorDeserializer);

    private GeoGridProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.tileType = ApiTypeHelper.requireNonNull(builder.tileType, this, "tileType");
        this.targetField = builder.targetField;
        this.parentField = builder.parentField;
        this.childrenField = builder.childrenField;
        this.nonChildrenField = builder.nonChildrenField;
        this.precisionField = builder.precisionField;
        this.ignoreMissing = builder.ignoreMissing;
        this.targetFormat = builder.targetFormat;
    }

    public static GeoGridProcessor of(Function<Builder, ObjectBuilder<GeoGridProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.GeoGrid;
    }

    public final String field() {
        return this.field;
    }

    public final GeoGridTileType tileType() {
        return this.tileType;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Nullable
    public final String parentField() {
        return this.parentField;
    }

    @Nullable
    public final String childrenField() {
        return this.childrenField;
    }

    @Nullable
    public final String nonChildrenField() {
        return this.nonChildrenField;
    }

    @Nullable
    public final String precisionField() {
        return this.precisionField;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Nullable
    public final GeoGridTargetFormat targetFormat() {
        return this.targetFormat;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("tile_type");
        this.tileType.serialize(generator, mapper);
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
        if (this.parentField != null) {
            generator.writeKey("parent_field");
            generator.write(this.parentField);
        }
        if (this.childrenField != null) {
            generator.writeKey("children_field");
            generator.write(this.childrenField);
        }
        if (this.nonChildrenField != null) {
            generator.writeKey("non_children_field");
            generator.write(this.nonChildrenField);
        }
        if (this.precisionField != null) {
            generator.writeKey("precision_field");
            generator.write(this.precisionField);
        }
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        if (this.targetFormat != null) {
            generator.writeKey("target_format");
            this.targetFormat.serialize(generator, mapper);
        }
    }

    protected static void setupGeoGridProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::tileType, GeoGridTileType._DESERIALIZER, "tile_type");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
        op.add(Builder::parentField, JsonpDeserializer.stringDeserializer(), "parent_field");
        op.add(Builder::childrenField, JsonpDeserializer.stringDeserializer(), "children_field");
        op.add(Builder::nonChildrenField, JsonpDeserializer.stringDeserializer(), "non_children_field");
        op.add(Builder::precisionField, JsonpDeserializer.stringDeserializer(), "precision_field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::targetFormat, GeoGridTargetFormat._DESERIALIZER, "target_format");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoGridProcessor> {
        private String field;
        private GeoGridTileType tileType;
        @Nullable
        private String targetField;
        @Nullable
        private String parentField;
        @Nullable
        private String childrenField;
        @Nullable
        private String nonChildrenField;
        @Nullable
        private String precisionField;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private GeoGridTargetFormat targetFormat;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder tileType(GeoGridTileType value) {
            this.tileType = value;
            return this;
        }

        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        public final Builder parentField(@Nullable String value) {
            this.parentField = value;
            return this;
        }

        public final Builder childrenField(@Nullable String value) {
            this.childrenField = value;
            return this;
        }

        public final Builder nonChildrenField(@Nullable String value) {
            this.nonChildrenField = value;
            return this;
        }

        public final Builder precisionField(@Nullable String value) {
            this.precisionField = value;
            return this;
        }

        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public final Builder targetFormat(@Nullable GeoGridTargetFormat value) {
            this.targetFormat = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoGridProcessor build() {
            this._checkSingleUse();
            return new GeoGridProcessor(this);
        }
    }
}

