/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ingest.DatabaseConfiguration;
import co.elastic.clients.elasticsearch.ingest.PutIpLocationDatabaseResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutIpLocationDatabaseRequest
extends RequestBase
implements JsonpSerializable {
    private final String id;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Time timeout;
    private final DatabaseConfiguration configuration;
    public static final JsonpDeserializer<PutIpLocationDatabaseRequest> _DESERIALIZER = PutIpLocationDatabaseRequest.createPutIpLocationDatabaseRequestDeserializer();
    public static final Endpoint<PutIpLocationDatabaseRequest, PutIpLocationDatabaseResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutIpLocationDatabaseRequest, PutIpLocationDatabaseResponse>("es/ingest.put_ip_location_database", request -> "PUT", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ingest");
            buf.append("/ip_location");
            buf.append("/database");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("id", request.id);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutIpLocationDatabaseResponse._DESERIALIZER);

    private PutIpLocationDatabaseRequest(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
        this.configuration = ApiTypeHelper.requireNonNull(builder.configuration, this, "configuration");
    }

    public static PutIpLocationDatabaseRequest of(Function<Builder, ObjectBuilder<PutIpLocationDatabaseRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public final DatabaseConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.configuration.serialize(generator, mapper);
    }

    protected static JsonpDeserializer<PutIpLocationDatabaseRequest> createPutIpLocationDatabaseRequestDeserializer() {
        JsonpDeserializer<DatabaseConfiguration> valueDeserializer = DatabaseConfiguration._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().configuration((DatabaseConfiguration)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutIpLocationDatabaseRequest> {
        private String id;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Time timeout;
        private DatabaseConfiguration configuration;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder configuration(DatabaseConfiguration value) {
            this.configuration = value;
            return this;
        }

        public final Builder configuration(Function<DatabaseConfiguration.Builder, ObjectBuilder<DatabaseConfiguration>> fn) {
            return this.configuration(fn.apply(new DatabaseConfiguration.Builder()).build());
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            DatabaseConfiguration value = DatabaseConfiguration._DESERIALIZER.deserialize(parser, mapper);
            return this.configuration(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutIpLocationDatabaseRequest build() {
            this._checkSingleUse();
            return new PutIpLocationDatabaseRequest(this);
        }
    }
}

