/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.simulate.ingest;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IngestDocumentSimulation
implements JsonpSerializable {
    private final Map<String, String> metadata;
    private final String id;
    private final String index;
    private final Map<String, JsonData> source;
    private final long version;
    private final List<String> executedPipelines;
    private final List<Map<String, String>> ignoredFields;
    @Nullable
    private final ErrorCause error;
    public static final JsonpDeserializer<IngestDocumentSimulation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IngestDocumentSimulation::setupIngestDocumentSimulationDeserializer);

    private IngestDocumentSimulation(Builder builder) {
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.source = ApiTypeHelper.unmodifiableRequired(builder.source, (Object)this, "source");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
        this.executedPipelines = ApiTypeHelper.unmodifiableRequired(builder.executedPipelines, (Object)this, "executedPipelines");
        this.ignoredFields = ApiTypeHelper.unmodifiable(builder.ignoredFields);
        this.error = builder.error;
    }

    public static IngestDocumentSimulation of(Function<Builder, ObjectBuilder<IngestDocumentSimulation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, String> metadata() {
        return this.metadata;
    }

    public final String id() {
        return this.id;
    }

    public final String index() {
        return this.index;
    }

    public final Map<String, JsonData> source() {
        return this.source;
    }

    public final long version() {
        return this.version;
    }

    public final List<String> executedPipelines() {
        return this.executedPipelines;
    }

    public final List<Map<String, String>> ignoredFields() {
        return this.ignoredFields;
    }

    @Nullable
    public final ErrorCause error() {
        return this.error;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
            generator.writeKey(entry.getKey());
            generator.write(entry.getValue());
        }
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("_index");
        generator.write(this.index);
        if (ApiTypeHelper.isDefined(this.source)) {
            generator.writeKey("_source");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.source.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("_version");
        generator.write(this.version);
        if (ApiTypeHelper.isDefined(this.executedPipelines)) {
            generator.writeKey("executed_pipelines");
            generator.writeStartArray();
            for (String string : this.executedPipelines) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.ignoredFields)) {
            generator.writeKey("ignored_fields");
            generator.writeStartArray();
            for (Map map : this.ignoredFields) {
                generator.writeStartObject();
                if (map != null) {
                    for (Map.Entry item1 : map.entrySet()) {
                        generator.writeKey((String)item1.getKey());
                        generator.write((String)item1.getValue());
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.error != null) {
            generator.writeKey("error");
            this.error.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupIngestDocumentSimulationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(Builder::source, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_source");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "_version");
        op.add(Builder::executedPipelines, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "executed_pipelines");
        op.add(Builder::ignoredFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer())), "ignored_fields");
        op.add(Builder::error, ErrorCause._DESERIALIZER, "error");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> builder.metadata((String)name, JsonpDeserializer.stringDeserializer().deserialize((JsonParser)parser, (JsonpMapper)mapper)));
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IngestDocumentSimulation> {
        @Nullable
        private Map<String, String> metadata = new HashMap<String, String>();
        private String id;
        private String index;
        private Map<String, JsonData> source;
        private Long version;
        private List<String> executedPipelines;
        @Nullable
        private List<Map<String, String>> ignoredFields;
        @Nullable
        private ErrorCause error;

        public final Builder metadata(Map<String, String> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, String value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder source(Map<String, JsonData> map) {
            this.source = Builder._mapPutAll(this.source, map);
            return this;
        }

        public final Builder source(String key, JsonData value) {
            this.source = Builder._mapPut(this.source, key, value);
            return this;
        }

        public final Builder version(long value) {
            this.version = value;
            return this;
        }

        public final Builder executedPipelines(List<String> list) {
            this.executedPipelines = Builder._listAddAll(this.executedPipelines, list);
            return this;
        }

        public final Builder executedPipelines(String value, String ... values) {
            this.executedPipelines = Builder._listAdd(this.executedPipelines, value, values);
            return this;
        }

        public final Builder ignoredFields(List<Map<String, String>> list) {
            this.ignoredFields = Builder._listAddAll(this.ignoredFields, list);
            return this;
        }

        public final Builder ignoredFields(Map<String, String> value, Map<String, String> ... values) {
            this.ignoredFields = Builder._listAdd(this.ignoredFields, value, values);
            return this;
        }

        public final Builder error(@Nullable ErrorCause value) {
            this.error = value;
            return this;
        }

        public final Builder error(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.error(fn.apply(new ErrorCause.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IngestDocumentSimulation build() {
            this._checkSingleUse();
            return new IngestDocumentSimulation(this);
        }
    }
}

