/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot.repository_analyze;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.snapshot.repository_analyze.SnapshotNodeInfo;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ReadBlobDetails
implements JsonpSerializable {
    @Nullable
    private final Boolean beforeWriteComplete;
    @Nullable
    private final Time elapsed;
    @Nullable
    private final Long elapsedNanos;
    @Nullable
    private final Time firstByteTime;
    private final long firstByteTimeNanos;
    private final boolean found;
    private final SnapshotNodeInfo node;
    @Nullable
    private final Time throttled;
    @Nullable
    private final Long throttledNanos;
    public static final JsonpDeserializer<ReadBlobDetails> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReadBlobDetails::setupReadBlobDetailsDeserializer);

    private ReadBlobDetails(Builder builder) {
        this.beforeWriteComplete = builder.beforeWriteComplete;
        this.elapsed = builder.elapsed;
        this.elapsedNanos = builder.elapsedNanos;
        this.firstByteTime = builder.firstByteTime;
        this.firstByteTimeNanos = ApiTypeHelper.requireNonNull(builder.firstByteTimeNanos, this, "firstByteTimeNanos");
        this.found = ApiTypeHelper.requireNonNull(builder.found, this, "found");
        this.node = ApiTypeHelper.requireNonNull(builder.node, this, "node");
        this.throttled = builder.throttled;
        this.throttledNanos = builder.throttledNanos;
    }

    public static ReadBlobDetails of(Function<Builder, ObjectBuilder<ReadBlobDetails>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean beforeWriteComplete() {
        return this.beforeWriteComplete;
    }

    @Nullable
    public final Time elapsed() {
        return this.elapsed;
    }

    @Nullable
    public final Long elapsedNanos() {
        return this.elapsedNanos;
    }

    @Nullable
    public final Time firstByteTime() {
        return this.firstByteTime;
    }

    public final long firstByteTimeNanos() {
        return this.firstByteTimeNanos;
    }

    public final boolean found() {
        return this.found;
    }

    public final SnapshotNodeInfo node() {
        return this.node;
    }

    @Nullable
    public final Time throttled() {
        return this.throttled;
    }

    @Nullable
    public final Long throttledNanos() {
        return this.throttledNanos;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.beforeWriteComplete != null) {
            generator.writeKey("before_write_complete");
            generator.write(this.beforeWriteComplete.booleanValue());
        }
        if (this.elapsed != null) {
            generator.writeKey("elapsed");
            this.elapsed.serialize(generator, mapper);
        }
        if (this.elapsedNanos != null) {
            generator.writeKey("elapsed_nanos");
            generator.write(this.elapsedNanos.longValue());
        }
        if (this.firstByteTime != null) {
            generator.writeKey("first_byte_time");
            this.firstByteTime.serialize(generator, mapper);
        }
        generator.writeKey("first_byte_time_nanos");
        generator.write(this.firstByteTimeNanos);
        generator.writeKey("found");
        generator.write(this.found);
        generator.writeKey("node");
        this.node.serialize(generator, mapper);
        if (this.throttled != null) {
            generator.writeKey("throttled");
            this.throttled.serialize(generator, mapper);
        }
        if (this.throttledNanos != null) {
            generator.writeKey("throttled_nanos");
            generator.write(this.throttledNanos.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupReadBlobDetailsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::beforeWriteComplete, JsonpDeserializer.booleanDeserializer(), "before_write_complete");
        op.add(Builder::elapsed, Time._DESERIALIZER, "elapsed");
        op.add(Builder::elapsedNanos, JsonpDeserializer.longDeserializer(), "elapsed_nanos");
        op.add(Builder::firstByteTime, Time._DESERIALIZER, "first_byte_time");
        op.add(Builder::firstByteTimeNanos, JsonpDeserializer.longDeserializer(), "first_byte_time_nanos");
        op.add(Builder::found, JsonpDeserializer.booleanDeserializer(), "found");
        op.add(Builder::node, SnapshotNodeInfo._DESERIALIZER, "node");
        op.add(Builder::throttled, Time._DESERIALIZER, "throttled");
        op.add(Builder::throttledNanos, JsonpDeserializer.longDeserializer(), "throttled_nanos");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ReadBlobDetails> {
        @Nullable
        private Boolean beforeWriteComplete;
        @Nullable
        private Time elapsed;
        @Nullable
        private Long elapsedNanos;
        @Nullable
        private Time firstByteTime;
        private Long firstByteTimeNanos;
        private Boolean found;
        private SnapshotNodeInfo node;
        @Nullable
        private Time throttled;
        @Nullable
        private Long throttledNanos;

        public final Builder beforeWriteComplete(@Nullable Boolean value) {
            this.beforeWriteComplete = value;
            return this;
        }

        public final Builder elapsed(@Nullable Time value) {
            this.elapsed = value;
            return this;
        }

        public final Builder elapsed(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.elapsed(fn.apply(new Time.Builder()).build());
        }

        public final Builder elapsedNanos(@Nullable Long value) {
            this.elapsedNanos = value;
            return this;
        }

        public final Builder firstByteTime(@Nullable Time value) {
            this.firstByteTime = value;
            return this;
        }

        public final Builder firstByteTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.firstByteTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder firstByteTimeNanos(long value) {
            this.firstByteTimeNanos = value;
            return this;
        }

        public final Builder found(boolean value) {
            this.found = value;
            return this;
        }

        public final Builder node(SnapshotNodeInfo value) {
            this.node = value;
            return this;
        }

        public final Builder node(Function<SnapshotNodeInfo.Builder, ObjectBuilder<SnapshotNodeInfo>> fn) {
            return this.node(fn.apply(new SnapshotNodeInfo.Builder()).build());
        }

        public final Builder throttled(@Nullable Time value) {
            this.throttled = value;
            return this;
        }

        public final Builder throttled(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.throttled(fn.apply(new Time.Builder()).build());
        }

        public final Builder throttledNanos(@Nullable Long value) {
            this.throttledNanos = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ReadBlobDetails build() {
            this._checkSingleUse();
            return new ReadBlobDetails(this);
        }
    }
}

