/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;

public class DuplicateResourceFinder {
    private static volatile boolean ENABLED = true;

    public static void enableCheck(boolean enabled) {
        ENABLED = enabled;
    }

    public static void ensureClassUniqueness(Class<?> clazz) {
        String name = clazz.getName();
        String resource = clazz.getName().replace('.', '/') + ".class";
        DuplicateResourceFinder.ensureResourceUniqueness(resource, name, DuplicateResourceFinder.class.getClassLoader());
    }

    public static void ensureResourceUniqueness(String path) {
        DuplicateResourceFinder.ensureResourceUniqueness(path, path, DuplicateResourceFinder.class.getClassLoader());
    }

    private static void ensureResourceUniqueness(String path, String name, ClassLoader classLoader) {
        if (!ENABLED) {
            return;
        }
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            Enumeration<URL> resources = classLoader.getResources(path);
            while (resources.hasMoreElements()) {
                list.add(resources.nextElement());
            }
        }
        catch (IOException resources) {
            // empty catch block
        }
        if (list.size() > 1) {
            StringBuilder sb = new StringBuilder("Several versions of ").append(name).append(" were found. This can cause conflicts, please fix the classpath:\n");
            for (URL url : list) {
                sb.append("    ").append(url.toString()).append("\n");
            }
            sb.append("    See the Java API client's troubleshooting documentation for more information.\n");
            throw new RuntimeException(sb.toString());
        }
    }
}

