/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Properties;

public class VersionHelper {
    private static final String version;
    private static final String gitInfo;

    private VersionHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static String getVersionString() {
        String gitInfo = VersionHelper.getGitInfo().orElse(null);
        return gitInfo == null ? version : version + "(" + gitInfo + ")";
    }

    public static String getVersion() {
        return version;
    }

    public static Optional<String> getGitInfo() {
        return version.equals(gitInfo) ? Optional.empty() : Optional.of(gitInfo);
    }

    static {
        String tempVersion = "unknown";
        String tempGitInfo = "unknown";
        try {
            String versionResource = "version.properties";
            try (InputStream is = VersionHelper.class.getResourceAsStream("version.properties");){
                if (is == null) {
                    throw new IOException("missing version properties resource: version.properties");
                }
                try (InputStreamReader r = new InputStreamReader(is, StandardCharsets.UTF_8);){
                    Properties props = new Properties();
                    props.load(r);
                    tempVersion = (String)props.getOrDefault((Object)"version", "unknown");
                    tempGitInfo = (String)props.getOrDefault((Object)"git", "unknown");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        version = tempVersion;
        gitInfo = tempGitInfo;
    }
}

