/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster;

import com.couchbase.connector.cluster.PanicButton;
import com.google.common.base.Throwables;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPanicButton
implements PanicButton {
    private static final Logger log = LoggerFactory.getLogger(DefaultPanicButton.class);
    private final List<Runnable> prePanicHooks = new CopyOnWriteArrayList<Runnable>();

    @Override
    public void addPrePanicHook(Runnable hook) {
        this.prePanicHooks.add(Objects.requireNonNull(hook));
    }

    private void runPrePanicHooks() {
        try {
            ArrayList<Runnable> hooks = new ArrayList<Runnable>(this.prePanicHooks);
            Collections.reverse(hooks);
            hooks.forEach(it -> {
                try {
                    it.run();
                }
                catch (Throwable t) {
                    log.error("Pre-panic hook threw exception.", t);
                }
            });
        }
        catch (Throwable t) {
            log.error("Failed to invoke pre-panic hooks.", t);
        }
    }

    @Override
    public void mildPanic(String message) {
        try {
            this.runPrePanicHooks();
            if (DefaultPanicButton.runningInKubernetes()) {
                DefaultPanicButton.writeTerminationMessage(message);
            }
            log.warn("*** TERMINATING: {}", (Object)message);
        }
        finally {
            System.exit(1);
        }
    }

    @Override
    public void panic(String message, Throwable t) {
        try {
            this.runPrePanicHooks();
            if (DefaultPanicButton.runningInKubernetes()) {
                DefaultPanicButton.writeTerminationMessage((String)(t == null ? message : message + "\n" + Throwables.getStackTraceAsString((Throwable)t)));
            }
            log.error("PANIC: {}", (Object)message, (Object)t);
        }
        finally {
            System.exit(1);
        }
    }

    private static boolean runningInKubernetes() {
        return System.getenv("KUBERNETES_SERVICE_HOST") != null;
    }

    private static void writeTerminationMessage(String msg) {
        String path = "/dev/termination-log";
        try (OutputStreamWriter w = new OutputStreamWriter(new FileOutputStream(path));){
            w.write(msg + "\n");
        }
        catch (Exception e) {
            log.warn("Failed to write termination message to {}", (Object)path, (Object)e);
        }
    }
}

