/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KillSwitch {
    private static final Logger log = LoggerFactory.getLogger(KillSwitch.class);
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setName("kill-switch-scheduler");
        return t;
    });
    private ScheduledFuture<Void> future;
    private final Runnable deathRattle;
    private final Duration duration;

    private KillSwitch(Duration duration, Runnable deathRattle) {
        this.deathRattle = Objects.requireNonNull(deathRattle);
        this.duration = Objects.requireNonNull(duration);
        this.reset();
    }

    public static KillSwitch start(Duration duration, Runnable deathRattle) {
        return new KillSwitch(duration, deathRattle);
    }

    public synchronized void cancel() {
        if (this.future != null) {
            boolean cancelledSuccessfully = this.future.cancel(false);
            if (!cancelledSuccessfully) {
                log.error("Kill switch cancellation failed. Oh dear.");
            }
            this.future = null;
        }
    }

    public synchronized void reset() {
        this.cancel();
        this.future = executor.schedule(() -> {
            log.info("Kill switch activated.");
            try {
                this.deathRattle.run();
            }
            catch (Throwable t) {
                log.error("Kill switch death rattle threw exception.", t);
            }
            finally {
                System.exit(1);
            }
            return null;
        }, this.duration.toNanos(), TimeUnit.NANOSECONDS);
        log.debug("Kill switch reset; will activate in {} unless reset or cancelled.", (Object)this.duration);
    }
}

