/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster;

import com.couchbase.connector.dcp.DcpHelper;
import com.couchbase.connector.util.ListHelper;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class Membership {
    private final int memberNumber;
    private final int clusterSize;

    @JsonCreator
    public static Membership of(@JsonProperty(value="memberNumber") int memberNumber, @JsonProperty(value="clusterSize") int clusterSize) {
        return new Membership(memberNumber, clusterSize);
    }

    private Membership(int memberNumber, int clusterSize) {
        if (memberNumber <= 0 || memberNumber > clusterSize) {
            throw new IllegalArgumentException("Invalid static group membership number, must be between 1 and cluster size (" + clusterSize + ") inclusive.");
        }
        this.memberNumber = memberNumber;
        this.clusterSize = clusterSize;
    }

    public int getMemberNumber() {
        return this.memberNumber;
    }

    public int getClusterSize() {
        return this.clusterSize;
    }

    public Set<Integer> getPartitions(int numPartitions) {
        return new LinkedHashSet<Integer>((Collection)ListHelper.chunks(DcpHelper.allPartitions(numPartitions), this.clusterSize).get(this.memberNumber - 1));
    }

    public String toString() {
        return this.memberNumber + "/" + this.clusterSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Membership that = (Membership)o;
        if (this.memberNumber != that.memberNumber) {
            return false;
        }
        return this.clusterSize == that.clusterSize;
    }

    public int hashCode() {
        int result = this.memberNumber;
        result = 31 * result + this.clusterSize;
        return result;
    }
}

