/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster.consul;

import com.couchbase.connector.cluster.consul.ConsulContext;
import com.google.common.util.concurrent.Uninterruptibles;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLongPollTask<SELF extends AbstractLongPollTask>
implements AutoCloseable {
    private static final AtomicInteger threadCounter = new AtomicInteger();
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final Thread thread;
    private volatile boolean closed;

    public AbstractLongPollTask(ConsulContext ctx, String threadNamePrefix, String sessionId) {
        Objects.requireNonNull(ctx);
        Objects.requireNonNull(sessionId);
        this.thread = new Thread(() -> this.doRun(ctx, sessionId), threadNamePrefix + threadCounter.getAndIncrement());
    }

    protected abstract void doRun(ConsulContext var1, String var2);

    public void awaitTermination() {
        if (!this.closed) {
            throw new IllegalStateException("must call close() first");
        }
        Duration timeout = Duration.ofMinutes(1L);
        this.LOGGER.info("Waiting for thread {} to terminate.", (Object)this.thread);
        Uninterruptibles.joinUninterruptibly((Thread)this.thread, (Duration)timeout);
        if (this.thread.isAlive()) {
            this.LOGGER.error("Thread {} did not terminate within {}.", (Object)this.thread, (Object)timeout);
        } else {
            this.LOGGER.info("Thread {} terminated.", (Object)this.thread.getName());
        }
    }

    public SELF start() {
        try {
            this.thread.start();
            this.LOGGER.info("Thread {} started.", (Object)this.thread.getName());
            return (SELF)this;
        }
        catch (IllegalThreadStateException e) {
            throw new IllegalStateException("May only be started once", e);
        }
    }

    protected boolean closed() {
        return this.closed;
    }

    public void close(boolean awaitTermination) {
        this.closed = true;
        this.LOGGER.info("Asking thread {} to terminate.", (Object)this.thread.getName());
        this.thread.interrupt();
        if (awaitTermination) {
            this.awaitTermination();
        }
    }

    @Override
    public void close() {
        this.close(true);
    }
}

