/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster.consul;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncTask
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncTask.class);
    private static final AtomicInteger threadCounter = new AtomicInteger();
    private final Thread thread;
    private final AtomicReference<Throwable> connectorException = new AtomicReference();

    public static AsyncTask run(Interruptible task, Consumer<Throwable> fatalErrorListener) {
        return new AsyncTask(task, fatalErrorListener).start();
    }

    public static AsyncTask run(Interruptible task) {
        return AsyncTask.run(task, t -> {});
    }

    private AsyncTask(Interruptible task, Consumer<Throwable> fatalErrorListener) {
        Objects.requireNonNull(task);
        Objects.requireNonNull(fatalErrorListener);
        this.thread = new Thread(() -> {
            try {
                task.run();
            }
            catch (Throwable t) {
                this.connectorException.set(t);
                if (t instanceof InterruptedException) {
                    LOGGER.debug("Connector task interrupted");
                }
                LOGGER.error("Connector task exited early due to failure", t);
                fatalErrorListener.accept(t);
            }
        }, "connector-main-" + threadCounter.getAndIncrement());
    }

    private AsyncTask start() {
        try {
            this.thread.start();
            LOGGER.info("Thread {} started.", (Object)this.thread.getName());
            return this;
        }
        catch (IllegalThreadStateException e) {
            throw new IllegalStateException("May only be started once", e);
        }
    }

    public void stop() throws Throwable {
        this.thread.interrupt();
        Duration timeout = Duration.ofSeconds(30L);
        Uninterruptibles.joinUninterruptibly((Thread)this.thread, (Duration)timeout);
        if (this.thread.isAlive()) {
            throw new TimeoutException("Connector didn't exit within " + String.valueOf(timeout));
        }
        Throwable t = this.connectorException.get();
        if (t == null) {
            throw new IllegalStateException("Connector didn't exit by throwing exception");
        }
        if (!(t instanceof InterruptedException)) {
            throw t;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.stop();
        }
        catch (Throwable t) {
            Throwables.propagateIfPossible((Throwable)t, IOException.class);
            throw new RuntimeException(t);
        }
    }

    @FunctionalInterface
    public static interface Interruptible {
        public void run() throws Throwable;
    }
}

