/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster.consul;

import com.couchbase.connector.cluster.consul.ConsulContext;
import com.couchbase.connector.cluster.consul.LeaderController;
import com.couchbase.connector.cluster.consul.LeaderElectionTask;
import com.couchbase.connector.cluster.consul.LeaderTask;
import com.couchbase.connector.cluster.consul.SessionTask;
import com.couchbase.connector.cluster.consul.WorkerServiceImpl;
import com.couchbase.connector.cluster.consul.rpc.RpcServerTask;
import com.couchbase.connector.util.RuntimeHelper;
import com.couchbase.connector.util.ThrowableHelper;
import com.github.therapi.core.MethodRegistry;
import com.github.therapi.jackson.ObjectMappers;
import com.github.therapi.jsonrpc.DefaultExceptionTranslator;
import com.github.therapi.jsonrpc.ExceptionTranslator;
import com.github.therapi.jsonrpc.JsonRpcDispatcher;
import com.github.therapi.jsonrpc.JsonRpcError;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.net.BindException;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulConnector.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void run(final ConsulContext ctx) throws Exception {
        Throwable fatalError;
        block23: {
            LinkedBlockingQueue fatalErrorQueue = new LinkedBlockingQueue();
            Consumer<Throwable> errorConsumer = e -> {
                LOGGER.error("Got fatal error", e);
                fatalErrorQueue.add(e);
            };
            Thread shutdownHook = null;
            String endpointId = ctx.myEndpointId();
            LOGGER.info("Endpoint ID: {}", (Object)endpointId);
            WorkerServiceImpl workerService = new WorkerServiceImpl(e -> {
                LOGGER.error("Got fatal error", e);
                if (e instanceof BindException) {
                    System.err.println();
                    System.err.println("ERROR: " + String.valueOf(e));
                    System.err.println();
                    System.err.println("  This may occur if multiple connector workers running on the same host");
                    System.err.println("  all try to start an HTTP server on the same port. Try setting the");
                    System.err.println("  'httpPort' config option to 0 to use an ephemeral port instead.");
                    System.err.println();
                }
                System.exit(1);
            });
            MethodRegistry methodRegistry = new MethodRegistry(ObjectMappers.newLenientObjectMapper());
            methodRegistry.scan((Object)workerService);
            LOGGER.info("Registered JSON-RPC methods: {}", (Object)methodRegistry.getMethods());
            JsonRpcDispatcher dispatcher = JsonRpcDispatcher.builder((MethodRegistry)methodRegistry).exceptionTranslator((ExceptionTranslator)new DefaultExceptionTranslator(){

                protected JsonRpcError translateCustom(Throwable t) {
                    JsonRpcError error = super.translateCustom(t);
                    error.setData((Map)ImmutableMap.of((Object)"detail", (Object)ImmutableMap.of((Object)"exception", (Object)t.toString(), (Object)"stackTrace", (Object)Throwables.getStackTraceAsString((Throwable)t))));
                    return error;
                }
            }).build();
            LeaderController leaderController = new LeaderController(){
                private volatile LeaderTask leader;

                @Override
                public void startLeading() {
                    Preconditions.checkState((this.leader == null ? 1 : 0) != 0, (Object)"Already leading");
                    this.leader = new LeaderTask(ctx).start();
                }

                @Override
                public void stopLeading() {
                    if (this.leader != null) {
                        this.leader.stop();
                    }
                    this.leader = null;
                }
            };
            fatalError = null;
            try {
                try (SessionTask session = new SessionTask(ctx, workerService::resetKillSwitchTimer, errorConsumer).start();
                     RpcServerTask rpc = (RpcServerTask)new RpcServerTask(dispatcher, ctx, session.sessionId(), endpointId, errorConsumer).start();
                     LeaderElectionTask election = (LeaderElectionTask)new LeaderElectionTask(ctx, session.sessionId(), endpointId, errorConsumer, leaderController).start();){
                    shutdownHook = new Thread(() -> {
                        try {
                            LOGGER.info("Shutting down");
                            session.close();
                            election.close();
                            rpc.close();
                            ConsulConnector.reportTermination(ctx, null);
                        }
                        catch (Exception e) {
                            System.err.println(String.valueOf(Instant.now()) + " ERROR: Exception in connector shutdown hook.");
                            e.printStackTrace();
                        }
                    }, "consul-connector-shutdown");
                    RuntimeHelper.addShutdownHook(shutdownHook);
                    fatalError = (Throwable)fatalErrorQueue.take();
                }
                workerService.close();
                if (shutdownHook == null) break block23;
            }
            catch (Throwable throwable) {
                workerService.close();
                if (shutdownHook != null) {
                    RuntimeHelper.removeShutdownHook(shutdownHook);
                }
                ConsulConnector.reportTermination(ctx, fatalError);
                throw throwable;
            }
            RuntimeHelper.removeShutdownHook(shutdownHook);
        }
        ConsulConnector.reportTermination(ctx, fatalError);
        if (ThrowableHelper.hasCause(fatalError, RpcServerTask.EndpointAlreadyInUseException.class, new Class[0])) {
            System.err.println();
            System.err.println("ERROR: " + String.valueOf(fatalError));
            System.err.println();
            System.err.println("  This may occur if this worker previously terminated before it could");
            System.err.println("  gracefully end its Consul session. In that case, wait for the Consul");
            System.err.println("  lock delay to elapse (15 seconds by default) and try again.");
            System.err.println();
            System.err.println("  This can also happen if you're trying to run more than one connector");
            System.err.println("  worker in the same group using the same Consul agent without assigning");
            System.err.println("  each worker a unique Consul service ID. Specify a unique ID with the");
            System.err.println("  --service-id command line option.");
            System.err.println();
        }
    }

    private static void reportTermination(ConsulContext ctx, Throwable cause) {
        ctx.runCleanup(() -> ctx.reportShutdown(cause));
    }
}

